/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.clockonclockoff;

import au.com.ordermate.util.DateTimeUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.finance.timesheet.FinanceTimesheet;

class TimesheetRendererPanel
extends JPanel {
    private JLabel departmentLbl = new JLabel();
    private JLabel timeInLbl;
    private JLabel timeOutLbl;
    private JLabel shiftTimeLbl;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE HH:mm");

    public TimesheetRendererPanel() {
        super(new FlowLayout(0));
        this.departmentLbl.setHorizontalAlignment(2);
        this.departmentLbl.setPreferredSize(new Dimension(120, 10));
        this.add(this.departmentLbl);
        this.timeInLbl = new JLabel();
        this.timeInLbl.setHorizontalAlignment(2);
        this.timeInLbl.setPreferredSize(new Dimension(120, 10));
        this.add(this.timeInLbl);
        this.timeOutLbl = new JLabel();
        this.timeOutLbl.setHorizontalAlignment(2);
        this.timeOutLbl.setPreferredSize(new Dimension(120, 10));
        this.add(this.timeOutLbl);
        this.shiftTimeLbl = new JLabel();
        this.shiftTimeLbl.setHorizontalAlignment(2);
        this.add(this.shiftTimeLbl);
        if (this.timeInLbl.getFont().isBold()) {
            Font f = this.timeInLbl.getFont();
            f = f.deriveFont(f.getStyle() ^ 1);
            this.departmentLbl.setFont(f);
            this.timeInLbl.setFont(f);
            this.timeOutLbl.setFont(f);
            this.shiftTimeLbl.setFont(f);
        }
    }

    public void setTimeSheetData(FinanceTimesheet timesheet) {
        ExperimentalFeature useModsFeature = ExperimentalFeature.find((String)"Timesheets Use Mod");
        boolean useMods = useModsFeature != null && useModsFeature.getBooleanValue(Boolean.FALSE) != false;
        this.departmentLbl.setText(timesheet.getDepartment().getName());
        if (useMods) {
            this.timeInLbl.setText(dateFormatter.format(timesheet.getReportingTimeIn()));
        } else {
            this.timeInLbl.setText(dateFormatter.format(timesheet.getTimeIn()));
        }
        if (timesheet.getTimeOut() != null) {
            if (useMods) {
                this.timeOutLbl.setText(dateFormatter.format(timesheet.getReportingTimeOut()));
                this.shiftTimeLbl.setText(DateTimeUtils.getHoursMinutesForPeriod((long)DateTimeUtils.getDifferenceInMillisecs((Date)timesheet.getReportingTimeIn(), (Date)timesheet.getReportingTimeOut())));
            } else {
                this.timeOutLbl.setText(dateFormatter.format(timesheet.getTimeOut()));
                this.shiftTimeLbl.setText(DateTimeUtils.getHoursMinutesForPeriod((long)DateTimeUtils.getDifferenceInMillisecs((Date)timesheet.getTimeIn(), (Date)timesheet.getTimeOut())));
            }
        } else {
            this.timeOutLbl.setText("");
            this.shiftTimeLbl.setText("");
        }
    }
}

