/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.clockonclockoff;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import com.digitalpersona.onetouch.DPFPSample;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.users.User;
import waitermate.LoginManager;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.fingerprint.VerifyFingerprint;
import waitermate.gui.screens.admin.clockonclockoff.ClockOnClockOffScreen;

public class WaitermateFingerprintListener {
    private static WaitermateFingerprintListener instance;

    public static WaitermateFingerprintListener getInstance() {
        if (instance == null) {
            instance = new WaitermateFingerprintListener();
        }
        return instance;
    }

    protected WaitermateFingerprintListener() {
        WaiterMateInputAdapter.getInstance().fingerprintSampled.connect((Object)this, "gotFingerprintSample");
    }

    public void gotFingerprintSample(DPFPSample sample) {
        try {
            User user = this.acquireUser(sample);
            if (user == null) {
                new WaitermateGuiHandler().displayOkDialog("Rejected Fingerprint", "The given fingerprint is not enrolled.");
                return;
            }
            if (LoginManager.getInstance().getUser() == null) {
                LoginManager.getInstance().setUser(user);
            } else if (LoginManager.getInstance().getUser().equals((Object)user)) {
                ClockOnClockOffScreen.getInstance().start(user, LoginManager.getInstance().getUser(), null, false, sample, true);
            }
            LoginManager.getInstance().setUser(user);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot examine fingerprint", (Throwable)ex);
        }
    }

    public User acquireUser(DPFPSample sample) {
        User user = LoginManager.getInstance().getUser();
        VerifyFingerprint verify = VerifyFingerprint.makeVerifier(new WaitermateGuiHandler());
        if (user != null && verify.isMatch(sample, user, false)) {
            return user;
        }
        List activeUsers = PersistenceManager.getObjectList(User.class, (String)Query.select(User.class).active(User.class).not().isNull(User.Properties.LAST_LOGIN).orderBy(User.Properties.LAST_LOGIN, true).toString());
        user = verify.matchUser(sample, activeUsers, false);
        return user;
    }

    protected static void setInstance(WaitermateFingerprintListener listener) {
        instance = listener;
    }

    protected static void disconnectListener(WaitermateFingerprintListener listener) {
        WaiterMateInputAdapter.getInstance().fingerprintSampled.disconnect((Object)listener);
    }

    protected static void reConnectListener(WaitermateFingerprintListener listener) {
        WaiterMateInputAdapter.getInstance().fingerprintSampled.connect((Object)listener, "gotFingerprintSample");
    }
}

