/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import ordermate.database.Payable;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.finance.transactions.VoucherTopupReversalHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import org.apache.commons.collections.CollectionUtils;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.transactions.AbstractPaymentsScreen;
import waitermate.guikit.dialogs.Dialogs;

public class ClosedAccountRefundHelper {
    private Account currentAccount;
    private SellableWrapperFactory sellableFactory;
    private AbstractPaymentsScreen transactions;
    private VoucherTopupReversalHelper reversalHelper;

    public ClosedAccountRefundHelper(Account currentAccount, SellableWrapperFactory sellableFactory, AbstractPaymentsScreen transactions, VoucherTopupReversalHelper reversalHelper) {
        this.currentAccount = currentAccount;
        this.sellableFactory = sellableFactory;
        this.transactions = transactions;
        this.reversalHelper = reversalHelper;
    }

    public boolean doRefund() {
        List activeSellables;
        boolean commitRefundChanges = false;
        List allSellables = this.sellableFactory.getSellables(this.currentAccount.getAllItems(), this.currentAccount.getVoucherTxns());
        if (!CollectionUtils.isEqualCollection((Collection)allSellables, (Collection)(activeSellables = this.sellableFactory.getSellables((ItemGroup)this.currentAccount))) || this.reversalHelper.hasReversals()) {
            commitRefundChanges = Dialogs.displayChoiceDialog((String)("<html><h1>" + Internationalization.getLiteralFor((String)"REFUND") + "</h1><p>" + Internationalization.getLiteralFor((String)"IF_YOU_CONTINUE_THE_CHANGES_YOU_HAVE_MADE_TO_THE_ACCOUNT_WILL_BE_SAVED_TO_DB_1") + "<br>" + Internationalization.getLiteralFor((String)"IF_YOU_CONTINUE_THE_CHANGES_YOU_HAVE_MADE_TO_THE_ACCOUNT_WILL_BE_SAVED_TO_DB_2") + "<br>" + Internationalization.getLiteralFor((String)"IF_YOU_CONTINUE_THE_CHANGES_YOU_HAVE_MADE_TO_THE_ACCOUNT_WILL_BE_SAVED_TO_DB_3") + "<br>" + Internationalization.getLiteralFor((String)"IF_YOU_CONTINUE_THE_CHANGES_YOU_HAVE_MADE_TO_THE_ACCOUNT_WILL_BE_SAVED_TO_DB_4") + "</p>"), (String)Internationalization.getLiteralFor((String)"REFUND"), (boolean)false);
        } else if (!this.currentAccount.getDue().equals((Object)Price.ZERO_DOLLAR)) {
            Dialogs.displayOkDialog((String)("<html><h1>" + Internationalization.getLiteralFor((String)"NON_ZERO_BALANCE") + "</h1><br>" + Internationalization.getLiteralFor((String)"THE_ACCOUNT_HAS_A_NON_ZERO_DOLLAR_BALANCE") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_RECTIFY_THIS_IN_THE_PAYMENTS_SCREEN")), (String)Internationalization.getLiteralFor((String)"NON_ZERO_BALANCE"));
            this.gotTransactions(this.transactions);
        } else {
            if (Config.getBooleanValue((String)"debug")) {
                throw new IllegalStateException("Somehow account " + this.currentAccount + " needs refunding but it hasn't been changed!");
            }
            WaiterMate.LOG.warn("Somehow account " + this.currentAccount + " needs refunding but it hasn't been changed!");
            commitRefundChanges = true;
        }
        if (commitRefundChanges) {
            List errors = this.reversalHelper.reverseAll(this.currentAccount, LoginManager.getEventContext());
            if (errors != null) {
                if (!errors.isEmpty()) {
                    StringBuilder SB = new StringBuilder("The voucher transactions could not be reversed:\r\n");
                    for (VoucherResponse response : errors) {
                        SB.append(" - ");
                        SB.append(response.getDescription());
                        SB.append("\r\n");
                    }
                    Dialogs.displayOkDialog((String)SB.toString(), (String)"Voucher Reversal Failed");
                } else {
                    Dialogs.displayOkDialog((String)"Voucher transactions have been successfully reversed.", (String)"Reversal complete");
                }
            }
            WaitermateSaveAccount.getInstance().saveAccount(this.currentAccount, LoginManager.getEventContext());
            this.gotTransactions(this.transactions);
            this.transactions.setBackEnabled(false);
        }
        this.reversalHelper.clear();
        return commitRefundChanges;
    }

    void gotTransactions(AbstractPaymentsScreen transactions) {
        transactions.startTransactions((Payable)this.currentAccount, true, false);
    }

    public void gotItemsToRefund(Set selectedItems, Signal refreshSignal, Signal startSelect) {
        for (Object item : selectedItems) {
            if (item instanceof SalesLineItemWrapper) {
                SalesItem salesItem;
                SalesLineItem theItem = ((SalesLineItemWrapper)item).getSalesLineItem();
                if (!ExperimentalFeatureHelper.isWMShowComboItemsInOldWay() && theItem instanceof SalesItem && (salesItem = (SalesItem)theItem).getParentCombo() != null) {
                    theItem = salesItem.getParentCombo();
                }
                this.currentAccount.refundItem(theItem, Terminal.getLocalHost(), LoginManager.getInstance().getUser());
                continue;
            }
            if (item instanceof VoucherTransactionWrapper) {
                GiftVoucherTransaction theTransaction = ((VoucherTransactionWrapper)item).getSellingObject();
                this.reversalHelper.markForReversal(theTransaction);
                continue;
            }
            throw new IllegalArgumentException(item.getClass().getName() + " is not a supported type for refund/reversal.");
        }
        if (!this.doRefund()) {
            this.reversalHelper.clear();
            this.currentAccount = (Account)PersistenceManager.reacquire((PersistentObjectI)this.currentAccount);
            startSelect.emit();
        }
        refreshSignal.emit();
    }
}

