/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.closedaccountslist;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ordermate.database.finance.Shift;
import ordermate.database.sales.Customer;
import ordermate.gui.DisplayableString;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.dialogs.DateSelectDialog;
import waitermate.gui.screens.customer.SelectCustomer;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class AccountSearchPanel
extends JPanel
implements ActionListener {
    private CustomButton accountIDButton = new CustomButton();
    private AbstractButton dateButton = new JButton();
    private CustomButton customerButton = new CustomButton();
    private CustomButton shiftButton = new CustomButton();
    private CustomButton amountButton = new CustomButton();
    private CustomButton eftposReferenceButton = new CustomButton();
    public final Signal accountIDSignal = Signals.createSignal(Long.class, (String)"AccountID");
    public final Signal dateRangeSignal = Signals.createSignal(Date.class, (String)"startDate", Date.class, (String)"endDate");
    public final Signal customerSignal = Signals.createSignal(Customer.class, (String)"Customer");
    public final Signal shiftSignal = Signals.createSignal(String.class, (String)"Shift");
    public final Signal amountSignal = Signals.createSignal(Price.class, (String)"startPriceRange", Price.class, (String)"endPriceRange");
    public final Signal eftposReferenceSignal = Signals.createSignal(String.class, (String)"eftpsoReference");
    private Date startDate = Calendar.getInstance().getTime();
    private Date endDate = Calendar.getInstance().getTime();

    public AccountSearchPanel() {
        this.setName("accountSearchPanel");
        int width = 6;
        int totalWidth = 20;
        int totalHeight = 18;
        int height = 2;
        int y = 0;
        int borderPx = 10;
        this.setBorder(new EmptyBorder(borderPx, borderPx, borderPx, borderPx));
        this.setLayout((LayoutManager)new GraphPaperLayout(totalWidth, totalHeight));
        this.setPreferredSize(new Dimension(300, 440));
        this.initButtons();
        JLabel blankLine = new JLabel("");
        JLabel title = new JLabel("<HTML><H2>" + Internationalization.getLiteralFor((String)"ENTER_FIELDS_TO_SEARCH_ON") + ":</H2></HTML>");
        this.add((Component)title, new Rectangle(0, y, totalWidth, height));
        JLabel accountIDLabel = new JLabel(Internationalization.getLiteralFor((String)"RECEIPT_NUMBERSIGN"));
        this.add((Component)accountIDLabel, new Rectangle(0, y += height, width, 1));
        this.add((Component)this.accountIDButton, new Rectangle(width + 1, y, totalWidth - width - 1, height));
        this.add((Component)blankLine, new Rectangle(0, y++, totalWidth, 1));
        this.add((Component)new JLabel(Internationalization.getLiteralFor((String)"DATE_RANGE") + ":"), new Rectangle(0, y += height, width, 1));
        this.add((Component)this.dateButton, new Rectangle(width + 1, y, totalWidth - width - 1, height));
        this.add((Component)new JLabel(Internationalization.getLiteralFor((String)"SHIFT")), new Rectangle(0, y += height, width, 1));
        this.add((Component)this.shiftButton, new Rectangle(width + 1, y, totalWidth - width - 1, height));
        this.add((Component)blankLine, new Rectangle(0, y++, totalWidth, 1));
        this.add((Component)new JLabel(Internationalization.getLiteralFor((String)"CUSTOMER")), new Rectangle(0, y += height, width, height + 1));
        this.add((Component)this.customerButton, new Rectangle(width + 1, y++, totalWidth - width - 1, height + 1));
        this.add((Component)blankLine, new Rectangle(0, y++, totalWidth, 1));
        this.add((Component)new JLabel(Internationalization.getLiteralFor((String)"AMOUNT")), new Rectangle(0, y += height, width, 1));
        this.add((Component)this.amountButton, new Rectangle(width + 1, y, totalWidth - width - 1, height));
        this.add((Component)new JLabel(Internationalization.getLiteralFor((String)"EFTPOS_CODE")), new Rectangle(0, y += height, width, 1));
        this.add((Component)this.eftposReferenceButton, new Rectangle(width + 1, y, totalWidth - width - 1, height));
    }

    private void initButtons() {
        this.initButton((AbstractButton)this.accountIDButton).setName("accountIDButton");
        this.initButton(this.dateButton).setName("dateButton");
        this.initButton((AbstractButton)this.customerButton).setName("customerButton");
        this.initButton((AbstractButton)this.shiftButton).setName("shiftButton");
        this.initButton((AbstractButton)this.amountButton).setName("amountButton");
        this.initButton((AbstractButton)this.eftposReferenceButton).setName("eftposReferenceButton");
    }

    private AbstractButton initButton(AbstractButton button) {
        button.addActionListener(this);
        return button;
    }

    public void resetSearch(Shift shift) {
        this.accountIDButton.setText(Internationalization.getLiteralFor((String)"ANY"));
        this.dateButton.setText(shift.getTradingDay().getLabel());
        this.customerButton.setText("");
        this.shiftButton.setText(shift.getName());
        this.amountButton.setText("");
        this.eftposReferenceButton.setText("");
        this.startDate = Calendar.getInstance().getTime();
        this.endDate = Calendar.getInstance().getTime();
        this.disableAllButAccountID(false);
    }

    private void doAccountID() {
        KeypadDialog dialog = new KeypadDialog();
        dialog.setup(false);
        dialog.setMaxChars(10);
        dialog.setUnits(Internationalization.getLiteralFor((String)"ID") + " :");
        if (Dialogs.displayDialog((JComponent)dialog, (String)Internationalization.getLiteralFor((String)"ENTER_THE_RECEIPT_NUMBER"), (boolean)true)) {
            try {
                Long accountID = Long.valueOf(dialog.getValue());
                if (accountID > 0L) {
                    this.accountIDSignal.emit((Object)accountID);
                    this.accountIDButton.setData((Displayable)new DisplayableString("#" + accountID.toString()));
                    this.disableAllButAccountID(true);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.accountIDButton.setData((Displayable)new DisplayableString(Internationalization.getLiteralFor((String)"ANY")));
        this.accountIDSignal.emit(null);
        this.disableAllButAccountID(false);
    }

    private void doEftposReference() {
        KeypadDialog dialog = new KeypadDialog();
        dialog.setup(false);
        dialog.setMaxChars(16);
        dialog.setUnits(Internationalization.getLiteralFor((String)"REFERENCE_CODE") + " :");
        if (Dialogs.displayDialog((JComponent)dialog, (String)("<html>" + Internationalization.getLiteralFor((String)"ENTER_THE_EFTPOS_AUTHORISATION_CODE_OR_TRANSACTION_REFERENCE_1") + "<br>" + Internationalization.getLiteralFor((String)"ENTER_THE_EFTPOS_AUTHORISATION_CODE_OR_TRANSACTION_REFERENCE_2") + "</html>"), (boolean)true)) {
            try {
                String refCode = dialog.getValue();
                if (!refCode.isEmpty()) {
                    this.eftposReferenceSignal.emit((Object)refCode);
                    this.eftposReferenceButton.setData((Displayable)new DisplayableString("#" + refCode.toString()));
                    this.eftposReferenceButton.setName("eftposReferenceButton");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.eftposReferenceButton.setData((Displayable)new DisplayableString(""));
        this.eftposReferenceButton.setName("eftposReferenceButton");
        this.eftposReferenceSignal.emit(null);
    }

    private void disableAllButAccountID(boolean disableIt) {
        this.customerButton.setEnabled(!disableIt);
        this.shiftButton.setEnabled(!disableIt);
        this.dateButton.setEnabled(!disableIt);
        this.amountButton.setEnabled(!disableIt);
        this.eftposReferenceButton.setEnabled(!disableIt);
    }

    private void doDateRange() {
        DateSelectDialog dialog = new DateSelectDialog(true);
        dialog.setText(Internationalization.getLiteralFor((String)"SELECT_START_DATE"));
        if (dialog.go(this.startDate)) {
            this.startDate = dialog.getNewDate();
            dialog.setText(Internationalization.getLiteralFor((String)"SELECT_END_DATE"));
            if (dialog.go(this.endDate)) {
                this.endDate = dialog.getNewDate();
                if (this.startDate.after(this.endDate)) {
                    Date localDate = this.endDate;
                    this.endDate = this.startDate;
                    this.startDate = localDate;
                }
                this.startDate = DateTimeUtils.getStartOfDay((Date)this.startDate);
                this.endDate = DateTimeUtils.getEndOfDay((Date)this.endDate);
                String text = DateTimeUtils.getShortDateFormat().format(this.startDate);
                text = text + " - ";
                text = text + DateTimeUtils.getShortDateFormat().format(this.endDate);
                this.dateButton.setText(text);
                this.dateRangeSignal.emit((Object)this.startDate, (Object)this.endDate);
            }
        }
    }

    private void doShift() {
        String[] shifts = Shift.getShiftNames();
        List buttons = AbstractScrollPaneModel.constructButtons((String[])shifts);
        OnePressPopupWindow shiftNamePopup = new OnePressPopupWindow(Internationalization.getLiteralFor((String)"SELECT_SHIFT"), (Collection)buttons, 1, 4);
        JButton selectedButton = shiftNamePopup.start();
        if (selectedButton == null) {
            this.shiftSignal.emit(null);
            this.shiftButton.setData((Displayable)new DisplayableString(Internationalization.getLiteralFor((String)"ANY")));
        } else {
            String newShiftName = selectedButton.getText();
            this.shiftButton.setData((Displayable)new DisplayableString(newShiftName));
            this.shiftSignal.emit((Object)newShiftName);
        }
    }

    private void doAmount() {
        KeypadDialog dialog = new KeypadDialog();
        dialog.setup(true);
        dialog.setUnits(Internationalization.getLiteralFor((String)"AMOUNT") + " :");
        this.disableAllButAccountID(false);
        if (Dialogs.displayDialog((JComponent)dialog, (String)(Internationalization.getLiteralFor((String)"ENTER_AN_APPROXIMATE_AMOUNT") + ":"), (boolean)true)) {
            try {
                Price amount = new Price(Double.parseDouble(dialog.getValue()), 0.01);
                if (amount.intValue() > 0) {
                    Price startPriceRange = new Price(amount.doubleValue() * 0.8, 0.01);
                    Price endPriceRange = new Price(amount.doubleValue() * 1.2, 0.01);
                    this.amountSignal.emit((Object)startPriceRange, (Object)endPriceRange);
                    this.amountButton.setData((Displayable)new DisplayableString(startPriceRange + " - " + endPriceRange));
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.amountSignal.emit(null, null);
        this.amountButton.setData((Displayable)new DisplayableString(""));
    }

    private void doCustomer() {
        Customer cust = SelectCustomer.startModal(Collections.EMPTY_LIST, false);
        this.customerButton.setData((Displayable)cust);
        this.customerSignal.emit((Object)cust);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.accountIDButton) {
            this.doAccountID();
        } else if (e.getSource() == this.dateButton) {
            this.doDateRange();
        } else if (e.getSource() == this.customerButton) {
            this.doCustomer();
        } else if (e.getSource() == this.shiftButton) {
            this.doShift();
        } else if (e.getSource() == this.amountButton) {
            this.doAmount();
        } else if (e.getSource() == this.eftposReferenceButton) {
            this.doEftposReference();
        }
    }
}

