/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.closedaccountslist;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ClosedAccountRenderer
implements Renderer,
ActionListener {
    private static final DateFormat timeFormat = new SimpleDateFormat("h:mm a");
    private static final DateFormat dateTimeFormat = DateTimeUtils.getDateTimeFormat();
    public final Signal selected = Signals.createSignal(Account.class, (String)"account");
    private List<Account> selectedAccounts = new ArrayList<Account>();
    private Price runningTotal = new Price(0.0);

    public Component createComponent() {
        CustomButton button = new CustomButton();
        button.addActionListener((ActionListener)this);
        return button;
    }

    public void setupComponent(Component component, Object object, int index) {
        CustomButton button = (CustomButton)component;
        Account account = (Account)object;
        OrderMateTheme.setupUntoggledButton((AbstractButton)button);
        button.setData((Displayable)account);
        if (this.selectedAccounts.contains(account)) {
            OrderMateTheme.setupToggledButton((AbstractButton)button);
        } else if (account.hasCustomer()) {
            button.setIcon((Icon)IconLoader.get((String)"/waitermate/images/customerSingle.png"));
        } else {
            button.setIcon(null);
        }
        button.setText(this.getTextForButton(account));
    }

    public String getTextForButton(Account account) {
        StringBuffer buffer = new StringBuffer();
        List transactions = account.getFinanceTransactions();
        buffer.append(account.getRendererLabel());
        buffer.append(" ");
        if (transactions.size() == 1) {
            FinanceTransaction trans = (FinanceTransaction)transactions.get(0);
            buffer.append(trans.getSubType().getLabel());
            buffer.append(" ");
            buffer.append(trans.getPaid());
        } else if (transactions.size() > 1) {
            buffer.append("...");
        } else if (transactions.isEmpty() && account.isDebtorSale()) {
            String debtorName = account.getDebtor().getLabel();
            buffer.append(" ");
            buffer.append(debtorName);
        }
        buffer.append(" ");
        if (!transactions.isEmpty()) {
            FinanceTransaction transaction = (FinanceTransaction)transactions.get(transactions.size() - 1);
            DateFormat theFormat = transaction.getShift() == Terminal.getLocalHost().getShift() ? timeFormat : dateTimeFormat;
            buffer.append(theFormat.format(transaction.getCreationTime()));
            if (Terminal.getAllWaiterMateTerminals().size() > 1) {
                buffer.append(" ");
                buffer.append(transaction.getTerminal().getName());
            }
        }
        return buffer.toString();
    }

    public List getSelectedAccounts() {
        return this.selectedAccounts;
    }

    public Price getValueOfAccounts() {
        return this.runningTotal;
    }

    public void reset() {
        this.selectedAccounts = new ArrayList<Account>();
        this.runningTotal = new Price(0.0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CustomButton button = (CustomButton)event.getSource();
        Account account = (Account)button.getData();
        if (this.selectedAccounts.remove(account)) {
            OrderMateTheme.setupUntoggledButton((AbstractButton)button);
            this.runningTotal = this.runningTotal.subtract(account.getPaid());
        } else {
            this.selectedAccounts.add(account);
            OrderMateTheme.setupToggledButton((AbstractButton)button);
            this.runningTotal = this.runningTotal.add(account.getPaid());
        }
        this.selected.emit((Object)account);
    }
}

