/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.closedaccountslist;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.Shift;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.AccountSearchPanel;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.AccountTypeDrawerPanel;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.ClosedAccountListNavBar;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.ClosedAccountRenderer;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.PaymentTypeDrawerPanel;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class ClosedAccountsList
extends AbstractScreen
implements Refreshable {
    public final Signal back = Signals.createSignal();
    public final Signal account = Signals.createSignal(Account.class, (String)"selectedAccount");
    private CustomScrollPane gui;
    private RendererScrollPaneModel model;
    private ClosedAccountRenderer renderer;
    private ClosedAccountListNavBar nav;
    private AccountSearchPanel searchPanel = new AccountSearchPanel();
    private AccountTypeDrawerPanel accountTypePanel = new AccountTypeDrawerPanel();
    private PaymentTypeDrawerPanel paymentTypePanel = new PaymentTypeDrawerPanel();
    private AccountType initialAccountType;
    private Shift initialShift;
    private AccountSearcher accountSearcher = new AccountSearcher(3000, null);

    public ClosedAccountsList() {
        this.renderer = new ClosedAccountRenderer();
        this.renderer.selected.connect((Object)this, "gotAccount");
        this.model = new RendererScrollPaneModel((Renderer)this.renderer, 3, 8);
        this.gui = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.gui.setEmptyMessage(Internationalization.getLiteralFor((String)"THERE_ARE_NO_CLOSED_ACCOUNTS_FOR_THIS_DAY"));
        this.nav = new ClosedAccountListNavBar(this.searchPanel, this.accountTypePanel, this.paymentTypePanel);
        this.searchPanel.accountIDSignal.connect((Object)this, "gotAccountIDSearch");
        this.searchPanel.dateRangeSignal.connect((Object)this, "gotDateRangeSearch");
        this.searchPanel.customerSignal.connect((Object)this, "gotCustomerSearch");
        this.searchPanel.shiftSignal.connect((Object)this, "gotShiftNameSearch");
        this.searchPanel.amountSignal.connect((Object)this, "gotAmountSearch");
        this.searchPanel.eftposReferenceSignal.connect((Object)this, "gotAuthCodeSearch");
        this.accountTypePanel.changed.connect((Object)this, "gotAccountTypeChanged");
        this.paymentTypePanel.changed.connect((Object)this, "gotPaymentTypeChanged");
        this.nav.clear.connect((Object)this, "gotClearSearch");
        this.nav.back.connect((Object)this, "exitDisplay");
        this.nav.startQuickTraining.connect((Object)this, "startQuickTraining");
        this.nav.stopQuickTraining.connect((Object)this, "stopQuickTraining");
        this.nav.training.connect((Object)this, "assignToTraining");
    }

    void exitDisplay() {
        this.model.emptyComponents();
        this.model.removeAllObjects();
        this.back.emit();
    }

    void gotAccountIDSearch(Long accountID) {
        if (accountID != null) {
            this.accountSearcher.clearSearchFilterValues();
        }
        this.accountSearcher.setAccountID(accountID);
        this.refreshAccountList(true);
    }

    void gotCustomerSearch(Customer cust) {
        this.accountSearcher.setCustomerSearch(cust);
        this.refreshAccountList(true);
    }

    void gotDateRangeSearch(Date start, Date end) {
        if (start != null && end != null) {
            this.accountSearcher.setFinanceShift(null);
        }
        this.accountSearcher.setStartDateRange(start);
        this.accountSearcher.setEndDateRange(end);
        this.refreshAccountList(true);
    }

    void gotAmountSearch(Price startAmount, Price endAmount) {
        if (startAmount == null || endAmount == null) {
            this.accountSearcher.setFinanceTransactionAmount(null, null);
        } else {
            this.accountSearcher.setFinanceTransactionAmount(startAmount, endAmount);
        }
        this.refreshAccountList(true);
    }

    void gotAuthCodeSearch(String authCode) {
        this.accountSearcher.setAuthCode(authCode);
        this.refreshAccountList(true);
    }

    void gotShiftNameSearch(String name) {
        if (!this.accountSearcher.hasDateRange()) {
            this.accountSearcher.setStartDateRange(this.initialShift.getTradingDay().getDate());
            if (this.initialShift.getTradingDay().isOpen()) {
                this.accountSearcher.setEndDateRange(new Date());
            } else {
                this.accountSearcher.setEndDateRange(this.initialShift.getTradingDay().getCloseDateTime());
            }
            this.accountSearcher.setFinanceShift(null);
        }
        this.accountSearcher.setFinanceShiftName(name);
        this.refreshAccountList(true);
    }

    void gotAccountTypeChanged() {
        List selectedTypes = this.accountTypePanel.getSelectedAccountTypes();
        if (selectedTypes.isEmpty()) {
            this.accountTypePanel.setSelectedType(this.initialAccountType);
        } else {
            selectedTypes = this.accountTypePanel.getSelectedAccountTypes();
        }
        this.accountSearcher.setAccountTypes(selectedTypes);
        this.refreshAccountList(true);
    }

    void gotPaymentTypeChanged() {
        List selectedPaymentTypes = this.paymentTypePanel.getSelectedFinanceUnits();
        this.accountSearcher.setPaymentType(selectedPaymentTypes);
        this.refreshAccountList(true);
    }

    void gotClearSearch() {
        this.resetSearch();
    }

    public void showClosedAccounts(AccountType newAccountType, Shift newShift) {
        this.initialAccountType = newAccountType;
        this.initialShift = newShift;
        this.resetSearch();
        this.showClosedAccounts();
        this.gui.displayLastPage();
    }

    public void showClosedAccounts() {
        this.refreshAccountList(this.getNavBar().getClearButton().isVisible());
        this.display();
    }

    private void resetSearch() {
        this.accountSearcher.clearSearchFilterValues();
        this.accountSearcher.setAccountOpen(false);
        this.accountSearcher.setFinanceShift(this.initialShift);
        this.accountSearcher.setAccountTypes(Collections.singletonList(this.initialAccountType));
        this.searchPanel.resetSearch(this.initialShift);
        this.accountTypePanel.setSelectedObjects(Collections.singletonList(this.initialAccountType));
        this.paymentTypePanel.setSelectedObjects(new ArrayList());
        this.refreshAccountList(false);
    }

    public void refresh() {
        this.showClosedAccounts();
    }

    private void refreshAccountList(boolean showClearSearchButton) {
        this.nav.setup();
        this.renderer.reset();
        this.model.setObjects(PersistenceManager.getObjectList(Account.class, (String)this.accountSearcher.getObjectQuery().toString(), (Object[])new Object[0]));
        this.getNavBar().getClearButton().setVisible(showClearSearchButton);
    }

    void startQuickTraining() {
        this.renderer.reset();
        this.gui.displayPage(0);
    }

    void stopQuickTraining() {
        this.renderer.reset();
        this.gui.displayPage(0);
    }

    void gotAccount(Account theAccount) {
        if (this.nav.isQuickTrainingMode()) {
            this.nav.setLabel(this.renderer.getSelectedAccounts().size(), this.renderer.getValueOfAccounts());
        } else {
            this.account.emit((Object)theAccount);
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    void assignToTraining() {
        List accounts = this.renderer.getSelectedAccounts();
        WaitermateSaveAccount.getInstance().assignAccountsToTraining(accounts, this);
        this.showClosedAccounts();
    }
}

