/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.closedoptions;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.Shift;
import ordermate.database.sales.AccountType;
import ordermate.gui.ShiftSelector;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class ClosedOptionsGui
extends JPanel
implements ActionListener {
    public final Signal<AccountType, ?, ?, ?, ?> accountSelected = Signals.createSignal(AccountType.class, (String)"Account type");
    private final List excludeTypes = Arrays.asList(AccountType.refundType);
    private ShiftSelector shifts;

    public ClosedOptionsGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        JPanel types = new JPanel();
        AccountType[] accountTypes = AccountType.getTypes();
        types.setLayout(new GridLayout(0, accountTypes.length - this.excludeTypes.size(), 20, 20));
        types.setBorder(new CompoundBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SELECT_ACCOUNT_TYPE") + " :"), new EmptyBorder(0, 5, 5, 5)));
        for (int i = 0; i < accountTypes.length; ++i) {
            if (this.excludeTypes.contains(accountTypes[i])) continue;
            AccountTypeButton button = new AccountTypeButton(accountTypes[i]);
            button.addActionListener(this);
            types.add(button);
        }
        this.add((Component)types, new Rectangle(1, 1, 8, 4));
        this.shifts = new ShiftSelector();
        this.shifts.setTextFont(OrderMateTheme.getMediumFont());
        this.shifts.setBorder((Border)new CompoundBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SELECT_DAY_SHIFT") + " :"), new EmptyBorder(0, 5, 5, 5)));
        this.add((Component)this.shifts, new Rectangle(3, 6, 4, 2));
    }

    public void refreshTradingDays() {
        this.shifts.setShifts(Shift.getShifts());
    }

    public Shift getShift() {
        return this.shifts.getShift();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AccountTypeButton) {
            AccountTypeButton source = (AccountTypeButton)e.getSource();
            this.accountSelected.emit((Object)source.getType());
        }
    }

    private static class AccountTypeButton
    extends JButton {
        private AccountType type;

        public AccountTypeButton(AccountType newType) {
            super("<HTML>" + newType.getLabel() + "<BR>" + Internationalization.getLiteralFor((String)"ACCOUNTS") + "</HTML>");
            this.type = newType;
        }

        public AccountType getType() {
            return this.type;
        }
    }
}

