/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.closedaccounts.viewclosedaccount;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.closedaccounts.viewclosedaccount.WaiterMateEmailTaxInvoiceAction;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;

public class ClosedAccountNav
extends NavBar {
    public final Signal save = Signals.createSignal();
    public final Signal financeInfo = Signals.createSignal();
    public final Signal training = Signals.createSignal();
    public final Signal payment = Signals.createSignal();
    public final Signal showItems = Signals.createSignal();
    public final Signal refundSignal = Signals.createSignal();
    private StandardSecurityDecorator paymentDecorator;
    private StandardSecurityDecorator saveDecorator;
    private StandardSecurityDecorator refundDecorator;
    private JButton financeInfoButton;
    private JButton trainingModeButton;
    private JButton showItemsButton;
    private JButton emailTaxInvoiceButton;

    public ClosedAccountNav() {
        JButton refundButton = this.constructButton(IconLoader.get((String)"/waitermate/images/money_down.png"), Internationalization.getLiteralFor((String)"REFUND"), "Refund", this.refundSignal);
        this.refundDecorator = new StandardSecurityDecorator((JComponent)refundButton, AllPermissions.PAY_CLOSED_ACCOUNT);
        this.addRight((Component)this.refundDecorator);
        this.trainingModeButton = this.constructButton(IconLoader.get((String)"/waitermate/images/trainingmode.png"), Internationalization.getLiteralFor((String)"ALLOCATE_TO_TRAINING"), "Training", this.training);
        if (SystemProperty.getInstance().isTrainingModeEnabled()) {
            this.addRight((Component)new StandardSecurityDecorator((JComponent)this.trainingModeButton, AllPermissions.TRAINING_MODE));
        }
        this.showItemsButton = this.constructButton(IconLoader.get((String)"/waitermate/images/page.png"), Internationalization.getLiteralFor((String)"SHOW_ORDER"), "ShowOrder", new Insets(0, 8, 0, 8), this.showItems);
        this.addRight(this.showItemsButton);
        this.financeInfoButton = this.constructButton(IconLoader.get((String)"/waitermate/images/page.png"), Internationalization.getLiteralFor((String)"FINANCE_INFO"), "FinanceInfo", this.financeInfo);
        this.addRight(this.financeInfoButton);
        this.emailTaxInvoiceButton = this.constructButton(WaiterMateEmailTaxInvoiceAction.ICON, Internationalization.getLiteralFor((String)"EMAIL_TAX_INVOICE"), WaiterMateEmailTaxInvoiceAction.NAME);
        this.addRight(this.emailTaxInvoiceButton);
        JButton paymentButton = this.constructButton(IconLoader.get((String)"/waitermate/images/pay.png"), Internationalization.getLiteralFor((String)"PAYMENTS"), "Payments", this.payment);
        this.paymentDecorator = new StandardSecurityDecorator((JComponent)paymentButton, AllPermissions.PAY_CLOSED_ACCOUNT);
        this.addRight((Component)this.paymentDecorator);
        this.addRight((Component)new StandardSecurityDecorator((JComponent)this.getPrintButton(), AllPermissions.PRINT_BILL));
        JButton saveButton = this.constructButton(IconLoader.get((String)"/waitermate/images/save.png"), Internationalization.getLiteralFor((String)"SAVE"), "Save", this.save);
        saveButton.setName("saveButton");
        this.saveDecorator = new StandardSecurityDecorator((JComponent)saveButton, AllPermissions.SAVE);
        this.addRight((Component)this.saveDecorator);
        this.addLeft(this.getBackButton());
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "newUser");
    }

    public void setFinanceInfoVisible(boolean show) {
        this.financeInfoButton.setVisible(show);
    }

    public void setTrainingModeButtonVisible(boolean show) {
        this.trainingModeButton.setVisible(show);
    }

    public void setup(boolean isDebtorSale) {
        this.paymentDecorator.setVisible(!isDebtorSale);
        this.refundDecorator.setVisible(!isDebtorSale);
        this.saveDecorator.setVisible(!isDebtorSale);
    }

    public void setRefundButtonVisible(boolean isVisible) {
        this.refundDecorator.setVisible(isVisible);
    }

    public void newUser(User newUser) {
        this.setTrainingModeButtonVisible(newUser.hasPermission(AllPermissions.TRAINING_MODE));
    }

    public void setPaymentButtonVisible(boolean isVisible) {
        this.paymentDecorator.setVisible(isVisible);
    }

    public JButton getEmailTaxInvoiceButton() {
        return this.emailTaxInvoiceButton;
    }
}

