/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.completeddeliveries;

import java.awt.Component;
import javax.swing.JComponent;
import ordermate.database.sales.Delivery;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.completeddeliveries.SelectDeliveryGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class SelectDelivery
extends AbstractScreen {
    private SelectDeliveryGui gui;
    private NavBar nav;
    public final Signal done = Signals.createSignal();
    public final Signal deliverySelected = Signals.createSignal(Delivery.class, (String)"Selected Delivery");

    public SelectDelivery() {
        this.gui = new SelectDeliveryGui();
        this.gui.delivery.connect((Object)this, "gotDelivery");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.setText(Internationalization.getLiteralFor((String)"VIEW_COMPLETED_DELIVERIES"));
        this.nav.back.connect((Object)this, "stopScreen");
        this.nav.ok.connect((Object)this, "stopScreen");
    }

    public void gotDelivery(Delivery theDelivery) {
        this.deliverySelected.emit((Object)theDelivery);
    }

    public void selectClosedOptions() {
        this.gui.reloadShifts();
        this.gui.displayDeliveries();
        this.display();
    }

    public void done() {
        this.gui.refresh();
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void stopScreen() {
        this.done.emit();
    }
}

