/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.completeddeliveries;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.Account;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.DeliveryAccountItemRenderer;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;

public class ViewDelivery
extends AbstractScreen {
    public final Signal accountSelected = Signals.createSignal(Account.class, (String)"selectedAccount");
    public final Signal back = Signals.createSignal();
    private JPanel gui = this.createGUI();
    private NavBar nav = new NavBar();
    private CustomScrollPane accountsPane;
    private RendererScrollPaneModel<PhoneAccount> accounts;
    private JLabel deliveryInfo;
    private Delivery theDelivery;

    public ViewDelivery() {
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.back.connect((Object)this.back, "emit");
        this.nav.ok.connect((Object)this.back, "emit");
        this.nav.setText(Internationalization.getLiteralFor((String)"ACCOUNTS_CONTAINED_IN_THIS_DELIVERY"));
        this.back.connect((Object)this, "gotDone");
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotUserLogin");
    }

    private final JPanel createGUI() {
        JPanel returnPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(8, 10)));
        DeliveryAccountItemRenderer renderer = new DeliveryAccountItemRenderer();
        this.accounts = new RendererScrollPaneModel((Renderer)renderer, 1, 6);
        this.accountsPane = new CustomScrollPane(this.accounts);
        this.deliveryInfo = new JLabel();
        renderer.account.connect((Object)this, "gotAccountPressed");
        returnPanel.add((Component)this.accountsPane, new Rectangle(1, 1, 6, 9));
        returnPanel.add((Component)this.deliveryInfo, new Rectangle(2, 0, 6, 1));
        return returnPanel;
    }

    public void showDelivery(Delivery delivery) {
        if (delivery == null) {
            throw new IllegalArgumentException("Delivery should not be null");
        }
        this.theDelivery = delivery;
        List newData = this.theDelivery.getAccounts();
        this.accounts.setObjects(newData);
        this.deliveryInfo.setText(this.theDelivery.getDeliveryDetails());
        this.display();
    }

    public void show() {
        if (this.theDelivery != null) {
            this.theDelivery = (Delivery)PersistenceManager.reacquire((PersistentObjectI)this.theDelivery);
            List newData = this.theDelivery.getAccounts();
            this.accounts.setObjects(newData);
            this.deliveryInfo.setText(this.theDelivery.getDeliveryDetails());
            this.display();
        } else {
            this.gotDone();
        }
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    void gotAccountSelected(Account selectedAccount) {
        this.accountSelected.emit((Object)selectedAccount);
    }

    public JComponent nav() {
        return this.nav;
    }

    public void gotAccountPressed(Account it) {
        this.accountSelected.emit((Object)it);
    }

    public void gotDone() {
        if (this.theDelivery != null) {
            this.theDelivery.unlock();
        }
        this.theDelivery = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotUserLogin(User user) {
        if (this.theDelivery != null) {
            Delivery delivery = this.theDelivery;
            synchronized (delivery) {
                if (!this.theDelivery.isLocked(user)) {
                    this.theDelivery.unlock();
                    this.theDelivery.lock(user);
                }
            }
        }
    }
}

