/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.customer;

import au.com.ordermate.util.image.IconLoader;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.database.sales.Customer;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.customer.CustomerAdminPanel;
import waitermate.gui.screens.customer.add.AddCustomer;
import waitermate.gui.screens.customer.search.CustomerSearch;

public class CustomerAdmin
extends AbstractAdminScreen {
    private AddCustomer addCustomer;
    private CustomerSearch customerSearch;
    private CustomerAdminPanel gui;

    public CustomerAdmin() {
        CustomerSearch.terminalSetupChanged.connect((Object)this, "gotTerminalChanged");
        this.gui = new CustomerAdminPanel();
        this.gui.searchCustomer.connect((Object)this, "gotCustomerSearch");
        this.gui.addCustomer.connect((Object)this, "gotAddCustomer");
    }

    @Override
    public Icon getCategoryIcon() {
        return IconLoader.get((String)"/waitermate/images/customer.png");
    }

    @Override
    public String getCategoryName() {
        return Internationalization.getLiteralFor((String)"CUSTOMERS");
    }

    public void startAdmin() {
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    void gotAddCustomer() {
        this.initAddCustomer();
        this.addCustomer.add(Customer.REQUIRE_BASIC);
    }

    void gotCustomerSaved(Customer customer) {
        this.back.emit();
    }

    void gotCustomer(Customer theCustomer) {
        this.initAddCustomer();
        this.addCustomer.edit(theCustomer, Customer.REQUIRE_BASIC);
    }

    public void gotNewCustomerSelected() {
        this.initAddCustomer();
        this.initCustomerSearch();
        this.addCustomer.add(this.customerSearch.getEnteredProperties(), Customer.REQUIRE_BASIC);
    }

    private void initCustomerSearch() {
        if (this.customerSearch == null) {
            this.customerSearch = new CustomerSearch(Customer.REQUIRE_FIRST_NAME, true, true);
            this.customerSearch.selected.connect((Object)this, "gotCustomer");
            this.customerSearch.back.connect(this.back);
            this.customerSearch.edit.connect((Object)this, "gotEditCustomerSelected");
            this.customerSearch.add.connect((Object)this, "gotNewCustomerSelected");
        }
    }

    private void initAddCustomer() {
        if (this.addCustomer == null) {
            this.addCustomer = new AddCustomer(Customer.REQUIRE_BASIC);
            this.addCustomer.customerSaved.connect((Object)this, "gotCustomerSaved");
            this.addCustomer.back.connect(this.back);
        }
    }

    public void gotEditCustomerSelected(Customer theCustomer) {
        this.initAddCustomer();
        this.addCustomer.edit(theCustomer, Customer.REQUIRE_BASIC);
    }

    public void gotCustomerSearch() {
        this.initCustomerSearch();
        this.customerSearch.reset();
        this.customerSearch.display();
    }

    void gotTerminalChanged() {
        if (this.customerSearch != null) {
            this.customerSearch.selected.disconnect((Object)this);
            this.customerSearch.back.disconnect((Object)this.back);
            this.customerSearch.edit.disconnect((Object)this);
            this.customerSearch.add.disconnect((Object)this);
        }
        this.customerSearch = null;
        this.addCustomer.customerSaved.disconnect((Object)this);
        this.addCustomer.back.disconnect((Object)this.back);
        this.addCustomer = null;
    }
}

