/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.daily;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import com.assemblypayments.spi.model.SchemeSettlementEntry;
import com.assemblypayments.spi.model.Settlement;
import com.assemblypayments.spi.model.TransactionFlowState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposPrintProcessor;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.gui.SaveAccount;
import ordermate.integration.eftpos.assembly.AssemblyEftpos;
import ordermate.integration.eftpos.assembly.AssemblyEftposFactory;
import ordermate.integration.eftpos.assembly.AssemblyEvent;
import ordermate.integration.eftpos.assembly.AssemblyEventHandler;
import ordermate.integration.eftpos.manager.DefaultIntegratedPaymentUI;
import ordermate.integration.eftpos.manager.EftposToolkit;
import ordermate.integration.eftpos.manager.IntegratedPaymentUI;
import ordermate.internationalization.Internationalization;
import ordermate.services.hardware.physical.eftpos.EftposPrintProcessorFactory;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.guikit.dialogs.PopupWindow;

public class AssemblyEftposSettlementGUI
extends PopupWindow
implements ActionListener,
AssemblyEventHandler {
    private JTextArea textArea;
    private JPanel bottomPanel;
    private JButton settleButton;
    private JButton printButton;
    private final int WIDTH = 600;
    private final int HEIGHT = 400;
    private final EftposPrintProcessor printProcessor;
    private VirtualEftpos eftpos;
    private AssemblyEftpos assembly;
    private JPanel blocker;
    private WaitermateGuiHandler guiHandler;

    public AssemblyEftposSettlementGUI(VirtualEftpos eftpos) {
        this.eftpos = eftpos;
        this.printProcessor = EftposPrintProcessorFactory.createEftposPrintProcessor();
        this.initGUI();
        this.guiHandler = new WaitermateGuiHandler();
    }

    private void initGUI() {
        JPanel allComponentPanel = new JPanel();
        allComponentPanel.setLayout(new BorderLayout());
        allComponentPanel.setPreferredSize(new Dimension(600, 400));
        String titleBorderText = Internationalization.getLiteralFor((String)"SETTLEMENT_DETAILS") + this.eftpos.getLabel();
        JPanel topContainerPanel = new JPanel();
        topContainerPanel.setLayout(new BorderLayout());
        topContainerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), titleBorderText, 0, 0));
        this.textArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        topContainerPanel.add((Component)scrollPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridLayout(1, 3, 5, 0));
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bottomPanel.setPreferredSize(new Dimension(this.bottomPanel.getPreferredSize().width, 75));
        this.settleButton = this.createButton(Internationalization.getLiteralFor((String)"SETTLE"));
        this.printButton = this.createButton(Internationalization.getLiteralFor((String)"PRINT"));
        allComponentPanel.add((Component)topContainerPanel, "Center");
        allComponentPanel.add((Component)this.bottomPanel, "South");
        this.setComponent(allComponentPanel);
        this.getNavBar().removeLeft((Component)this.getNavBar().getCancelButton());
        this.blocker = new JPanel(new BorderLayout(20, 20));
        this.blocker.setPreferredSize(new Dimension(400, 80));
        this.blocker.setBorder(new LineBorder(Color.BLACK));
        JLabel progressLabel = new JLabel("Initiating Settlement");
        progressLabel.setHorizontalAlignment(0);
        this.blocker.add((Component)progressLabel, "Center");
    }

    private JButton createButton(String text) {
        JButton button = new JButton(text);
        button.addActionListener(this);
        this.bottomPanel.add(button);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source == this.printButton) {
            this.printSettlement();
        } else if (source == this.settleButton) {
            this.initiateSettlementAction();
        }
    }

    private void initiateSettlementAction() {
        this.assembly = AssemblyEftposFactory.getAssemblyEftpos((EftposToolkit)new EftposToolkit((GuiHandler)this.guiHandler, (SaveAccount)WaitermateSaveAccount.getInstance(), (IntegratedPaymentUI)new DefaultIntegratedPaymentUI((GuiHandler)this.guiHandler)), (VirtualEftpos)this.eftpos);
        if (!this.assembly.isConnected(Terminal.getLocalHost())) {
            return;
        }
        this.guiHandler.closeBlockingDialog(this.blocker);
        Runnable settler = new Runnable(){

            @Override
            public void run() {
                AssemblyEftposSettlementGUI.this.guiHandler.displayBlockingDialog(AssemblyEftposSettlementGUI.this.blocker);
                AssemblyEftposSettlementGUI.this.assembly.getContext().getAssemblyEftposSpi().setAssemblyEventHandler((AssemblyEventHandler)AssemblyEftposSettlementGUI.this);
                String output = AssemblyEftposSettlementGUI.this.assembly.getContext().getAssemblyEftposSpi().initiateSettlementTxn();
                if (output != null) {
                    AssemblyEftposSettlementGUI.this.guiHandler.closeBlockingDialog(AssemblyEftposSettlementGUI.this.blocker);
                    AssemblyEftposSettlementGUI.this.guiHandler.displayOkDialog("Cannot Initiate Settlement", output);
                }
            }
        };
        new Thread(settler).start();
    }

    private void printSettlement() {
        String fullSettlementString = this.textArea.getText();
        this.printProcessor.printEftposDocket(fullSettlementString, null, false);
    }

    private void handleTransactionEvent(AssemblyEvent<TransactionFlowState> event) {
        TransactionFlowState state = (TransactionFlowState)event.getEventDetails();
        switch (state.getType()) {
            case SETTLEMENT_ENQUIRY: {
                this.handleSettlement(state);
                break;
            }
            case SETTLE: {
                this.handleSettlement(state);
            }
        }
        ((JLabel)this.blocker.getComponent(0)).setText(((TransactionFlowState)event.getEventDetails()).getDisplayMessage());
        if (((TransactionFlowState)event.getEventDetails()).isFinished()) {
            this.assembly.getContext().getAssemblyEftposSpi().setOperationComplete();
            this.guiHandler.closeBlockingDialog(this.blocker);
        }
    }

    private void printSuccessfulSettlementEnquiryReceipt(TransactionFlowState state) {
        String lineSeparator = System.getProperty("line.separator");
        ArrayList<String> printerLines = new ArrayList<String>();
        if (state.getResponse() != null) {
            Settlement settleResponse = new Settlement(state.getResponse());
            printerLines.add("# Response: " + settleResponse.getResponseText());
            printerLines.add("# Merchant receipt:");
            printerLines.add(settleResponse.getMerchantReceipt().trim());
            printerLines.add("# Period start: " + settleResponse.getPeriodStartTime());
            printerLines.add("# Period end: " + settleResponse.getPeriodEndTime());
            printerLines.add("# Settlement time: " + settleResponse.getTriggeredTime());
            printerLines.add("# Transaction range: " + settleResponse.getTransactionRange());
            printerLines.add("# Terminal ID: " + settleResponse.getTerminalId());
            printerLines.add("# Total TX count: " + settleResponse.getTotalCount());
            printerLines.add("# Total TX value: " + (double)settleResponse.getTotalValue() / 100.0);
            printerLines.add("# By acquirer TX count: " + settleResponse.getSettleByAcquirerCount());
            printerLines.add("# By acquirer TX value: " + (double)settleResponse.getSettleByAcquirerValue() / 100.0);
            printerLines.add("# SCHEME SETTLEMENTS:");
            Iterable schemes = settleResponse.getSchemeSettlementEntries();
            for (SchemeSettlementEntry s : schemes) {
                printerLines.add("# " + s);
            }
            this.textArea.setText(StringUtils.mergeWithSeparator(printerLines, (String)lineSeparator));
        }
    }

    private void printFailedSettlementEnquiryReceipt(TransactionFlowState state) {
        String lineSeparator = System.getProperty("line.separator");
        ArrayList<String> printerLines = new ArrayList<String>();
        printerLines.add("# SETTLEMENT FAILED!");
        if (state.getResponse() != null) {
            Settlement settleResponse = new Settlement(state.getResponse());
            printerLines.add("# Response: " + settleResponse.getResponseText());
            printerLines.add("# Error: " + state.getResponse().getError());
            printerLines.add("# Merchant receipt:");
            printerLines.add(settleResponse.getMerchantReceipt().trim());
        }
        this.textArea.setText(StringUtils.mergeWithSeparator(printerLines, (String)lineSeparator));
    }

    private void handleSettlement(TransactionFlowState state) {
        switch (state.getSuccess()) {
            case SUCCESS: {
                this.printSuccessfulSettlementEnquiryReceipt(state);
                break;
            }
            case FAILED: {
                this.printFailedSettlementEnquiryReceipt(state);
                break;
            }
            case UNKNOWN: {
                OrderMate.LOG.error("Settlement enquiry completed with UNKNOWN status");
            }
        }
    }

    public void onAssemblyEvent(AssemblyEvent event) {
        switch (event.getEventType()) {
            case TRANSACTION_EVENT: {
                this.handleTransactionEvent((AssemblyEvent<TransactionFlowState>)event);
            }
        }
    }
}

