/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.daily;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.integration.eftpos.assembly.AssemblyEftposHelper;
import ordermate.integration.eftpos.manager.EftposManager;
import ordermate.integration.eftpos.nitroskyzer.NitroSkyzerUtil;
import ordermate.integration.videopro.CCTVIntegration;
import ordermate.internationalization.Internationalization;
import ordermate.services.hardware.physical.eftpos.CashDrawerManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMateUpdater;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.AdminCategoryPanel;
import waitermate.gui.screens.admin.SelectUnlockAccount;
import waitermate.gui.screens.admin.cashout.CashOut;
import waitermate.gui.screens.admin.clockonclockoff.ClockOnClockOffScreen;
import waitermate.gui.screens.admin.closedaccounts.ClosedAccounts;
import waitermate.gui.screens.admin.completeddeliveries.CompletedDeliveries;
import waitermate.gui.screens.admin.daily.AssemblyEftposSettlementGUI;
import waitermate.gui.screens.admin.daily.DailyAdminPanel;
import waitermate.gui.screens.admin.daily.errorlog.ErrorLogScreen;
import waitermate.gui.screens.admin.daily.tipadjust.FastTipAdjust;
import waitermate.gui.screens.admin.daily.triggers.TriggerActivationScreen;
import waitermate.gui.screens.admin.messageoftheday.MessageOfTheDay;
import waitermate.gui.screens.admin.reports.WaitermateReports;
import waitermate.gui.screens.admin.shift.ChangeTradingDayOrShift;
import waitermate.gui.screens.admin.skims.Skims;
import waitermate.gui.screens.admin.stockcount.StockCountScreen;
import waitermate.gui.screens.admin.surchargesdiscounts.SurchargesDiscounts;
import waitermate.gui.screens.admin.tablesetup.TableSetup;
import waitermate.gui.screens.admin.vouchers.WaitermateVoucherSearch;
import waitermate.gui.screens.pettycash.WMPettyCashScreen;
import waitermate.gui.screens.reconciliation.WMReconciliationScreen;
import waitermate.gui.screens.selectaccount.table.staleaccounts.StaleAccounts;
import waitermate.gui.screens.transaction.WMFinanceTxnScreen;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class DailyAdmin
extends AbstractAdminScreen {
    public final Signal logout = Signals.createSignal();
    private DailyAdminPanel gui = new DailyAdminPanel();
    private SurchargesDiscounts surchargeGui;
    private WaitermateReports reportsGui;
    private Skims skimsGui;
    private WMPettyCashScreen pettyCash;
    private WMReconciliationScreen reconciliations;
    private CompletedDeliveries completedDeliveries;
    private TableSetup tableSetupGui;
    private ClosedAccounts closedAccounts;
    private SelectUnlockAccount unlockAccount;
    private MessageOfTheDay messageOfTheDay;
    private CashOut cashout;
    private StockCountScreen invItemSearchGui;
    private ErrorLogScreen errorLogScreen;
    private WaitermateVoucherSearch voucherSearchGui;
    private WMFinanceTxnScreen txnGui;
    private StaleAccounts staleAccounts;
    private AdminCategoryPanel adminCategoryPanel;

    public DailyAdmin() {
        this.gui.clockOnOff.connect((Object)this, "gotClockOnOff");
        this.gui.openDrawer.connect((Object)this, "gotOpenCashDrawer");
        this.gui.cashdrawer.connect((Object)this, "gotCashdrawer");
        this.gui.surcharges.connect((Object)this, "gotSurcharge");
        this.gui.reports.connect((Object)this, "gotReports");
        this.gui.closedAccounts.connect((Object)this, "gotClosedAccounts");
        this.gui.completedDeliveries.connect((Object)this, "gotCompletedDeliveries");
        this.gui.tableSetup.connect((Object)this, "gotTableSetup");
        this.gui.unlockAccounts.connect((Object)this, "gotUnlockAccount");
        this.gui.messageOfTheDay.connect((Object)this, "gotMOTD");
        this.gui.invItemSearch.connect((Object)this, "gotItemSearch");
        this.gui.cashout.connect((Object)this, "gotCashout");
        this.gui.changeShift.connect((Object)this, "gotChangeShift");
        this.gui.errorLog.connect((Object)this, "gotErrorLog");
        this.gui.adjustTips.connect((Object)this, "gotAdjustTips");
        this.gui.voucherSearch.connect((Object)this, "gotVoucherSearch");
        this.gui.triggerActivation.connect((Object)this, "gotTriggerActivation");
        this.gui.financeTransaction.connect((Object)this, "gotFinanceTransactions");
        this.gui.eftposSettlement.connect((Object)this, "invokeSettlement");
        this.gui.eftposControlPanel.connect((Object)this, "invokeControlPanel");
        this.gui.staleAccounts.connect((Object)this, "gotStaleAccounts");
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "setupNoSaleButton");
    }

    public DailyAdmin(AdminCategoryPanel adminCategoryPanel) {
        this();
        this.adminCategoryPanel = adminCategoryPanel;
    }

    public AdminCategoryPanel getAdminCategoryPanel() {
        return this.adminCategoryPanel;
    }

    public void gotErrorLog() {
        if (this.errorLogScreen == null) {
            this.errorLogScreen = new ErrorLogScreen();
            this.errorLogScreen.back.connect(this.back);
        }
        this.errorLogScreen.showErrorLog();
    }

    public void gotItemSearch() {
        if (this.invItemSearchGui == null) {
            this.invItemSearchGui = new StockCountScreen();
            this.invItemSearchGui.back.connect(this.back);
        }
        this.invItemSearchGui.display();
    }

    public void gotMOTD() {
        if (this.messageOfTheDay == null) {
            this.messageOfTheDay = new MessageOfTheDay();
            this.messageOfTheDay.back.connect(this.back);
            this.messageOfTheDay.done.connect(this.back);
        }
        this.messageOfTheDay.start();
    }

    public void gotUnlockAccount() {
        if (this.unlockAccount == null) {
            this.unlockAccount = new SelectUnlockAccount();
            this.unlockAccount.back.connect(this.back);
            this.gui.setUnlockAccountEnabled(this.unlockAccount.hasSubStates());
        }
        this.unlockAccount.display();
    }

    public void gotCompletedDeliveries() {
        if (this.completedDeliveries == null) {
            this.completedDeliveries = new CompletedDeliveries();
            this.completedDeliveries.done.connect(this.back);
        }
        this.completedDeliveries.startCompletedDeliveries();
    }

    public void gotClosedAccounts() {
        if (this.closedAccounts == null) {
            this.closedAccounts = new ClosedAccounts();
            this.closedAccounts.done.connect(this.back);
        }
        this.closedAccounts.startClosedAccounts();
    }

    public void gotSurcharge() {
        if (this.surchargeGui == null) {
            this.surchargeGui = new SurchargesDiscounts();
            this.surchargeGui.back.connect(this.back);
            this.surchargeGui.ok.connect(this.back);
        }
        this.surchargeGui.start();
    }

    @Override
    public Icon getCategoryIcon() {
        return IconLoader.get((String)"/waitermate/images/clock.png");
    }

    @Override
    public String getCategoryName() {
        return Internationalization.getLiteralFor((String)"DAILY_TASKS");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public void setupNoSaleButton(User theUser) {
        this.gui.setNoSaleEnabled(Terminal.getLocalHost().getAvailableCashDrawers(theUser).size() > 0);
    }

    void gotOpenCashDrawer() {
        User user = LoginManager.getInstance().getUser();
        CashDrawerManager.getInstance().openAllCashDrawersNoSale(user, Terminal.getLocalHost());
        if (SystemProperty.getInstance().isCctvEnabled() && Terminal.getLocalHost().getCCTVCamera() != null) {
            CCTVIntegration.showNoSale((String)"System admin", (User)user, (Terminal)Terminal.getLocalHost());
        }
        if (Terminal.getLocalHost().getQuickLogout()) {
            this.logout.emit();
        }
    }

    public void gotReports() {
        if (SystemProperty.getInstance().isBlindSkimEnabled() && Terminal.getLocalHost().getSkimming()) {
            boolean ok = false;
            List drawers = Terminal.getLocalHost().getAvailableCashDrawers(LoginManager.getInstance().getUser());
            for (CashDrawer current : drawers) {
                List skims = Skim.getSkims((Shift)Terminal.getLocalHost().getShift(), (CashDrawer)current);
                if (skims.size() <= 0) continue;
                ok = true;
            }
            if (!ok) {
                Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"YOU_MUST_DO_A_CASHDRAWER_SKIM_BEFORE_YOU_CAN_VIEW_THE_TAKINGS"), (String)Internationalization.getLiteralFor((String)"CANNOT_VIEW_TAKINGS"));
                return;
            }
        }
        if (this.reportsGui == null) {
            this.reportsGui = new WaitermateReports(this);
            this.reportsGui.done.connect(this.back);
        }
        this.reportsGui.start(Terminal.getLocalHost().getShift());
    }

    void gotTableSetup() {
        TerminalEventLog.logTableSetup((User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost());
        if (this.tableSetupGui == null) {
            this.tableSetupGui = new TableSetup();
            this.tableSetupGui.back.connect(this.back);
        }
        this.tableSetupGui.start();
    }

    void gotCashout() {
        if (this.cashout == null) {
            this.cashout = new CashOut();
            this.cashout.back.connect(this.back);
        }
        this.cashout.gotStartCashout();
    }

    void gotClockOnOff() {
        User user = LoginManager.getInstance().getUser();
        ClockOnClockOffScreen.getInstance().start(user, user, this.back, true, null, true);
    }

    void gotChangeShift() {
        new ChangeTradingDayOrShift().start();
    }

    void gotCashdrawer() {
        String value = (String)Dialogs.displaySelectionDialog((String)"Skims, Petty Cash or Reconciliation?", Arrays.asList("Skims", "Petty Cash", "Reconciliations"));
        if ("Skims".equals(value)) {
            if (this.skimsGui == null) {
                this.skimsGui = new Skims();
                this.skimsGui.back.connect(this.back);
                this.skimsGui.ok.connect(this.back);
            }
            this.skimsGui.start();
        } else if ("Petty Cash".equals(value)) {
            if (this.pettyCash == null) {
                this.pettyCash = new WMPettyCashScreen();
                this.pettyCash.back.connect(this.back);
                this.pettyCash.ok.connect(this.back);
            }
            this.pettyCash.display();
        } else if ("Reconciliations".equals(value)) {
            if (LoginManager.getInstance().getUser().hasPermission(AllPermissions.WAITERMATE_RECONCILIATION) || LoginManager.getInstance().hasPermission(AllPermissions.WAITERMATE_RECONCILIATION_BLIND)) {
                if (this.reconciliations == null) {
                    this.reconciliations = new WMReconciliationScreen();
                    this.reconciliations.back.connect(this.back);
                    this.reconciliations.ok.connect(this.back);
                }
                this.reconciliations.display();
            } else {
                Dialogs.displayOkDialog((String)"You do not have sufficient privileges", (String)"Cannot access Reconciliation");
                return;
            }
        }
    }

    void gotAdjustTips() {
        FastTipAdjust tipAdjust = new FastTipAdjust();
        tipAdjust.start();
    }

    void gotVoucherSearch() {
        if (this.voucherSearchGui == null) {
            this.voucherSearchGui = new WaitermateVoucherSearch();
            this.voucherSearchGui.back.connect(this.back);
        }
        this.voucherSearchGui.reset();
        this.voucherSearchGui.display();
    }

    void gotFinanceTransactions() {
        this.txnGui = new WMFinanceTxnScreen();
        this.txnGui.back.connect(this.back);
        this.txnGui.reset();
        this.txnGui.display();
    }

    void gotTriggerActivation() {
        PopupWindow popup = new PopupWindow();
        popup.setComponent((JComponent)new TriggerActivationScreen());
        popup.setText("Override Triggers");
        popup.setOkButtonVisible(true);
        popup.setCancelButtonVisible(false);
        popup.setPreferredSize(new Dimension(320, 600));
        popup.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                User loggedInUser = LoginManager.getInstance().getUser();
                String reason = loggedInUser + ": Update due to Trigger Override.";
                SystemCurrentInfo.setUpdate((String)reason);
                WaiterMateUpdater.getInstance().getUpdateTask().run();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
        popup.start();
    }

    void invokeSettlement() {
        AssemblyEftposHelper helper = new AssemblyEftposHelper();
        VirtualEftpos eftpos = helper.getAssemblyEftposForThisTerminal();
        AssemblyEftposSettlementGUI settlementGui = new AssemblyEftposSettlementGUI(eftpos);
        settlementGui.start();
    }

    void invokeControlPanel() {
        User user = LoginManager.getInstance().getUser();
        Terminal terminal = Terminal.getLocalHost();
        CashDrawer cashdrawer = terminal.getAssignedCashDrawer(user);
        VirtualEftpos vEftpos = EftposManager.getInstance().getEftposForCashDrawer(cashdrawer, terminal);
        if (EftposType.NITROSKYZER.equals((Object)vEftpos.getEftposType())) {
            new NitroSkyzerUtil().showControlPanel(vEftpos);
        }
    }

    public void gotStaleAccounts() {
        if (this.staleAccounts == null) {
            this.staleAccounts = new StaleAccounts();
            this.staleAccounts.done.connect(this.back);
        }
        this.staleAccounts.startStaleAccounts();
    }
}

