/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.daily;

import au.com.ordermate.util.image.IconLoader;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftposQueries;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.integration.eftpos.assembly.AssemblyEftposHelper;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.failover.FailoverRestriction;
import waitermate.gui.screens.admin.AbstractAdminPanel;

public class DailyAdminPanel
extends AbstractAdminPanel {
    JComponent noSale;
    public final Signal openDrawer = Signals.createSignal();
    public final Signal clockOnOff = Signals.createSignal();
    public final Signal reports = Signals.createSignal();
    public final Signal surcharges = Signals.createSignal();
    public final Signal cashdrawer = Signals.createSignal();
    public final Signal closedAccounts = Signals.createSignal();
    public final Signal completedDeliveries = Signals.createSignal();
    public final Signal tableSetup = Signals.createSignal();
    public final Signal unlockAccounts = Signals.createSignal();
    public final Signal messageOfTheDay = Signals.createSignal();
    public final Signal invItemSearch = Signals.createSignal();
    public final Signal errorLog = Signals.createSignal();
    public final Signal cashout = Signals.createSignal();
    public final Signal changeShift = Signals.createSignal();
    public final Signal adjustTips = Signals.createSignal();
    public final Signal voucherSearch = Signals.createSignal();
    public final Signal triggerActivation = Signals.createSignal();
    public final Signal eftposSettlement = Signals.createSignal();
    public final Signal eftposControlPanel = Signals.createSignal();
    public final Signal financeTransaction = Signals.createSignal();
    private StandardSecurityDecorator unlockAccountButton;
    public final Signal staleAccounts = Signals.createSignal();

    public DailyAdminPanel() {
        this.noSale = this.addButton(Internationalization.getLiteralFor((String)"NO_SALE"), IconLoader.get((String)"/waitermate/images/nosale.png"), AllPermissions.CASHDRAWER, this.openDrawer);
        this.addButton(Internationalization.getLiteralFor((String)"CLOCK_ON___OFF"), IconLoader.get((String)"/waitermate/images/clock.png"), null, this.clockOnOff);
        this.addButton(Internationalization.getLiteralFor((String)"REPORTS"), IconLoader.get((String)"/waitermate/images/pay.png"), AllPermissions.VIEW_TAKINGS, this.reports);
        this.addButton(Internationalization.getLiteralFor((String)"CLOSED_ACCOUNTS"), IconLoader.get((String)"/waitermate/images/closedAccounts.png"), AllPermissions.CLOSED_ACCOUNTS, this.closedAccounts, FailoverRestriction.Disabled);
        this.addButton(Internationalization.getLiteralFor((String)"STALE_ACCOUNTS"), IconLoader.get((String)"/waitermate/images/staleAccounts.png"), AllPermissions.CLOSED_ACCOUNTS, this.staleAccounts, FailoverRestriction.Disabled);
        if (Terminal.getLocalHost().hasPhoneMode() && SystemProperty.getInstance().getDriverAssignmentSettlement() != DriverAssignmentSettlementType.NONE) {
            this.addButton(Internationalization.getLiteralFor((String)"COMPLETED_DELIVERIES"), IconLoader.get((String)"/waitermate/images/deliveryreturned.png"), AllPermissions.CLOSED_ACCOUNTS, this.completedDeliveries);
        }
        this.addButton(Internationalization.getLiteralFor((String)"TABLE_SETUP"), IconLoader.get((String)"/waitermate/images/icon_gtlmode.png"), AllPermissions.MOVE_TABLE, this.tableSetup, FailoverRestriction.Disabled);
        this.addButton(Internationalization.getLiteralFor((String)"DAILY_SURCHARGE_DISCOUNTS"), IconLoader.get((String)"/waitermate/images/money.png"), AllPermissions.DAILY_DISCOUNT_OR_SURCHARGE, this.surcharges, FailoverRestriction.Disabled);
        this.addButton(Internationalization.getLiteralFor((String)"CASHDRAWER"), IconLoader.get((String)"/waitermate/images/cashdrawer.png"), AllPermissions.SKIMS, this.cashdrawer);
        this.unlockAccountButton = (StandardSecurityDecorator)this.addButton(Internationalization.getLiteralFor((String)"UNLOCK_ACCOUNTS_AND_SECTIONS"), IconLoader.get((String)"/waitermate/images/lock.png"), AllPermissions.UNLOCK_ACCOUNTS, this.unlockAccounts);
        this.addButton(Internationalization.getLiteralFor((String)"MESSAGE_OF_THE_DAY"), IconLoader.get((String)"/waitermate/images/edit.png"), AllPermissions.MESSAGE_OF_THE_DAY, this.messageOfTheDay);
        this.addButton(Internationalization.getLiteralFor((String)"CASHOUT_"), IconLoader.get((String)"/waitermate/images/dcard.png"), AllPermissions.CASHOUT, this.cashout);
        this.addButton(Internationalization.getLiteralFor((String)"ITEM_COUNTDOWN"), IconLoader.get((String)"/waitermate/images/StockCount.png"), AllPermissions.STOCK_RESET, this.invItemSearch);
        this.addButton(Internationalization.getLiteralFor((String)"CHANGE_SHIFT"), IconLoader.get((String)"/waitermate/images/clock.png"), AllPermissions.CHANGE_SHIFTS, this.changeShift);
        this.addButton(Internationalization.getLiteralFor((String)"TRANSACTIONS"), IconLoader.get((String)"/waitermate/images/price_level.png"), AllPermissions.VIEW_TAKINGS, this.financeTransaction);
        this.addButton(Internationalization.getLiteralFor((String)"VOUCHER_SEARCH"), IconLoader.get((String)"/waitermate/images/voucher.png"), AllPermissions.VOUCHERS_ADMIN, this.voucherSearch);
        this.addButton(Internationalization.getLiteralFor((String)"OVERRIDE_TRIGGER"), IconLoader.get((String)"/waitermate/images/override_triggers.png"), AllPermissions.TRIGGER_MANUAL_OVERRIDE, this.triggerActivation);
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled)) {
            this.addButton(Internationalization.getLiteralFor((String)"ADD_TIP"), IconLoader.get((String)"/waitermate/images/addMoney.png"), AllPermissions.TIP_ADJUST, this.adjustTips);
        }
        this.addEftposButtons();
        this.addButton(Internationalization.getLiteralFor((String)"ERROR_LOG"), IconLoader.get((String)"/waitermate/images/warning.png"), AllPermissions.ACCESS_USERS_SCREEN, this.errorLog);
    }

    public void setNoSaleEnabled(boolean b) {
        ((StandardSecurityDecorator)this.noSale).setEnabled(b);
    }

    public void setUnlockAccountEnabled(boolean value) {
        this.unlockAccountButton.setEnabled(value);
    }

    private void addAssemblySettlementButton() {
        AssemblyEftposHelper helper = new AssemblyEftposHelper();
        if (helper.isEnabledForThisTerminal()) {
            this.addButton(Internationalization.getLiteralFor((String)"ASSEMBLY_SETTLE_BUTTON_STRING"), IconLoader.get((String)"/waitermate/guikit/images/print.png"), AllPermissions.CASHDRAWER, this.eftposSettlement);
        }
    }

    private void addEftposButtons() {
        this.addAssemblySettlementButton();
        this.addNitroSkyzerControlPanelButton();
    }

    private void addNitroSkyzerControlPanelButton() {
        User user = LoginManager.getInstance().getUser();
        Terminal terminal = Terminal.getLocalHost();
        CashDrawer cashDrawer = terminal.getAssignedCashDrawer(user);
        List eftposList = null;
        if (terminal != null) {
            eftposList = VirtualEftposQueries.getEftposForDrawer((CashDrawer)cashDrawer, (EftposType)EftposType.NITROSKYZER);
        }
        if (eftposList.size() > 0) {
            this.addButton(Internationalization.getLiteralFor((String)"NITROSKYZER_CONTROL_PANEL_STRING"), IconLoader.get((String)"/waitermate/images/partners/nitro.png"), AllPermissions.CASHDRAWER, this.eftposControlPanel);
        }
    }
}

