/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.guiconfig;

import au.com.ordermate.configuration.Config;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TakeawayAccount;
import ordermate.gui.LaFClassRenderer;
import ordermate.gui.LaFManager;
import ordermate.gui.PlusMinusPanel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.VerticalLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.SubstanceAutumnLookAndFeel;
import org.jvnet.substance.skin.SubstanceCremeCoffeeLookAndFeel;
import org.jvnet.substance.skin.SubstanceCremeLookAndFeel;
import org.jvnet.substance.skin.SubstanceMistSilverLookAndFeel;
import org.jvnet.substance.skin.SubstanceModerateLookAndFeel;
import org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel;
import org.jvnet.substance.skin.SubstanceRavenGraphiteGlassLookAndFeel;
import org.jvnet.substance.skin.SubstanceRavenGraphiteLookAndFeel;
import org.jvnet.substance.skin.SubstanceRavenLookAndFeel;
import org.jvnet.substance.skin.SubstanceSaharaLookAndFeel;
import waitermate.LoginManager;
import waitermate.gui.displayitems.SelectItemButtonRenderer;
import waitermate.gui.screens.ordering.additems.selectitem.SimpleMenuItemSelectionPanel;
import waitermate.guikit.dialogs.Dialogs;

class GuiConfigPanel
extends JPanel {
    public final Signal settingsChanged = Signals.createSignal();
    private final PlusMinusPanel fontSizePanel;
    private final JComboBox lafClassComboBox;
    private final JPanel demoPanel;
    private final LaFManager lafManager = new LaFManager();

    protected GuiConfigPanel() {
        super(new BorderLayout());
        JPanel centrePanel = new JPanel((LayoutManager)new VerticalLayout());
        centrePanel.setBorder(new TitledBorder(null, Internationalization.getLiteralFor((String)"SELECT_THE_GUI_OPTIONS_TO_CONFIG"), 4, 2, OrderMateTheme.getMediumFont()));
        this.fontSizePanel = new PlusMinusPanel(Integer.valueOf(5), Integer.valueOf(25));
        this.fontSizePanel.setPlusMinusText(null, null);
        this.fontSizePanel.setValue(10);
        JLabel fontLabel = new JLabel(Internationalization.getLiteralFor((String)"FONT_SIZE") + " :");
        fontLabel.setFont(OrderMateTheme.getMediumFont());
        fontLabel.setLabelFor((Component)this.fontSizePanel);
        JPanel panel = new JPanel();
        panel.add(fontLabel);
        panel.add((Component)this.fontSizePanel);
        this.fontSizePanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GuiConfigPanel.this.updateDemo();
            }
        });
        centrePanel.add(panel);
        JLabel styleLabel = new JLabel(Internationalization.getLiteralFor((String)"STYLE"));
        styleLabel.setFont(OrderMateTheme.getMediumFont());
        Class[] lookAndFeels = new Class[]{SubstanceSaharaLookAndFeel.class, SubstanceModerateLookAndFeel.class, SubstanceRavenLookAndFeel.class, SubstanceRavenGraphiteLookAndFeel.class, SubstanceRavenGraphiteGlassLookAndFeel.class, SubstanceOfficeSilver2007LookAndFeel.class, SubstanceCremeCoffeeLookAndFeel.class, SubstanceCremeLookAndFeel.class, SubstanceAutumnLookAndFeel.class, SubstanceMistSilverLookAndFeel.class};
        this.lafClassComboBox = new JComboBox<Class>(new DefaultComboBoxModel<Class>(lookAndFeels));
        this.lafClassComboBox.setEditable(false);
        this.lafClassComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiConfigPanel.this.updateDemo();
            }
        });
        LaFClassRenderer LaFRenderer = new LaFClassRenderer();
        LaFRenderer.setFont(OrderMateTheme.getLargeFont());
        this.lafClassComboBox.setRenderer(LaFRenderer);
        this.lafClassComboBox.setFont(OrderMateTheme.getLargeFont());
        styleLabel.setLabelFor(this.lafClassComboBox);
        this.lafClassComboBox.setPreferredSize(new Dimension(450, 60));
        this.lafClassComboBox.setMaximumRowCount(5);
        panel = new JPanel();
        panel.add(styleLabel);
        panel.add(this.lafClassComboBox);
        centrePanel.add(panel);
        SelectItemButtonRenderer itemsRenderer = new SelectItemButtonRenderer(true);
        SimpleMenuItemSelectionPanel selectionPanel = new SimpleMenuItemSelectionPanel(1, 5, itemsRenderer);
        selectionPanel.showRootGroup(new TriggerActivationContext(LoginManager.getEventContext(), (ItemGroup)new TakeawayAccount()), new ArrayList<SalesLineItem>(), new ArrayList<SalesLineItem>());
        this.demoPanel = new JPanel(new BorderLayout());
        this.demoPanel.setBorder(new TitledBorder(null, Internationalization.getLiteralFor((String)"EXAMPLE"), 4, 2, OrderMateTheme.getMediumFont()));
        this.demoPanel.add((Component)selectionPanel, "Center");
        this.add((Component)this.demoPanel, "Center");
        this.add((Component)centrePanel, "East");
    }

    protected int getFontSize() {
        return this.fontSizePanel.getValue();
    }

    protected SubstanceLookAndFeel getLaF() {
        Class substanceClass = (Class)this.lafClassComboBox.getSelectedItem();
        if (substanceClass != null) {
            try {
                return (SubstanceLookAndFeel)substanceClass.newInstance();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Could not instantiate LaF :" + substanceClass, (Throwable)ex);
            }
        }
        return null;
    }

    protected void updateDemo() {
        this.lafManager.updateComponent((Component)this.demoPanel, this.getLaF(), this.getFontSize());
        this.lafClassComboBox.updateUI();
        this.settingsChanged.emit();
    }

    public void setValues(Terminal localHost) {
        String lafClassName;
        this.fontSizePanel.setValue(localHost.getGuiFontSize() > 0 ? localHost.getGuiFontSize() : Config.getIntValue((String)"scale") + 10);
        String string = lafClassName = localHost.getLookAndFeelClassName() != null ? localHost.getLookAndFeelClassName() : Config.getStringValue((String)"look_and_feel");
        if (lafClassName != null) {
            try {
                this.lafClassComboBox.setSelectedItem(this.lafManager.loadLookAndFeel(lafClassName).getClass());
            }
            catch (ClassNotFoundException ex) {
                Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"LOOK_AND_FEEL_NOT_FOUND"), (String)Internationalization.getLiteralFor((String)"THE_CURRENT_LOOK_AND_FEEL_COULD_NOT_BE_FOUND_THE_DEFAULT_WILL_BE_USED"));
            }
        }
    }
}

