/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.license;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.license.KeyInput;

class LicenseGui
extends JPanel
implements ActionListener {
    private static final Insets insets = new Insets(10, 5, 10, 5);
    private KeyInput keyInput;
    private JToggleButton keyButton1;
    private JToggleButton keyButton2;
    private JToggleButton keyButton3;
    private JToggleButton keyButton4;
    private ButtonGroup buttonGroup;
    private JButton enterButton;
    private JLabel titleLabel;
    public final Signal update = Signals.createSignal(String.class, (String)"key");

    public LicenseGui() {
        this.keyInput = new KeyInput();
        this.keyInput.clicked.connect((Object)this, "gotKeyPress");
        this.keyInput.backspace.connect((Object)this, "gotBackSpace");
        this.keyButton1 = new JToggleButton();
        this.keyButton1.setMargin(insets);
        this.keyButton2 = new JToggleButton();
        this.keyButton2.setMargin(insets);
        this.keyButton3 = new JToggleButton();
        this.keyButton3.setMargin(insets);
        this.keyButton4 = new JToggleButton();
        this.keyButton4.setMargin(insets);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.keyButton1);
        this.buttonGroup.add(this.keyButton2);
        this.buttonGroup.add(this.keyButton3);
        this.buttonGroup.add(this.keyButton4);
        this.enterButton = new JButton("Evaluate Key");
        this.enterButton.setMargin(insets);
        this.enterButton.addActionListener(this);
        JPanel keyPanel1 = new JPanel();
        keyPanel1.setLayout(new GridLayout(1, 0));
        keyPanel1.add(this.keyButton1);
        keyPanel1.add(this.keyButton2);
        JPanel keyPanel2 = new JPanel();
        keyPanel2.setLayout(new GridLayout(1, 0));
        keyPanel2.add(this.keyButton3);
        keyPanel2.add(this.keyButton4);
        JPanel enterPanel = new JPanel();
        enterPanel.setLayout(new GridLayout(1, 0));
        enterPanel.add(new JLabel());
        enterPanel.add(this.enterButton);
        enterPanel.add(new JLabel());
        JPanel licensePanel = new JPanel();
        licensePanel.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(15, 6)));
        licensePanel.add((Component)new JLabel("Code 1:"), new Rectangle(4, 0, 2, 1));
        licensePanel.add((Component)this.keyButton1, new Rectangle(7, 0, 4, 1));
        licensePanel.add((Component)new JLabel("Code 2:"), new Rectangle(4, 1, 4, 1));
        licensePanel.add((Component)this.keyButton2, new Rectangle(7, 1, 4, 1));
        licensePanel.add((Component)new JLabel("Code 3:"), new Rectangle(4, 2, 4, 1));
        licensePanel.add((Component)this.keyButton3, new Rectangle(7, 2, 4, 1));
        licensePanel.add((Component)new JLabel("Code 4:"), new Rectangle(4, 3, 4, 1));
        licensePanel.add((Component)this.keyButton4, new Rectangle(7, 3, 4, 1));
        licensePanel.add((Component)this.enterButton, new Rectangle(4, 5, 7, 1));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridBagLayout());
        inputPanel.add(this.keyInput);
        this.keyInput.setBorder(BorderFactory.createTitledBorder("Enter Key:"));
        JPanel updatePanel = new JPanel();
        updatePanel.setLayout(new GridBagLayout());
        updatePanel.add(licensePanel);
        licensePanel.setBorder(BorderFactory.createTitledBorder("License:"));
        JPanel center = new JPanel();
        center.setLayout(new GridLayout(1, 2));
        center.add(updatePanel);
        center.add(inputPanel);
        this.titleLabel = new JLabel();
        JPanel north = new JPanel();
        north.setLayout(new FlowLayout(0));
        north.add(new JLabel());
        north.add(this.titleLabel);
        this.setLayout(new BorderLayout(20, 20));
        this.add("North", north);
        this.add("Center", center);
    }

    public void display(String title) {
        this.setTitle(title);
        this.buttonGroup.setSelected(this.keyButton1.getModel(), true);
        this.keyButton1.setText("");
        this.keyButton2.setText("");
        this.keyButton3.setText("");
        this.keyButton4.setText("");
    }

    public void setTitle(String title) {
        String text = "<html><h1>" + title + "</h1></title>";
        this.titleLabel.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.enterButton) {
            String key = this.keyButton1.getText() + this.keyButton2.getText() + this.keyButton3.getText() + this.keyButton4.getText();
            this.update.emit((Object)key);
        }
    }

    void gotKeyPress(Character c) {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        if (this.keyButton1.getModel() == buttonModel) {
            this.addCharToButton(this.keyButton1, c.charValue());
        } else if (this.keyButton2.getModel() == buttonModel) {
            this.addCharToButton(this.keyButton2, c.charValue());
        } else if (this.keyButton3.getModel() == buttonModel) {
            this.addCharToButton(this.keyButton3, c.charValue());
        } else if (this.keyButton4.getModel() == buttonModel) {
            this.addCharToButton(this.keyButton4, c.charValue());
        }
    }

    void gotBackSpace() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        if (this.keyButton1.getModel() == buttonModel) {
            this.removeCharFromButton(this.keyButton1);
        } else if (this.keyButton2.getModel() == buttonModel) {
            this.removeCharFromButton(this.keyButton2);
        } else if (this.keyButton3.getModel() == buttonModel) {
            this.removeCharFromButton(this.keyButton3);
        } else if (this.keyButton4.getModel() == buttonModel) {
            this.removeCharFromButton(this.keyButton4);
        }
    }

    private void addCharToButton(AbstractButton button, char c) {
        String text = button.getText();
        if (text.length() < 8) {
            text = text + c;
            button.setText(text);
        }
    }

    private void removeCharFromButton(AbstractButton button) {
        String text = button.getText();
        if (text.length() > 0) {
            text = text.substring(0, text.length() - 1);
            button.setText(text);
        }
    }
}

