/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.messageoftheday;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import ordermate.gui.keyboard.Keyboard;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;

public class MessageOfTheDayGui
extends JPanel {
    private JLabel informationLabel;
    private JTextArea messageText;
    private Keyboard theKeyboard;
    private String message;

    public MessageOfTheDayGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        this.informationLabel = new JLabel(Internationalization.getLiteralFor((String)"SET_THE_MESSAGE_OF_THE_DAY_OR_PRESS_CLEAR_TO_REMOVE_IT") + " " + Internationalization.getLiteralFor((String)"MAXIMUM_LENGTH_IS") + " " + 100 + " " + Internationalization.getLiteralFor((String)"CHARACTERS") + ".");
        this.informationLabel.setFont(OrderMateTheme.getMediumFont());
        this.informationLabel.setHorizontalAlignment(0);
        this.add((Component)this.informationLabel, new Rectangle(0, 2, 20, 2));
        this.messageText = new JTextArea();
        this.messageText.setFont(OrderMateTheme.getLargeFont());
        this.messageText.setEditable(false);
        this.messageText.setLineWrap(true);
        this.messageText.setCaret(new Caret(){

            @Override
            public void install(JTextComponent c) {
            }

            @Override
            public void deinstall(JTextComponent c) {
            }

            @Override
            public void paint(Graphics g) {
            }

            @Override
            public void addChangeListener(ChangeListener l) {
            }

            @Override
            public void removeChangeListener(ChangeListener l) {
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            @Override
            public void setVisible(boolean v) {
            }

            @Override
            public boolean isSelectionVisible() {
                return false;
            }

            @Override
            public void setSelectionVisible(boolean v) {
            }

            @Override
            public void setMagicCaretPosition(Point p) {
            }

            @Override
            public Point getMagicCaretPosition() {
                return new Point(0, 0);
            }

            @Override
            public void setBlinkRate(int rate) {
            }

            @Override
            public int getBlinkRate() {
                return 10000;
            }

            @Override
            public int getDot() {
                return 0;
            }

            @Override
            public int getMark() {
                return 0;
            }

            @Override
            public void setDot(int dot) {
            }

            @Override
            public void moveDot(int dot) {
            }
        });
        this.add((Component)this.messageText, new Rectangle(1, 5, 18, 3));
        this.theKeyboard = new Keyboard();
        this.theKeyboard.updated.connect((Object)this, "keyboardUpdated");
        this.add((Component)this.theKeyboard, new Rectangle(1, 8, 18, 19));
    }

    public void keyboardUpdated(String newValue) {
        this.setMessage(newValue);
        this.updateMessage();
    }

    public void setMessage(String newValue) {
        this.message = newValue != null && newValue.length() > 100 ? newValue.substring(0, 100) : newValue;
        this.theKeyboard.setValue(this.message);
        this.updateMessage();
    }

    public String getMessage() {
        return this.theKeyboard.getValue();
    }

    private void updateMessage() {
        if (this.message != null) {
            this.messageText.setText(this.message);
        } else {
            this.messageText.setText("");
        }
    }
}

