/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.image.IconLoader;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;
import waitermate.WaiterMate;

class PrintAccountsTask
extends AbstractTask {
    private List allAccounts;
    private List receiptPrinters;
    private boolean isPrintAllOpenAccounts;

    public PrintAccountsTask(List printers, boolean isPrintAllOpenAccounts) {
        this.receiptPrinters = printers;
        this.isPrintAllOpenAccounts = isPrintAllOpenAccounts;
    }

    public int getTotalSubTasks() {
        if (this.allAccounts == null) {
            this.allAccounts = this.isPrintAllOpenAccounts ? Account.getAllOpenAccounts() : Account.getAllOpenCurrentDayAccount();
        }
        return this.allAccounts.size();
    }

    public String getName() {
        return Internationalization.getLiteralFor((String)"PRINTING_OPEN_ACCOUNTS");
    }

    public Icon getIcon() {
        return IconLoader.get((String)"/waitermate/guikit/images/print.png");
    }

    protected void performTask() throws Exception {
        Iterator iterator = this.allAccounts.iterator();
        while (iterator.hasNext()) {
            Account account = (Account)iterator.next();
            try {
                account.printReceiptDockets(LoginManager.getInstance().getUser(), Terminal.getLocalHost(), this.receiptPrinters);
                this.emitProgress();
            }
            catch (Exception e) {
                String msg = Internationalization.getLiteralFor((String)"UNABLE_TO_PRINT_ACCOUNT") + " (" + Internationalization.getLiteralFor((String)"ID_EQUALS") + account.getID() + ")";
                WaiterMate.LOG.error(msg, (Throwable)e);
            }
            if (!iterator.hasNext()) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                WaiterMate.LOG.info("Interrupted while waiting", (Throwable)e);
            }
        }
    }
}

