/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer;

import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.printer.PrintAccountsTask;
import waitermate.gui.screens.admin.printer.PrinterAdminPanel;
import waitermate.gui.screens.admin.printer.printerredirection.RedirectPrinters;
import waitermate.gui.screens.admin.printer.reprintdockets.DocketSearch;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.OnePressPopupWindow;
import waitermate.guikit.dialogs.ProgressDialog;

public class PrinterAdmin
extends AbstractAdminScreen {
    private RedirectPrinters redirect;
    private DocketSearch dockets;
    private PrinterAdminPanel gui = new PrinterAdminPanel();
    private NavBar nav = new NavBar();

    public PrinterAdmin() {
        this.gui.redirect.connect((Object)this, "gotRedirect");
        this.gui.reprint.connect((Object)this, "gotReprint");
        this.gui.printOpenAccountsToday.connect((Object)this, "gotPrintOpenAccountsToday");
        this.gui.printAllOpenAccounts.connect((Object)this, "gotPrintAllOpenAccounts");
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.back.connect(this.back);
        this.nav.setText(Internationalization.getLiteralFor((String)"PRINTER_ADMIN"));
    }

    @Override
    public Icon getCategoryIcon() {
        return IconLoader.get((String)"/waitermate/images/printerAdmin.png");
    }

    @Override
    public String getCategoryName() {
        return Internationalization.getLiteralFor((String)"PRINTING");
    }

    public void gotRedirect() {
        if (this.redirect == null) {
            this.redirect = new RedirectPrinters();
            this.redirect.done.connect(this.back);
        }
        this.redirect.start();
    }

    public void gotReprint() {
        if (this.dockets == null) {
            this.dockets = new DocketSearch();
            this.dockets.back.connect(this.back);
        }
        this.dockets.start();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public NavBar getNavBar() {
        return this.nav;
    }

    private void printOpenAccounts(boolean isPrintAllOpenAccounts) {
        ArrayList<VirtualPrinter> printers = Terminal.getLocalHost().getAvailableReceiptPrinters();
        if (printers.isEmpty()) {
            String msg = Internationalization.getLiteralFor((String)"OPEN_ACCOUNTS_CAN_ONLY_BE_PRINTED_FROM_A_TERMINAL_WITH_A_RECEIPT_PRINTER");
            Dialogs.displayOkDialog((String)msg, (String)Internationalization.getLiteralFor((String)"COULD_NOT_PRINT"));
            return;
        }
        if (printers.size() > 1) {
            List buttons = AbstractScrollPaneModel.constructButtons((Collection)printers);
            OnePressPopupWindow printerDialog = new OnePressPopupWindow(Internationalization.getLiteralFor((String)"SELECT_RECEIPT_PRINTER"), (Collection)buttons, 1, 3, false);
            CustomButton selectedButton = (CustomButton)printerDialog.start();
            VirtualPrinter selectedPrinter = (VirtualPrinter)selectedButton.getData();
            printers = new ArrayList<VirtualPrinter>();
            printers.add(selectedPrinter);
        }
        ProgressDialog.doProgressDialog((Task)new PrintAccountsTask(printers, isPrintAllOpenAccounts));
    }

    public void gotPrintAllOpenAccounts() {
        this.printOpenAccounts(true);
    }

    public void gotPrintOpenAccountsToday() {
        this.printOpenAccounts(false);
    }
}

