/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer.printerredirection;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.internationalization.Internationalization;

public class RedirectPrintersPanel
extends JPanel {
    private DataScrollPaneModel virtualModel;
    private DataScrollPaneModel physicalModel;
    private CustomScrollPane physicalScrollPane;
    private CustomScrollPane virtualScrollPane;
    private Map<VirtualPrinter, PhysicalPrintDevice> printerMap = new HashMap<VirtualPrinter, PhysicalPrintDevice>();

    public RedirectPrintersPanel() {
        this.virtualModel = new DataScrollPaneModel(1, 5);
        this.physicalModel = new DataScrollPaneModel(1, 5);
        this.virtualModel.objectSelected.connect((Object)this, "gotVirtual");
        this.physicalModel.objectSelected.connect((Object)this, "gotPhysical");
        this.virtualScrollPane = new CustomScrollPane((CustomScrollPaneModel)this.virtualModel);
        this.physicalScrollPane = new CustomScrollPane((CustomScrollPaneModel)this.physicalModel);
        JPanel left = new JPanel(new BorderLayout());
        left.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"VIRTUAL_PRINTERS")));
        left.add((Component)this.virtualScrollPane, "Center");
        JPanel right = new JPanel(new BorderLayout());
        right.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"REAL_PRINTERS")));
        right.add((Component)this.physicalScrollPane, "Center");
        JLabel title = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"DIRECT_JOBS_TO") + "</h2></html>");
        JLabel image = new JLabel(IconLoader.get((String)"/waitermate/images/assign.png"));
        JPanel centre = new JPanel();
        JPanel titlePanel = new JPanel(new GridLayout(2, 1));
        titlePanel.add(image);
        titlePanel.add(title);
        centre.add(titlePanel);
        this.setLayout((LayoutManager)new GraphPaperLayout(3, 1));
        this.add((Component)left, new Rectangle(0, 0, 1, 1));
        this.add((Component)centre, new Rectangle(1, 0, 1, 1));
        this.add((Component)right, new Rectangle(2, 0, 1, 1));
    }

    public void setup(List virtualPrinters, List physicalPrinters) {
        this.virtualModel.setItems(virtualPrinters, true, true);
        this.physicalModel.setItems(physicalPrinters, true, true);
        for (VirtualPrinter printer : virtualPrinters) {
            this.printerMap.put(printer, printer.getPrintDevice());
        }
        this.virtualModel.selectButton((Displayable)virtualPrinters.get(0));
        this.setSelectedPhysical((VirtualPrinter)virtualPrinters.get(0));
        this.virtualScrollPane.displayPage(0);
    }

    public void reset(List virtualPrinters) {
        for (VirtualPrinter printer : virtualPrinters) {
            this.printerMap.put(printer, printer.getPrintDevice());
        }
        this.setSelectedPhysical(this.getLastSelectedVirtual());
    }

    public Map<VirtualPrinter, PhysicalPrintDevice> getPrinterMap() {
        return this.printerMap;
    }

    private void setSelectedPhysical(VirtualPrinter virtualPrinter) {
        if (virtualPrinter != null) {
            PhysicalPrintDevice printer = this.printerMap.get(virtualPrinter);
            this.physicalModel.selectButton((Displayable)printer);
            if (printer != null) {
                Iterator it = this.physicalModel.getButtons().iterator();
                NameDecorator toGoTo = null;
                while (it.hasNext()) {
                    NameDecorator decorator = (NameDecorator)it.next();
                    CustomToggleButton button = (CustomToggleButton)decorator.getDecorateComponent();
                    if (!printer.equals((Object)button.getData())) continue;
                    toGoTo = decorator;
                    this.physicalScrollPane.gotoComponent((Object)toGoTo);
                }
            }
        }
    }

    public void gotVirtual(Displayable info) {
        VirtualPrinter printer = (VirtualPrinter)info;
        this.setSelectedPhysical(printer);
    }

    public void gotPhysical(Displayable info) {
        PhysicalPrintDevice printer = (PhysicalPrintDevice)info;
        VirtualPrinter selected = this.getLastSelectedVirtual();
        this.printerMap.put(selected, printer);
    }

    private VirtualPrinter getLastSelectedVirtual() {
        VirtualPrinter toReturn = null;
        List selectedList = this.virtualModel.getSelectedButtons();
        if (selectedList.size() > 0) {
            int lastItem = selectedList.size() - 1;
            CustomToggleButton selected = (CustomToggleButton)selectedList.get(lastItem);
            toReturn = (VirtualPrinter)selected.getData();
        }
        return toReturn;
    }
}

