/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.printer.reprintdockets;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.reports.general.NumberReport;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;

public class DocketSearchPanel
extends JPanel
implements ActionListener {
    private JComboBox printerCombo;
    private JComboBox firstNumCombo;
    private JComboBox lastNumCombo;
    private JComboBox calendarCombo;
    private Date today;

    public DocketSearchPanel() {
        JLabel printerLabel = new JLabel(Internationalization.getLiteralFor((String)"REPRINT_DOCKETS_FROM_PRINTER"));
        printerLabel.setFont(OrderMateTheme.getMediumFont());
        this.printerCombo = this.getComboBox(200, 60);
        this.printerCombo.setName("printerCombo");
        printerLabel.setLabelFor(this.printerCombo);
        this.firstNumCombo = this.getComboBox(80, 60);
        this.lastNumCombo = this.getComboBox(80, 60);
        this.calendarCombo = this.getComboBox(80, 60);
        this.firstNumCombo.setName("startDocket");
        this.lastNumCombo.setName("endDocket");
        this.calendarCombo.setName("dateCombo");
        final SimpleDateFormat format = new SimpleDateFormat("EE d MMM");
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (DocketSearchPanel.this.today == value) {
                    return super.getListCellRendererComponent(list, "Today", index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent(list, format.format(value), index, isSelected, cellHasFocus);
            }
        };
        renderer.setFont(OrderMateTheme.getLargeFont());
        this.calendarCombo.setRenderer(renderer);
        JLabel docketLabel = new JLabel(Internationalization.getLiteralFor((String)"FROM_DOCKET_NUMBER") + ": ");
        docketLabel.setFont(OrderMateTheme.getMediumFont());
        docketLabel.setLabelFor(this.firstNumCombo);
        JLabel toLabel = new JLabel(Internationalization.getLiteralFor((String)"TO"));
        toLabel.setFont(OrderMateTheme.getMediumFont());
        toLabel.setLabelFor(this.lastNumCombo);
        JPanel calPanel = new JPanel();
        JLabel dateLabel = new JLabel(Internationalization.getLiteralFor((String)"DATE"));
        dateLabel.setFont(OrderMateTheme.getMediumFont());
        dateLabel.setLabelFor(this.calendarCombo);
        calPanel.add(dateLabel);
        calPanel.add(this.calendarCombo);
        this.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"SELECT_DOCKETS_TO_REPRINT")));
        this.setLayout((LayoutManager)new GraphPaperLayout(101, 101));
        this.add((Component)printerLabel, new Rectangle(5, 5, 25, 10));
        this.add((Component)this.printerCombo, new Rectangle(31, 5, 30, 10));
        this.add((Component)docketLabel, new Rectangle(5, 17, 25, 10));
        this.add((Component)this.firstNumCombo, new Rectangle(31, 17, 20, 10));
        this.add((Component)toLabel, new Rectangle(5, 29, 25, 10));
        this.add((Component)this.lastNumCombo, new Rectangle(31, 29, 20, 10));
        this.add((Component)dateLabel, new Rectangle(5, 41, 25, 10));
        this.add((Component)this.calendarCombo, new Rectangle(31, 41, 30, 10));
    }

    private JComboBox getComboBox(int x, int y) {
        JComboBox<Object> toReturn = new JComboBox<Object>();
        toReturn.setPreferredSize(new Dimension(x, y));
        toReturn.setRenderer(new ComboRenderer());
        toReturn.setMaximumRowCount(10);
        toReturn.setFont(OrderMateTheme.getLargeFont());
        return toReturn;
    }

    public void start() {
        this.printerCombo.removeActionListener(this);
        this.printerCombo.removeAllItems();
        this.calendarCombo.removeActionListener(this);
        this.calendarCombo.removeAllItems();
        Calendar cal = Calendar.getInstance();
        DateTimeUtils.clearTimePart((Calendar)cal);
        this.today = cal.getTime();
        this.calendarCombo.addItem(this.today);
        for (int i = 0; i < 4; ++i) {
            cal.add(5, -1);
            this.calendarCombo.addItem(cal.getTime());
        }
        this.calendarCombo.addActionListener(this);
        String sql = Query.select(VirtualPrinter.class).not().equals(VirtualPrinter.Properties.DOCKET_NUMBER, 0.0).orderBy(VirtualPrinter.Properties.LABEL).toString();
        List printers = PersistenceManager.getObjectList(VirtualPrinter.class, (String)sql, null);
        for (VirtualPrinter printer : printers) {
            this.printerCombo.addItem(printer);
        }
        this.printerCombo.addActionListener(this);
        if (printers.size() > 0) {
            this.printerCombo.setSelectedIndex(0);
            VirtualPrinter printer = (VirtualPrinter)this.printerCombo.getItemAt(0);
            this.startSelectNumbers(printer);
        }
    }

    private void startSelectNumbers(VirtualPrinter printer) {
        this.firstNumCombo.removeAllItems();
        this.lastNumCombo.removeAllItems();
        if (printer == null) {
            return;
        }
        int last = printer.getDocketNumber();
        if (this.today != this.calendarCombo.getSelectedItem()) {
            last = this.getMaxDocketNumber((Date)this.calendarCombo.getSelectedItem(), printer);
        }
        for (int i = 1; i <= last; ++i) {
            this.firstNumCombo.addItem(new Integer(i));
            this.lastNumCombo.addItem(new Integer(i));
        }
        if (last > 0) {
            if (last < 6) {
                this.firstNumCombo.setSelectedIndex(0);
            } else {
                this.firstNumCombo.setSelectedIndex(last - 6);
            }
            this.lastNumCombo.setSelectedIndex(last - 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.printerCombo) {
            VirtualPrinter printer = (VirtualPrinter)this.printerCombo.getSelectedItem();
            this.startSelectNumbers(printer);
        } else if (e.getSource() == this.calendarCombo) {
            VirtualPrinter printer = (VirtualPrinter)this.printerCombo.getSelectedItem();
            this.startSelectNumbers(printer);
        }
    }

    private int getMaxDocketNumber(Date date, VirtualPrinter printer) {
        NumberReport report = (NumberReport)PersistenceManager.getObject(NumberReport.class, (String)"SELECT (0 + max(sequence_number)) as value FROM system_docket WHERE fk_sales_account is not null AND docket_type = 'PREP' AND fk_config_printer_virtual= ? AND date(creation_time) = date(?)", (Object[])new Object[]{printer.getID(), date});
        return report != null ? report.intValue() : 0;
    }

    public List<SalesAccountDocket> getSelectedDockets() {
        VirtualPrinter printer = (VirtualPrinter)this.printerCombo.getSelectedItem();
        Integer min = (Integer)this.firstNumCombo.getSelectedItem();
        Integer max = (Integer)this.lastNumCombo.getSelectedItem();
        if (printer == null || min == null || max == null) {
            return Collections.emptyList();
        }
        ObjectQuery query = Query.select(SalesAccountDocket.class).equals(SalesAccountDocket.Properties.DOCKET_TYPE, (Object)"PREP").equals(SalesAccountDocket.Properties.ORIGINAL_PRINTER, (Object)printer.getID()).greaterThan(SalesAccountDocket.Properties.SEQUENCE_NUMBER, min.doubleValue() - 1.0).lessThan(SalesAccountDocket.Properties.SEQUENCE_NUMBER, max.doubleValue() + 1.0).orderBy(SalesAccountDocket.Properties.SEQUENCE_NUMBER);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date selected = (Date)this.calendarCombo.getSelectedItem();
        if (selected == null) {
            selected = new Date();
        }
        query.whereFunction("DATE(creation_time) = '" + format.format(selected) + "'");
        List dockets = PersistenceManager.getObjectList(SalesAccountDocket.class, (String)query.toString(), null);
        return dockets;
    }

    static class ComboRenderer
    extends DefaultListCellRenderer {
        public ComboRenderer() {
            this.setFont(OrderMateTheme.getLargeFont());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText(Internationalization.getLiteralFor((String)"NONE"));
            }
            return this;
        }
    }
}

