/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.docketprocessor.WaitermateReportType;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class WaitermateReportSelectionPanel
extends JPanel {
    public Signal<WaitermateReportType, ?, ?, ?, ?> reportPressed = Signals.createSignal(WaitermateReportType.class, (String)"reportType");
    private List<ReportSelection> selections = new ArrayList<ReportSelection>();

    WaitermateReportSelectionPanel() {
        super(new BorderLayout());
        this.setupSelections();
    }

    private void setupSelections() {
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 1));
        for (WaitermateReportType type : WaitermateReportType.values()) {
            ReportSelection selection = new ReportSelection(type);
            this.selections.add(selection);
            selection.setSelected(true);
            holder.add(selection);
        }
        this.add((Component)holder, "Center");
    }

    public List<WaitermateReportType> getSelectedReports() {
        ArrayList<WaitermateReportType> selected = new ArrayList<WaitermateReportType>();
        for (ReportSelection selection : this.selections) {
            if (!selection.isSelected() || !selection.isEnabled()) continue;
            selected.add(selection.reportType);
        }
        return selected;
    }

    @Override
    public void setEnabled(boolean value) {
        for (ReportSelection selection : this.selections) {
            selection.setEnabled(value);
        }
        super.setEnabled(value);
    }

    private class ReportSelection
    extends JPanel {
        private final WaitermateReportType reportType;
        private JCheckBox selectedCheck;
        private JButton reportButton;

        ReportSelection(WaitermateReportType type) {
            super(new FlowLayout(1, 40, 5));
            this.reportType = type;
            this.setupComponents();
        }

        private void setupComponents() {
            this.selectedCheck = new JCheckBox();
            OrderMateTheme.setupTransparentButton((AbstractButton)this.selectedCheck);
            this.selectedCheck.setIcon(IconLoader.get((String)"/waitermate/images/cancel32.png"));
            this.selectedCheck.setSelectedIcon(IconLoader.get((String)"/waitermate/images/ok32.png"));
            this.selectedCheck.setName(this.reportType.name() + "Check");
            this.reportButton = new JButton(this.reportType.getLabel());
            this.reportButton.setIcon(IconLoader.get((String)("/waitermate/images/" + this.reportType.name().toLowerCase() + "_report.png")));
            this.reportButton.setPreferredSize(new Dimension(300, 70));
            this.reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WaitermateReportSelectionPanel.this.reportPressed.emit((Object)ReportSelection.this.reportType);
                }
            });
            this.reportButton.setName(this.reportType.name() + "Button");
            this.reportButton.setVerticalAlignment(0);
            this.reportButton.setHorizontalAlignment(2);
            StandardSecurityDecorator checkSec = new StandardSecurityDecorator((JComponent)this.selectedCheck, this.reportType.getDefaultPermission());
            StandardSecurityDecorator reportSec = new StandardSecurityDecorator((JComponent)this.reportButton, this.reportType.getDefaultPermission());
            this.add((Component)checkSec);
            this.add((Component)reportSec);
        }

        @Override
        public void setEnabled(boolean value) {
            this.selectedCheck.setEnabled(value);
            this.reportButton.setEnabled(value);
            super.setEnabled(value);
        }

        boolean isSelected() {
            return this.selectedCheck.isSelected();
        }

        void setSelected(boolean value) {
            this.selectedCheck.setSelected(value);
        }
    }
}

