/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports.impl;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.tax.TaxCodeReportItem;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.RefundAccount;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.reports.impl.AbstractWaitermateReport;

public class AccountsWaitermateReport
extends AbstractWaitermateReport {
    private RestaurantTakingsSummary summary;

    public AccountsWaitermateReport(RestaurantTakingsSummary summary) {
        this.summary = summary;
    }

    @Override
    public void performReport() {
        AccountType[] accountTypes;
        this.clear();
        this.add(BusinessInfo.getInstance().getName());
        this.add("");
        this.add("Shift: " + new SimpleDateFormat("E MMM d, yyyy").format(this.summary.getShift().getTradingDay().getDate()));
        this.add("Trading day commenced : " + DateTimeUtils.getSimpleTimeFormat().format(this.summary.getShift().getTradingDay().getTime()));
        this.add("");
        if (this.summary.getNumAccountsTotal(true) > 0) {
            this.add("***************************");
            this.add("There are " + this.summary.getNumAccountsTotal(true) + " opened account(s).");
            this.add("You should ensure that all accounts are closed");
            this.add("before change of day.");
            this.add("***************************");
            this.add("");
        }
        for (AccountType accountType : accountTypes = AccountType.getTypes()) {
            AccountType currentType = accountType;
            if (currentType.equals((Object)RefundAccount.TYPE)) continue;
            this.appendAccountInfo(accountType, accountType.getLabel(), this.summary);
            if (!currentType.equals((Object)PhoneAccount.DELIVERY_TYPE)) continue;
            this.add(this.columns("    Delivery fees", this.summary.getDeliveryFees(), 42));
        }
        this.add("");
        int numOpen = this.summary.getNumAccountsTotal(true);
        int numClosed = this.summary.getNumAccountsTotal(false);
        int totalNum = numOpen + numClosed;
        Price totalOpen = this.summary.getAccountsTotal(true);
        Price totalClosed = this.summary.getAccountsTotal(false);
        Price totalOpenExDisc = this.summary.getAccounts(null, true, false);
        Price totalClosedExDisc = this.summary.getAccounts(null, false, false);
        Price totalTakings = this.summary.getAccountsTotal();
        Price totalTakingsExDisc = totalOpenExDisc.add(totalClosedExDisc);
        if (SystemProperty.getInstance().isTakingsExDiscounts()) {
            this.add(numOpen + " open accounts");
            this.add("  Total Ex Discounts:  " + totalOpenExDisc);
            this.add("  Total Inc Discounts: " + totalOpen);
            this.add(numClosed + " closed accounts");
            this.add("  Total Ex Discounts:  " + totalClosedExDisc);
            this.add("  Total Inc Discounts: " + totalClosed);
        } else {
            this.add("Total (open):   " + totalOpen + ", " + numOpen + " acc");
            this.add("Total (closed): " + totalClosed + ", " + numClosed + " acc");
            this.add("");
        }
        for (TaxCodeReportItem reportItem : this.summary.getTaxPaidTotals()) {
            if (reportItem.getAmount().isZero()) continue;
            this.add(reportItem.getTaxCode().getCode() + " Component:         " + reportItem.getAmount());
        }
        if (SystemProperty.getInstance().isTakingsExDiscounts()) {
            this.add("Total Ex Discounts (Inc " + Internationalization.getLiteralFor((String)"TAX") + "): " + totalTakingsExDisc);
            this.add("Total Inc Discounts (Inc " + Internationalization.getLiteralFor((String)"TAX") + "):" + totalTakings + ", " + totalNum + " acc");
        } else {
            this.add("Total (Inc " + Internationalization.getLiteralFor((String)"TAX") + "):       " + totalTakings + ", " + totalNum + " acc");
        }
        this.doTax();
        this.add("Total Ex " + Internationalization.getLiteralFor((String)"TAX") + ":          " + this.summary.getAccountsTotalExTax());
        this.doCategoryLocationEx();
        this.doCategoryLocation();
        this.doDiscountBreakdownByLocation();
        this.doDollarsPerHead();
        this.doStaleAccounts();
    }

    private void doTax() {
        for (TaxCodeReportItem reportItem : this.summary.getTaxSalesTotals()) {
            if (reportItem.getTaxCode().equals((Object)TaxCode.getFreeCode())) {
                this.add(Internationalization.getLiteralFor((String)"TAX") + " Free sales:        " + reportItem.getAmount());
                continue;
            }
            this.add("Sales subject to " + reportItem.getTaxCode().getCode() + ":  " + reportItem.getAmount());
        }
    }

    private void doCategoryLocationEx() {
        if (SystemProperty.getInstance().isTakingsExDiscounts()) {
            this.add("");
            this.add("Sales Category Breakdown Ex Discounts");
            for (RestaurantTakingsSummary.LocationSales locationSales : this.summary.getLocationSales()) {
                this.add(locationSales.getLocationName() + " - " + locationSales.getTotalSalesExDiscounts());
                for (String category : locationSales.getCategories()) {
                    Price total = locationSales.getSalesForCategoryExDiscounts(category);
                    this.add("    " + category + " - " + total);
                }
            }
        }
    }

    private void doCategoryLocation() {
        this.add("");
        if (SystemProperty.getInstance().isTakingsExDiscounts()) {
            this.add("Sales Category Breakdown Inc Discounts");
        } else {
            this.add("Sales Category Breakdown");
        }
        for (RestaurantTakingsSummary.LocationSales locationSales : this.summary.getLocationSales()) {
            this.add(locationSales.getLocationName() + " - " + locationSales.getTotalSales());
            for (String category : locationSales.getCategories()) {
                StringBuilder SB = new StringBuilder("    ").append(category).append(" - ").append(locationSales.getSalesForCategory(category));
                this.add(SB.toString());
            }
        }
        this.add("");
    }

    private void doDollarsPerHead() {
        this.add("");
        this.add(Internationalization.getLiteralFor((String)"NUMBER_OF_COVERS") + ": " + this.summary.getNumPatrons());
        this.add("Dollars per head: " + this.summary.getDollarsPerHead());
    }

    private void doStaleAccounts() {
        if (this.summary.getNumOfAccountsWithSalesOnOtherShifts() > 0) {
            this.add("");
            this.add("**********************************");
            String line = "There were sales made to " + this.summary.getNumOfAccountsWithSalesOnOtherShifts() + " account";
            if (this.summary.getNumOfAccountsWithSalesOnOtherShifts() > 1) {
                line = line + "s";
            }
            this.add(line);
            this.add("created in previous finance shifts.");
            this.add("Account totals, category sales and ");
            this.add("takings may not balance due to this.");
            this.add("**********************************");
        }
    }

    private void appendAccountInfo(AccountType type, String name, RestaurantTakingsSummary summary) {
        this.add(name);
        int numOpen = summary.getNumAccounts(type, true);
        Price totalOpen = summary.getAccounts(type, true);
        this.add(this.columns("    " + numOpen + " Open Account(s) @", totalOpen, 42));
        int numClosed = summary.getNumAccounts(type, false);
        Price totalClosed = summary.getAccounts(type, false);
        this.add(this.columns("    " + numClosed + " Closed Account(s) @", totalClosed, 42));
        int numPatrons = summary.getNumPatronsForAccount(type, false);
        Price dollarsPerHead = summary.getDollarsPerHeadForAccount(type, false);
        this.add(this.columns("    " + numPatrons + " " + Internationalization.getLiteralFor((String)"COVER") + "(s) @", dollarsPerHead, 42));
    }

    private void doDiscountBreakdownByLocation() {
        this.add("Discount Breakdown");
        for (RestaurantTakingsSummary.LocationSales locationSales : this.summary.getLocationSales()) {
            this.add(locationSales.getLocationName() + " - " + locationSales.getTotalDiscounts());
            for (InventoryPriceAdjustment priceAdj : locationSales.getAllDiscounts()) {
                this.add(this.columns("    " + (priceAdj == null ? "<No Label>" : priceAdj.getLabel()) + " - " + locationSales.getDiscountCount(priceAdj), locationSales.getMoneyLostToDiscount(priceAdj), 42));
            }
        }
    }
}

