/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports.impl;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.BusinessInfo;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.reports.impl.AbstractWaitermateReport;

public class AllCashdrawersWaitermateReport
extends AbstractWaitermateReport {
    private RestaurantTakingsSummary summary;

    public AllCashdrawersWaitermateReport(RestaurantTakingsSummary yourSummary) {
        this.summary = yourSummary;
    }

    @Override
    public void performReport() {
        this.clear();
        this.add(BusinessInfo.getInstance().getName());
        this.add("");
        this.add("Shift: " + new SimpleDateFormat("E MMM d, yyyy").format(this.summary.getShift().getTradingDay().getDate()));
        this.add("Trading day commenced : " + DateTimeUtils.getSimpleTimeFormat().format(this.summary.getShift().getTradingDay().getTime()));
        if (this.summary.getNumAccountsTotal(true) != 0) {
            this.add("");
            this.add("There are " + this.summary.getNumAccountsTotal(true) + " opened account(s)\nYou should ensure that all accounts are closedbefore change of day.");
        }
        if (this.summary.getNumOfAccountsWithSalesOnOtherShifts() != 0) {
            this.add("");
            this.add("There were sales made to accounts created on previous finance shifts. Sales and takings may not balance because of this.");
        }
        this.add("");
        for (CashDrawer drawer : this.summary.getCashDrawers()) {
            if (this.summary.getCashDrawerSkims(drawer) != null && this.summary.getCashDrawerSkims(drawer).doubleValue() > 0.0) {
                this.add(this.columns(drawer.getLabel() + " level", this.summary.getCashDrawerLevel(drawer), 42));
                this.add(this.columns("Skimmed", this.summary.getCashDrawerSkims(drawer), 42));
                this.add(this.columns("Total", this.summary.getCashDrawerTakings(drawer), 42));
                this.add("");
                continue;
            }
            Price cashDrawerTakings = this.summary.getCashDrawerTakings(drawer);
            if (!drawer.isActive() && cashDrawerTakings.isZero()) continue;
            this.add(this.columns(drawer.getLabel(), this.summary.getCashDrawerTakings(drawer), 42));
            this.add("");
        }
        this.add(this.columns("Total: ", this.summary.getCashDrawerTakingsTotal(), 42));
        this.add("");
        if (!this.summary.getLoyalty().equals((Object)Price.ZERO_DOLLAR)) {
            this.add("Loyalty: " + this.summary.getLoyalty());
        }
        this.add("Cash Tips: " + this.summary.getCashTips());
        this.add("Card Tips: " + this.summary.getCardTips());
        this.add("Web Tips: " + this.summary.getWebTips());
        this.add("Total Tips: " + this.summary.getTotalTips());
        this.add("Deleted Items: " + this.summary.getCostOfDeletedItems());
        this.add("Refunded Items: " + this.summary.getCostOfRefundedItems());
        this.add("Refunded Previous Items: " + this.summary.getCostOfRefundsFromPreviousShifts());
        this.add("Total No Sales: " + this.summary.getTotalNumberOfNoSales());
        this.add("");
        if (this.summary.hasRefundedDebtorSales()) {
            this.add(this.columns("Gross Debtor Sales: ", this.summary.getTotalGrossDebtorsAdded(), 42));
            this.add(this.columns("Refunded Debtor Sales: ", this.summary.getTotalRefundedDebtorSales(), 42));
        }
        this.add(this.columns("Nett Debtor Sales: ", this.summary.getTotalNettDebtorsAdded(), 42));
        if (this.summary.hasRefundedDebtorPayments() || this.summary.hasAdjustedDebtorPayments()) {
            this.add("");
            this.add(this.columns("Gross Debtor Payments:", this.summary.getTotalGrossDebtorsPaid(), 42));
        }
        if (this.summary.hasRefundedDebtorPayments()) {
            this.add(this.columns("Refunded Debtor Payments: ", this.summary.getTotalRefundedDebtorPayments(), 42));
        }
        if (this.summary.hasAdjustedDebtorPayments()) {
            this.add(this.columns("Debtor Surcharge: ", this.summary.getTotalDebtorsSurcharged(), 42));
            this.add(this.columns("Debtor Discount: ", this.summary.getTotalDebtorsDiscounted(), 42));
        }
        this.add(this.columns("Nett Debtor Payments:", this.summary.getTotalNettDebtorsPaid(), 42));
        if (this.summary.hasDiscountedDebtors()) {
            this.add(this.columns("Debtor Discounted ", this.summary.getTotalDebtorsDiscounted(), 42));
        }
        if (this.summary.hasDiscounts()) {
            this.add("");
            this.add("Discounts:");
            for (InventoryPriceAdjustment discount : this.summary.getAllDiscounts()) {
                Price money = this.summary.getMoneyLostToDiscount(discount);
                int count = this.summary.getDiscountCount(discount);
                this.add(discount + " - " + money + " (" + count + " times)");
            }
        }
        if (this.summary.hasSurcharges()) {
            Price money;
            this.add("");
            this.add("Surcharges:");
            int customSurchargeCount = 0;
            Price totalCustomSurchargeAmount = Price.ZERO_DOLLAR;
            for (InventoryPriceAdjustment adjustment : this.summary.getAllSurcharges()) {
                if (!PriceAdjustmentType.CUSTOM.equals((Object)adjustment.getType())) continue;
                money = this.summary.getMoneyGainedToSurchages(adjustment);
                totalCustomSurchargeAmount = totalCustomSurchargeAmount.add(money);
                ++customSurchargeCount;
            }
            if (customSurchargeCount > 0) {
                this.add("Custom :");
                this.add(customSurchargeCount + " - " + totalCustomSurchargeAmount.toString());
            }
            for (InventoryPriceAdjustment adj : this.summary.getAllSurcharges()) {
                if (PriceAdjustmentType.CUSTOM.equals((Object)adj.getType())) continue;
                money = this.summary.getMoneyGainedToSurchages(adj);
                int count = this.summary.getSurchargeCount(adj);
                this.add(adj + " - " + money + " (" + count + " times)");
            }
        }
        this.add("");
        this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_REDEEMS") + ":", this.summary.getTotalVoucherRedeems() != null ? this.summary.getTotalVoucherRedeems() : Price.ZERO_DOLLAR, 42));
        this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_TOPUPS") + ":", this.summary.getTotalVoucherTopups() != null ? this.summary.getTotalVoucherTopups() : Price.ZERO_DOLLAR, 42));
        this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_REDEEM_REVERSALS") + ":", this.summary.getTotalVoucherRedeems() != null ? this.summary.getTotalVoucherRedeemReversals() : Price.ZERO_DOLLAR, 42));
        this.add(this.columns(Internationalization.getLiteralFor((String)"VOUCHER_TOPUP_REVERSALS") + ":", this.summary.getTotalVoucherTopups() != null ? this.summary.getTotalVoucherTopupReversals() : Price.ZERO_DOLLAR, 42));
        this.add("");
        this.add("Paid Previous Items:" + this.summary.getPaidPreviousItems());
    }
}

