/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.reports.impl;

import au.com.ordermate.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.users.User;
import waitermate.gui.screens.admin.reports.impl.AbstractWaitermateReport;

public class LabourWaitermateReport
extends AbstractWaitermateReport {
    private RestaurantTakingsSummary summary;

    public LabourWaitermateReport(RestaurantTakingsSummary yourSummary) {
        this.summary = yourSummary;
    }

    @Override
    public void performReport() {
        this.add(BusinessInfo.getInstance().getName());
        this.add("");
        this.add("Shift: " + new SimpleDateFormat("E MMM d, yyyy").format(this.summary.getShift().getTradingDay().getDate()));
        this.add("Trading day commenced: " + DateTimeUtils.getSimpleTimeFormat().format(this.summary.getShift().getTradingDay().getTime()));
        this.add("");
        if (this.summary.getShift().getTradingDay().isOpen() && !this.summary.getClockedOnUser().isEmpty()) {
            this.add("");
            this.add("Clocked on user(s): ");
            for (User user : this.summary.getClockedOnUser()) {
                this.add("    " + user.getFirstName() + " " + user.getLastName());
            }
        }
        if (this.summary.getShift().getTradingDay().isOpen()) {
            this.add("");
            this.add("Labour Previous Hour: " + this.summary.getStaffCostPreviousHour().getTimeRange());
            this.add("Previous Hourly Sales: " + this.summary.getStaffCostPreviousHour().getTotalPeriodSales());
            this.add(this.summary.getStaffCostPreviousHour() + "");
            this.add("");
            this.add("Labour Current Hour: " + this.summary.getStaffCostCurrentHour().getTimeRange());
            this.add("Current Hourly Sales: " + this.summary.getStaffCostCurrentHour().getTotalPeriodSales());
            this.add(this.summary.getStaffCostCurrentHour() + "");
            this.add("");
        }
        this.add("Daily Labour:");
        this.add("Daily Sales: " + this.summary.getStaffCostToday().getTotalPeriodSales());
        this.add(this.summary.getStaffCostToday() + "");
    }
}

