/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.skims.createskim;

import au.com.ordermate.util.Price;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.scroll.renderer.SkimTransactionSubType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.gui.screens.admin.skims.createskim.CreateSkimGui;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class CreateSkim
extends AbstractScreen {
    private CreateSkimGui gui;
    private NavBar nav;
    private CashDrawer drawer;
    private SkimTransactionSubType transaction;
    public final Signal cancel = Signals.createSignal();
    public final Signal done = Signals.createSignal();

    public CreateSkim() {
        this.gui = new CreateSkimGui();
        this.gui.amountUpdated.connect((Object)this, "gotAmountUpdated");
        this.gui.selectedUpdated.connect((Object)this, "gotSelectedUpdated");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.addRight((Component)this.nav.getCancelButton());
        this.nav.ok.connect((Object)this, "gotOk");
        this.nav.back.connect((Object)this, "gotCancel");
        this.nav.cancel.connect((Object)this, "gotCancel");
    }

    public void start(CashDrawer newDrawer) {
        this.drawer = newDrawer;
        this.display();
        this.gui.reset(CashDrawerTakingsSummary.getSummary((CashDrawer)this.drawer, (Shift)Terminal.getLocalHost().getShift()));
        this.updateNav();
    }

    private void updateNav() {
        this.nav.setText("Skim total for " + this.drawer.getLabel() + " " + this.gui.getSkimTotal());
        if (this.gui.getValidTransactions().size() > 0) {
            this.nav.getOkButton().setEnabled(true);
        } else {
            this.nav.getOkButton().setEnabled(false);
        }
    }

    public void gotOk() {
        boolean proceed = Dialogs.displayChoiceDialog((String)("Process skim of " + this.gui.getSkimTotal() + " for drawer " + this.drawer.getLabel()), (String)"Process cashdrawer skim?", (boolean)true);
        if (!proceed) {
            return;
        }
        Skim newSkim = new Skim(LoginManager.getInstance().getUser(), Terminal.getLocalHost().getShift(), this.drawer);
        List transactions = this.gui.getValidTransactions();
        for (SkimTransactionSubType current : transactions) {
            newSkim.addTransaction(current.getTransaction().getAmount(), current.getTransaction().getFinanceUnit());
        }
        this.drawer.openCashDrawerSkim(LoginManager.getInstance().getUser());
        Terminal theTerminal = Terminal.getLocalHost();
        List printers = theTerminal.getAvailableReceiptPrinters();
        ArrayList<Skim> skims = new ArrayList<Skim>();
        skims.add(newSkim);
        newSkim.save();
        TerminalEventLog.logCashDrawerSkim((User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost(), (Skim)newSkim);
        try {
            DocketProcessor.printSkimDocket((Terminal)theTerminal, (Collection)printers, skims);
        }
        catch (IOException e) {
            WaiterMate.LOG.error("Couldn't print reservations for day", (Throwable)e);
        }
        this.cancel.emit();
    }

    public void gotCancel() {
        this.cancel.emit();
    }

    void gotAmountUpdated(Price newPrice) {
        if (this.transaction == null) {
            return;
        }
        this.transaction.getTransaction().setAmount(newPrice);
        this.gui.refresh();
        this.updateNav();
    }

    void gotSelectedUpdated(SkimTransactionSubType newTrans) {
        this.transaction = newTrans;
        this.gui.enableKeypad(this.transaction != null);
        this.gui.setKeypadValue(this.transaction != null ? this.transaction.getTransaction().getAmount() : Price.ZERO_DOLLAR);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }
}

