/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.stock.stockrequisition;

import java.util.List;
import javax.swing.JComponent;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.users.AllPermissions;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.admin.stock.stockrequisition.StockRequisitionNavBar;
import waitermate.gui.screens.admin.stock.stockrequisition.StockRequisitionPanel;
import waitermate.gui.screens.admin.stock.stockrequisition.stockrequisitionorder.StockRequisitionOrderScreen;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.LockingDialog;
import waitermate.guikit.dialogs.PopupWindow;

public class StockRequisitionScreen
extends AbstractScreen {
    private StockRequisitionNavBar navPanel;
    private StockRequisitionPanel mainPanel;
    public final Signal back = Signals.createSignal();
    public final Signal logout = Signals.createSignal();
    StockRequisitionOrderScreen stockRequisitionOrderScreen = new StockRequisitionOrderScreen();

    public StockRequisitionScreen() {
        this.stockRequisitionOrderScreen.back.connect((Object)this, "startStockRequisition");
        this.mainPanel = new StockRequisitionPanel();
        this.mainPanel.item.connect((Object)this, "gotItem");
        this.navPanel = new StockRequisitionNavBar();
        this.navPanel.newReqSignal.connect((Object)this, "gotNewRequisition");
        this.navPanel.back.connect((Object)this, "gotBack");
    }

    public JComponent getMainArea() {
        return this.mainPanel;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    public void startStockRequisition() {
        this.mainPanel.updatePanel();
        this.display();
    }

    public void gotNewRequisition() {
        List areaList = StockArea.getStockAreas();
        if (areaList != null && !areaList.isEmpty() && areaList.size() > 1) {
            this.stockRequisitionOrderScreen.startStockRequistionOrder(new StockRequisitionOrder(LoginManager.getEventContext().getTerminal().getStockArea(), null, LoginManager.getEventContext().getUser()));
        } else {
            Dialogs.displayOkDialog((String)"Too Few Stock Areas to perform Transfer", (String)"Stock Transfer Configuration Error");
        }
    }

    public void gotItem(StockRequisitionOrder selectedStockRequsition) {
        if (!selectedStockRequsition.isLocked() || Dialogs.displayDialog((PopupWindow)new LockingDialog(AllPermissions.UNLOCK_STOCK_REQUISITION, "Locked by " + selectedStockRequsition.getUser(), "Stock Requisition is locked!"), null, null)) {
            selectedStockRequsition.lock(LoginManager.getEventContext().getUser());
            this.stockRequisitionOrderScreen.startStockRequistionOrder(selectedStockRequsition);
        }
    }

    public void gotBack() {
        this.back.emit();
    }
}

