/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.stock.stockrequisition.stockrequisitionorder;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.requisition.StockRequisition;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.stockitems.StockAreaPairSelector;
import waitermate.gui.displayitems.stockitems.StockItemBrowser;
import waitermate.gui.displayitems.stockrequisition.DefaultStockRequisitionRenderer;

public class StockRequistionOrderPanel
extends JPanel
implements ActionListener {
    public final Signal stockItem = Signals.createSignal(StockItem.class, (String)"theNewItem");
    public final Signal item = Signals.createSignal(StockRequisition.class, (String)"selectedRequisition");
    public final Signal delete = Signals.createSignal(StockRequisition.class, (String)"selectedRequisition");
    public final Signal areaSelected = Signals.createSignal(StockArea.class, (String)"selectedAreaFrom", StockArea.class, (String)"selectedAreaTo");
    private JPanel centerPanel;
    private JPanel stockOrderingPanel;
    private JPanel orderedItemPanel;
    private StockRequisitionOrder selected;
    private StockItemBrowser browser;
    private DefaultStockRequisitionRenderer renderer;
    private RendererScrollPaneModel items;
    private CustomScrollPane itemsPane;
    private StockAreaPairSelector stockAreaSelector;

    public StockRequistionOrderPanel() {
        this.setLayout(new BorderLayout());
        this.initComponents();
    }

    private void initComponents() {
        this.stockAreaSelector = new StockAreaPairSelector("Transfer Stock From ", " To ");
        this.stockAreaSelector.areaSelected.connect((Object)this, "gotStockAreas");
        this.add((Component)this.stockAreaSelector, "North");
        this.stockOrderingPanel = new JPanel(new BorderLayout());
        this.orderedItemPanel = new JPanel(new BorderLayout());
        this.browser = new StockItemBrowser();
        this.browser.itemSelected.connect((Object)this, "gotStockItem");
        this.stockOrderingPanel.setBorder(BorderFactory.createTitledBorder("Stock Browser"));
        this.stockOrderingPanel.add((Component)this.browser, "Center");
        this.orderedItemPanel.setBorder(BorderFactory.createTitledBorder("Stock To Transfer"));
        this.renderer = new DefaultStockRequisitionRenderer();
        this.renderer.item.connect((Object)this, "gotItem");
        this.renderer.delete.connect((Object)this, "gotDelete");
        this.items = new RendererScrollPaneModel((Renderer)this.renderer, 1, 7);
        this.itemsPane = new CustomScrollPane((CustomScrollPaneModel)this.items);
        this.itemsPane.setEmptyMessage("No Stock Requisition Items to display");
        this.itemsPane.setName("stockRequisitionItemsPane");
        this.orderedItemPanel.add((Component)this.itemsPane, "Center");
        this.centerPanel = new JPanel((LayoutManager)new GraphPaperLayout(10, 1));
        this.centerPanel.add((Component)this.stockOrderingPanel, new Rectangle(0, 0, 7, 1));
        this.centerPanel.add((Component)this.orderedItemPanel, new Rectangle(7, 0, 3, 1));
        this.add((Component)this.centerPanel, "Center");
    }

    public void updatePanel(StockRequisitionOrder selectedOrder) {
        this.selected = selectedOrder;
        this.stockAreaSelector.newStockRequisitionOrder(selectedOrder);
        this.items.setObjects(this.selected.getRequisitions());
        this.browser.updateResults();
    }

    public void gotItem(StockRequisition selectedRequisition) {
        this.item.emit((Object)selectedRequisition);
    }

    public void gotDelete(StockRequisition selectedRequisition) {
        this.delete.emit((Object)selectedRequisition);
    }

    public void gotStockItem(StockItem selectedItem) {
        this.stockItem.emit((Object)selectedItem);
    }

    public void gotStockAreas(StockArea areaFrom, StockArea areaTo) {
        this.areaSelected.emit((Object)areaFrom, (Object)areaTo);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void resetPanel() {
        this.browser.reset();
    }

    protected StockItemBrowser getBrowser() {
        return this.browser;
    }

    protected CustomScrollPane getItemsPane() {
        return this.itemsPane;
    }

    protected StockAreaPairSelector getStockAreaSelector() {
        return this.stockAreaSelector;
    }
}

