/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.surchargesdiscounts.addeditsurcharge;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.Dialogs;

class AddEditSurchargeGui
extends JPanel
implements ActionListener {
    private JButton amountButton;
    private JToggleButton discountButton;
    private JToggleButton surchargeButton;
    private ButtonGroup typesGroup;
    private ButtonGroup unitsGroup;
    private JToggleButton percentageButton;
    private JToggleButton dollarAmountButton;
    private JLabel dateLabel;

    public AddEditSurchargeGui() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        this.dateLabel = new JLabel();
        this.discountButton = new JToggleButton(Internationalization.getLiteralFor((String)"DISCOUNT"));
        this.discountButton.setPreferredSize(new Dimension(200, 50));
        this.surchargeButton = new JToggleButton(Internationalization.getLiteralFor((String)"SURCHARGE"));
        this.surchargeButton.setPreferredSize(new Dimension(200, 50));
        this.percentageButton = new JToggleButton(Internationalization.getLiteralFor((String)"PERCENTAGE"));
        this.percentageButton.setPreferredSize(new Dimension(200, 50));
        this.dollarAmountButton = new JToggleButton(Internationalization.getLiteralFor((String)"DOLLAR_AMOUNT"));
        this.dollarAmountButton.setPreferredSize(new Dimension(200, 50));
        this.discountButton.setSelected(true);
        this.percentageButton.setSelected(true);
        this.unitsGroup = new ButtonGroup();
        this.unitsGroup.add(this.percentageButton);
        this.unitsGroup.add(this.dollarAmountButton);
        this.typesGroup = new ButtonGroup();
        this.typesGroup.add(this.surchargeButton);
        this.typesGroup.add(this.discountButton);
        JPanel types = new JPanel(new FlowLayout(0));
        types.add(this.discountButton);
        types.add(this.surchargeButton);
        types.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"TYPE") + ":"));
        JPanel units = new JPanel(new FlowLayout(0));
        units.add(this.percentageButton);
        units.add(this.dollarAmountButton);
        units.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"UNIT") + ":"));
        JPanel amountPanel = new JPanel(new FlowLayout(0));
        amountPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"AMOUNT") + ":"));
        this.amountButton = new JButton("0");
        this.amountButton.setName("amountButton");
        this.amountButton.setPreferredSize(new Dimension(200, 50));
        this.amountButton.addActionListener(this);
        amountPanel.add(this.amountButton);
        JPanel information = new JPanel();
        information.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 8)));
        information.add((Component)this.dateLabel, new Rectangle(3, 0, 6, 1));
        information.add((Component)types, new Rectangle(1, 1, 8, 2));
        information.add((Component)units, new Rectangle(1, 3, 8, 2));
        information.add((Component)amountPanel, new Rectangle(1, 5, 8, 2));
        this.add((Component)information, new Rectangle(0, 1, 19, 20));
    }

    public void setupGui(InventoryPriceAdjustment theSurcharge) {
        this.dateLabel.setText(Internationalization.getLiteralFor((String)"DISCOUNT_SURCHARGE_FOR") + " " + DateTimeUtils.getMediumDateFormat().format(new Date()));
        this.dateLabel.setFont(OrderMateTheme.getMediumFont());
        if (theSurcharge != null) {
            String amountText = theSurcharge.getUnit().equals((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT) ? String.valueOf(theSurcharge.getAmount()) : ((Price)theSurcharge.getAmount()).toString(false);
            this.amountButton.setText(amountText);
        } else {
            this.amountButton.setText("0");
        }
    }

    public double getAmount() {
        return Double.valueOf(this.amountButton.getText());
    }

    public PriceAdjustmentDirection getType() {
        if (this.surchargeButton.isSelected()) {
            return PriceAdjustmentDirection.SURCHARGE;
        }
        if (this.discountButton.isSelected()) {
            return PriceAdjustmentDirection.DISCOUNT;
        }
        return null;
    }

    public PriceAdjustmentUnit getUnit() {
        if (this.percentageButton.isSelected()) {
            return PriceAdjustmentUnit.PERCENTAGE_UNIT;
        }
        if (this.dollarAmountButton.isSelected()) {
            return PriceAdjustmentUnit.DOLLAR_UNIT;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.amountButton) {
            double currentAmountEntered = Double.valueOf(this.amountButton.getText());
            double percentage = Dialogs.getDouble((String)(Internationalization.getLiteralFor((String)"AMOUNT") + ": "), (double)currentAmountEntered);
            if (percentage != Double.MIN_VALUE) {
                Price newPrice = new Price(percentage);
                this.amountButton.setText(newPrice.doubleValue() + "");
            }
        }
    }
}

