/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.tablesetup;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.hardware.GTL;
import ordermate.database.tables.TableGroup;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.gui.screens.admin.tablesetup.SelectImagePanel;
import waitermate.guikit.dialogs.Dialogs;

public class EditTableGroupPanel
extends JPanel {
    private static final String[] BG_IMAGE_NAMES = new String[]{"/ordermate/images/greyFullScreen.png", "/ordermate/images/greyBreadLarge.png", "/ordermate/images/greyCherriesLarge.png", "/ordermate/images/greyCoffeeLarge.png", "/ordermate/images/greyDrinkLarge.png", "/ordermate/images/greyOrangeLarge.png", "/ordermate/images/greyPearLarge.png", "/ordermate/images/greyBreadSmall.png", "/ordermate/images/greyCherriesSmall.png", "/ordermate/images/greyCoffeeSmall.png", "/ordermate/images/greyDrinkSmall.png", "/ordermate/images/greyOrangeSmall.png", "/ordermate/images/greyPearSmall.png", "/ordermate/images/InFloor.png", "/ordermate/images/InFloor8x6.png", "/ordermate/images/carpet.gif"};
    private static final String[] TABLE_IMAGE_NAMES = new String[]{"/ordermate/images/tableSmall.png", "/ordermate/images/tableMedium.png", "/ordermate/images/tableLarge.png"};
    private Map<String, ImageIcon> scaledTableImages = new LinkedHashMap<String, ImageIcon>();
    private Map<String, ImageIcon> scaledBackgroundImages = new LinkedHashMap<String, ImageIcon>();
    private JLabel nameLabel;
    private JLabel displayNameLabel;
    private JButton nameButton_ScreenEntry;
    private JLabel tableImageLabel;
    private JButton tableImageButton;
    private JLabel backgroundImageLabel;
    private JButton backgroundImageButton;
    private static final int SCALE_TO_WIDTH = -1;
    private static final int SCALE_TO_HEIGHT = 75;
    private TableGroup section;
    private GTL gtl;

    public EditTableGroupPanel(TableGroup theSection, GTL gtl) {
        int i;
        this.section = theSection;
        this.setLayout(new GridLayout(3, 2));
        this.gtl = gtl;
        this.nameLabel = new JLabel("Name: ");
        this.nameLabel.setFont(OrderMateTheme.getLargeFont());
        this.displayNameLabel = new JLabel(this.section.getName());
        this.displayNameLabel.setFont(OrderMateTheme.getLargeFont());
        this.displayNameLabel.setHorizontalAlignment(0);
        this.displayNameLabel.setVerticalAlignment(0);
        JPanel namePanel = new JPanel(new BorderLayout());
        this.nameButton_ScreenEntry = new JButton(IconLoader.get((String)"/waitermate/guikit/images/keyboard.png"));
        this.nameButton_ScreenEntry.addActionListener(new InnerActionListener());
        namePanel.add((Component)this.nameButton_ScreenEntry, "East");
        namePanel.add((Component)this.displayNameLabel, "Center");
        this.add(this.nameLabel);
        this.add(namePanel);
        for (i = 0; i < BG_IMAGE_NAMES.length; ++i) {
            this.scaledBackgroundImages.put(BG_IMAGE_NAMES[i], null);
        }
        for (i = 0; i < TABLE_IMAGE_NAMES.length; ++i) {
            this.scaledTableImages.put(TABLE_IMAGE_NAMES[i], null);
        }
        if (!GTL.None.equals((Object)gtl)) {
            this.tableImageLabel = new JLabel("Tables: ");
            this.tableImageLabel.setFont(OrderMateTheme.getLargeFont());
            this.tableImageButton = new JButton(this.getMiniTableIcon(this.section.getTableImageName()));
            this.backgroundImageLabel = new JLabel("Background:   ");
            this.backgroundImageLabel.setFont(OrderMateTheme.getLargeFont());
            this.backgroundImageButton = new JButton(this.getMiniBackgroundIcon(this.section.getBackgroundImage()));
            this.tableImageButton.addActionListener(new InnerActionListener());
            this.backgroundImageButton.addActionListener(new InnerActionListener());
            this.add(this.tableImageLabel);
            this.add(this.tableImageButton);
            this.add(this.backgroundImageLabel);
            this.add(this.backgroundImageButton);
        }
    }

    private ImageIcon getMiniTableIcon(String filename) {
        ImageIcon icon = this.scaledTableImages.get(filename);
        if (icon == null) {
            icon = this.loadScaledIcon(filename);
            this.scaledTableImages.put(filename, icon);
        }
        return icon;
    }

    private ImageIcon getMiniBackgroundIcon(String filename) {
        ImageIcon icon = this.scaledBackgroundImages.get(filename);
        if (icon == null) {
            icon = this.loadScaledIcon(filename);
            this.scaledBackgroundImages.put(filename, icon);
        }
        return icon;
    }

    private void initialiseTableIcons() {
        for (int i = 0; i < TABLE_IMAGE_NAMES.length; ++i) {
            String filename = TABLE_IMAGE_NAMES[i];
            if (this.scaledTableImages.get(filename) != null) continue;
            this.getMiniTableIcon(filename);
        }
    }

    private void initialiseBackgroundIcons() {
        for (int i = 0; i < BG_IMAGE_NAMES.length; ++i) {
            String filename = BG_IMAGE_NAMES[i];
            if (this.scaledBackgroundImages.get(filename) != null) continue;
            this.getMiniBackgroundIcon(filename);
        }
    }

    private ImageIcon loadScaledIcon(String filename) {
        ImageIcon originalIcon = new ImageIcon(IconLoader.getImage((String)filename));
        Image iconImage = originalIcon.getImage();
        if (iconImage.getHeight(this) < 75) {
            return originalIcon;
        }
        return new ImageIcon(iconImage.getScaledInstance(-1, 75, 2));
    }

    @Override
    public String getName() {
        return this.displayNameLabel.getText();
    }

    public String getTableImageFile() {
        ImageIcon selectedIcon = (ImageIcon)this.tableImageButton.getIcon();
        for (Map.Entry<String, ImageIcon> entry : this.scaledTableImages.entrySet()) {
            String file = entry.getKey();
            ImageIcon icon = entry.getValue();
            if (icon == null || !icon.equals(selectedIcon)) continue;
            return file;
        }
        return "";
    }

    public String getBackgroundImageFile() {
        ImageIcon selectedIcon = (ImageIcon)this.backgroundImageButton.getIcon();
        for (Map.Entry<String, ImageIcon> entry : this.scaledBackgroundImages.entrySet()) {
            String file = entry.getKey();
            ImageIcon icon = entry.getValue();
            if (icon == null || !icon.equals(selectedIcon)) continue;
            return file;
        }
        return "";
    }

    class InnerActionListener
    implements ActionListener {
        InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == EditTableGroupPanel.this.nameButton_ScreenEntry) {
                String text = Dialogs.getString((String)"Enter section name: ", (String)EditTableGroupPanel.this.displayNameLabel.getText(), (boolean)true, (String)"Enter section name ");
                if (text != "\u0000") {
                    EditTableGroupPanel.this.displayNameLabel.setText(text);
                }
            } else if (src == EditTableGroupPanel.this.tableImageButton) {
                EditTableGroupPanel.this.initialiseTableIcons();
                ArrayList<ImageIcon> images = new ArrayList<ImageIcon>(EditTableGroupPanel.this.scaledTableImages.values());
                List<String> labels = Arrays.asList(TABLE_IMAGE_NAMES);
                SelectImagePanel panel = new SelectImagePanel(images, labels);
                boolean okPressed = Dialogs.displayDialog((JComponent)panel, (String)"Select table image", (String)"OK", (String)"Cancel", (boolean)true, (boolean)true, (boolean)true);
                ImageIcon selectedImage = panel.getSelectedImage();
                if (okPressed && selectedImage != null) {
                    EditTableGroupPanel.this.tableImageButton.setIcon(selectedImage);
                }
            } else if (src == EditTableGroupPanel.this.backgroundImageButton) {
                EditTableGroupPanel.this.initialiseBackgroundIcons();
                ArrayList<ImageIcon> images = new ArrayList<ImageIcon>(EditTableGroupPanel.this.scaledBackgroundImages.values());
                List<String> labels = Arrays.asList(BG_IMAGE_NAMES);
                SelectImagePanel panel = new SelectImagePanel(images, labels);
                boolean okPressed = Dialogs.displayDialog((JComponent)panel, (String)"Select background", (String)"OK", (String)"Cancel", (boolean)true, (boolean)true, (boolean)true);
                ImageIcon selectedImage = panel.getSelectedImage();
                if (okPressed && selectedImage != null) {
                    EditTableGroupPanel.this.backgroundImageButton.setIcon(selectedImage);
                }
            }
            EditTableGroupPanel.this.repaint();
        }
    }
}

