/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.tablesetup;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import ordermate.database.hardware.GTL;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import waitermate.gui.screens.admin.tablesetup.AbstractTableSetupPanel;
import waitermate.gui.tablelayout.GTLMode;
import waitermate.gui.tablelayout.RestaurantDisplayPanel;
import waitermate.gui.tablelayout.TableImageSelector;

public class GraphicalTableSetupPanel
extends AbstractTableSetupPanel {
    private RestaurantDisplayPanel tableDisplay;
    private JPanel buttonPanel;
    private JPanel sideSquisherPanel;
    private JPanel tableButtonPanel;
    private JToggleButton moveTableButton;
    private JToggleButton arrangeTableButton;
    private JToggleButton createTableButton;
    private JToggleButton editTableButton;
    private JToggleButton joinTableButton;
    private JToggleButton splitTableButton;
    private JToggleButton deleteTableButton;
    private JPanel sectionButtonPanel;
    private JButton createSectionButton;
    private JButton editSectionButton;
    private JButton deleteSectionButton;

    public GraphicalTableSetupPanel(GTL gtl) {
        terminalChanged.connect((Object)this, "gotTerminalChanged");
        this.setLayout(new BorderLayout());
        this.tableDisplay = new RestaurantDisplayPanel(true, null, true, gtl);
        this.tableDisplay.tableSelected.connect((Object)this, "gotEditTable");
        this.tableDisplay.tableGroupSelected.connect((Object)this, "gotTableGroupSelected");
        this.tableDisplay.tableGroupUnlocked.connect(this.tableGroupUnlocked);
        this.tableDisplay.createTable.connect((Object)this, "gotCreateTable");
        this.tableDisplay.deleteTable.connect((Object)this, "gotDeleteTable");
        this.tableDisplay.tableJoined.connect(this.tablesMoved);
        this.tableDisplay.tableSplit.connect(this.tablesMoved);
        this.tableDisplay.tableMoved.connect(this.tablesMoved);
        this.tableDisplay.preMove.connect(this.preMove);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.tableButtonPanel = new JPanel();
        this.tableButtonPanel.setLayout(new GridLayout(7, 1));
        this.sectionButtonPanel = new JPanel();
        this.sectionButtonPanel.setLayout(new GridLayout(3, 1));
        TitledBorder border = BorderFactory.createTitledBorder("Tables");
        this.tableButtonPanel.setBorder(border);
        border = BorderFactory.createTitledBorder("Sections");
        this.sectionButtonPanel.setBorder(border);
        this.tableButtonGroup = new ButtonGroup();
        this.moveTableButton = this.makeToggleButton("Move", IconLoader.get((String)"/waitermate/images/icon_movetable.png"));
        this.moveTableButton.setName("moveTable");
        this.arrangeTableButton = this.makeToggleButton("Arrange", IconLoader.get((String)"/waitermate/images/gtlMovePhysical.png"));
        this.arrangeTableButton.setName("arrangeTable");
        this.joinTableButton = this.makeToggleButton("Join", IconLoader.get((String)"/waitermate/images/icon_linktable.png"));
        this.joinTableButton.setName("linkTable");
        this.splitTableButton = this.makeToggleButton("Split", IconLoader.get((String)"/waitermate/images/icon_unlinktable.png"));
        this.splitTableButton.setName("splitTable");
        this.createTableButton = this.makeToggleButton("Create", IconLoader.get((String)"/waitermate/images/icon_createtable.png"));
        this.createTableButton.setName("createTable");
        this.deleteTableButton = this.makeToggleButton("Delete", IconLoader.get((String)"/waitermate/images/icon_deletetable.png"));
        this.deleteTableButton.setName("deleteTable");
        this.editTableButton = this.makeToggleButton("Edit", IconLoader.get((String)"/waitermate/images/icon_edittable.png"));
        this.editTableButton.setName("editTable");
        this.tableButtonPanel.add(this.createTableButton);
        this.tableButtonPanel.add(this.editTableButton);
        this.tableButtonPanel.add(this.deleteTableButton);
        this.tableButtonPanel.add(this.moveTableButton);
        this.tableButtonPanel.add(this.arrangeTableButton);
        this.tableButtonPanel.add(this.joinTableButton);
        this.tableButtonPanel.add(this.splitTableButton);
        this.createSectionButton = this.makeButton("Create", IconLoader.get((String)"/waitermate/images/icon_createsection.png"));
        this.createSectionButton.setName("createSection");
        this.editSectionButton = this.makeButton("Edit", IconLoader.get((String)"/waitermate/images/icon_editsection.png"));
        this.editSectionButton.setName("editSection");
        this.deleteSectionButton = this.makeButton("Deleted", IconLoader.get((String)"/waitermate/images/icon_deletesection.png"));
        this.deleteSectionButton.setName("deleteSection");
        this.sectionButtonPanel.add(this.createSectionButton);
        this.sectionButtonPanel.add(this.editSectionButton);
        this.sectionButtonPanel.add(this.deleteSectionButton);
        this.buttonPanel.add(this.tableButtonPanel);
        this.buttonPanel.add(this.sectionButtonPanel);
        this.sideSquisherPanel = new JPanel(new BorderLayout());
        this.sideSquisherPanel.add((Component)this.buttonPanel, "North");
        this.add((Component)this.sideSquisherPanel, "East");
        this.add((Component)this.tableDisplay, "Center");
        this.tableDisplay.setMode(GTLMode.MovePhysical);
        this.arrangeTableButton.setSelected(true);
        this.refresh();
    }

    void gotCreateTable(PhysicalTable protoType) {
        this.createTable.emit((Object)protoType);
    }

    void gotDeleteTable(LogicalTable toDelete) {
        this.deleteTable.emit((Object)toDelete);
    }

    void gotTableGroupSelected() {
        this.tableGroupSelected.emit();
        this.updateButtonStates();
    }

    void gotEditTable(LogicalTable table) {
        this.editTable.emit((Object)table);
    }

    @Override
    public void setInterfaceLocked(boolean locked, String dialogText, String unlockButtonText) {
        this.tableDisplay.setInterfaceLocked(locked, dialogText, unlockButtonText);
        this.updateButtonStates();
    }

    @Override
    public void setInterfaceLocked(boolean locked) {
        this.tableDisplay.setInterfaceLocked(locked);
        this.updateButtonStates();
    }

    @Override
    public void addTableGroup(TableGroup tableGroup) {
        this.tableDisplay.addTableGroup(tableGroup);
    }

    @Override
    public void removeCurrentTableGroup() {
        this.tableDisplay.removeCurrentTableGroup();
    }

    @Override
    public TableGroup getCurrentTableGroup() {
        return this.tableDisplay.getCurrentTableGroup();
    }

    @Override
    public void setCurrentTableGroup(TableGroup tableGroup) {
        this.tableDisplay.setCurrentTableGroup(tableGroup);
        this.tableGroupSelected.emit();
    }

    @Override
    public List<TableGroup> getTableGroups() {
        return this.getTableDisplayPanel().getTableGroups();
    }

    private void updateButtonStates() {
        boolean interfaceLocked = this.tableDisplay.isInterfaceLocked();
        this.moveTableButton.setEnabled(!interfaceLocked);
        this.createTableButton.setEnabled(!interfaceLocked);
        this.editTableButton.setEnabled(!interfaceLocked);
        this.deleteTableButton.setEnabled(!interfaceLocked);
        this.createSectionButton.setEnabled(!interfaceLocked);
        this.editSectionButton.setEnabled(!interfaceLocked);
        this.deleteSectionButton.setEnabled(!interfaceLocked);
    }

    @Override
    public void refresh() {
        this.tableDisplay.refresh();
        this.updateButtonStates();
        this.revalidate();
        this.repaint();
    }

    public RestaurantDisplayPanel getTableDisplayPanel() {
        return this.tableDisplay;
    }

    @Override
    protected ActionListener createActionListener() {
        return new GTLModeActionListener();
    }

    public void gotTerminalChanged() {
        this.tableDisplay.terminalChanged();
    }

    private class GTLModeActionListener
    implements ActionListener {
        private GTLModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == GraphicalTableSetupPanel.this.moveTableButton) {
                GraphicalTableSetupPanel.this.tableDisplay.setMode(GTLMode.Move);
            } else if (source == GraphicalTableSetupPanel.this.arrangeTableButton) {
                GraphicalTableSetupPanel.this.tableDisplay.setMode(GTLMode.MovePhysical);
            } else if (source == GraphicalTableSetupPanel.this.joinTableButton) {
                GraphicalTableSetupPanel.this.tableDisplay.setMode(GTLMode.Link);
            } else if (source == GraphicalTableSetupPanel.this.splitTableButton) {
                GraphicalTableSetupPanel.this.tableDisplay.setMode(GTLMode.Unlink);
            } else if (source == GraphicalTableSetupPanel.this.createTableButton) {
                TableImageSelector selector = new TableImageSelector();
                selector.setShowIsCanOrderToTable(true);
                if (selector.start() != null) {
                    String imagePath = selector.getSelectedImagePath();
                    PhysicalTable table = new PhysicalTable();
                    table.setTableImagePath(imagePath);
                    table.setCanOrderTo(selector.isCanOrderToTable());
                    GraphicalTableSetupPanel.this.tableDisplay.setProtoTypeTable(table);
                    GraphicalTableSetupPanel.this.tableDisplay.setMode(GTLMode.Create);
                }
            } else if (source == GraphicalTableSetupPanel.this.editTableButton) {
                GraphicalTableSetupPanel.this.tableDisplay.setMode(GTLMode.Select);
            } else if (source == GraphicalTableSetupPanel.this.deleteTableButton) {
                GraphicalTableSetupPanel.this.tableDisplay.setMode(GTLMode.Delete);
            } else if (source == GraphicalTableSetupPanel.this.createSectionButton) {
                GraphicalTableSetupPanel.this.createTableGroupPressed.emit();
            } else if (source == GraphicalTableSetupPanel.this.editSectionButton) {
                GraphicalTableSetupPanel.this.editTableGroupPressed.emit();
            } else if (source == GraphicalTableSetupPanel.this.deleteSectionButton) {
                GraphicalTableSetupPanel.this.deleteTableGroupPressed.emit();
            }
            GraphicalTableSetupPanel.this.refresh();
        }
    }
}

