/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.tablesetup;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.ColourWheel;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.hardware.GTL;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import ordermate.gui.DisplayableObjectWrapper;
import ordermate.integration.onlinesales.OnlineOrderIntegrator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.admin.tablesetup.AbstractTableSetupPanel;
import waitermate.gui.screens.admin.tablesetup.ClassicTableSetupPanel;
import waitermate.gui.screens.admin.tablesetup.EditPhysicalTablePanel;
import waitermate.gui.screens.admin.tablesetup.EditTableGroupPanel;
import waitermate.gui.screens.admin.tablesetup.GraphicalTableSetupPanel;
import waitermate.gui.screens.admin.tablesetup.TableSetupNavBar;
import waitermate.gui.tablelayout.AbstractTableDisplayPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class TableSetup
extends AbstractScreen {
    public final Signal back = Signals.createSignal();
    private GTL gtl;
    private AbstractTableSetupPanel setupPanel;
    private TableSetupNavBar nav;
    private TableGroup lastTableGroup = null;
    private boolean anythingChanged = false;

    public void start(TableGroup toSelect) {
        this.start();
        if (toSelect != null) {
            this.setSelectedTableGroup(toSelect);
        }
    }

    public void start() {
        User loginUser;
        boolean lockSucceeded;
        this.gtl = Terminal.getLocalHost().getGtl();
        this.setupPanel = GTL.None == this.gtl ? new ClassicTableSetupPanel() : new GraphicalTableSetupPanel(this.gtl);
        this.setupPanel.createTableGroupPressed.connect((Object)this, "gotCreateTableGroupPressed");
        this.setupPanel.deleteTableGroupPressed.connect((Object)this, "gotDeleteTableGroupPressed");
        this.setupPanel.createTable.connect((Object)this, "gotCreateTable");
        this.setupPanel.deleteTable.connect((Object)this, "gotDeleteTable");
        this.setupPanel.editTable.connect((Object)this, "gotEditTable");
        this.setupPanel.editTableGroupPressed.connect((Object)this, "gotEditTableGroupPressed");
        this.setupPanel.tableGroupSelected.connect((Object)this, "gotTableGroupSelected");
        this.setupPanel.tableGroupUnlocked.connect((Object)this, "gotTableGroupUnlocked");
        this.setupPanel.tablesMoved.connect((Object)this, "gotTablesMoved");
        this.setupPanel.preMove.connect((Object)this, "gotPreMove");
        this.nav = new TableSetupNavBar(this.gtl);
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.switchMode.connect((Object)this, "gotSwitchMode");
        this.nav.gridMode.connect((Object)this, "gotGridMode");
        this.nav.switchPalette.connect((Object)this, "gotSwitchPalette");
        this.nav.loadPermanentPositionsPressed.connect((Object)this, "gotLoadPermanentPositionsPressed");
        this.nav.resetDailyPressed.connect((Object)this, "gotResetDailyPressed");
        this.nav.savePermanentPositionsPressed.connect((Object)this, "gotSavePermanentPositionsPressed");
        this.lastTableGroup = this.setupPanel.getCurrentTableGroup();
        if (this.lastTableGroup == null) {
            this.lastTableGroup = this.setupPanel.getTableGroups().get(0);
        }
        this.setupPanel.setInterfaceLocked(!(lockSucceeded = this.lastTableGroup.lock(loginUser = LoginManager.getInstance().getUser())));
        this.display();
    }

    private Point pickTablePosition() {
        PhysicalTable templateTable = new PhysicalTable();
        int tableWidth = templateTable.getTableImageWidth();
        int tableHeight = templateTable.getTableImageHeight();
        int backgroundWidth = this.lastTableGroup.getBackgroundImageWidth();
        int backgroundHeight = this.lastTableGroup.getBackgroundImageHeight();
        int margin = 10;
        int tableGap = 45;
        int tableSpacingX = tableWidth + tableGap;
        int tableSpacingY = tableHeight + tableGap;
        int numTables = this.lastTableGroup.getTables().size();
        int spotsPerRow = (backgroundWidth - 2 * margin) / tableSpacingX;
        int row = numTables / spotsPerRow;
        int col = numTables % spotsPerRow;
        return new Point((margin + col * tableSpacingX) % backgroundWidth, (margin + row * tableSpacingY) % backgroundHeight);
    }

    void gotCreateTable(PhysicalTable protoType) {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        if (protoType.getX() == -1 || protoType.getY() == -1) {
            Point newPos = this.pickTablePosition();
            protoType.setX(newPos.x);
            protoType.setY(newPos.y);
        }
        String name = null;
        name = protoType.isCanOrderTo() ? this.lastTableGroup.generateTableName() : "";
        protoType.setName(name);
        this.lastTableGroup.createTable(protoType);
        this.lastTableGroup.save();
        this.setupPanel.refresh();
        this.anythingChanged = true;
    }

    void gotPreMove() {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        this.setupPanel.repaint();
    }

    void gotDeleteTable(LogicalTable table) {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        this.lastTableGroup.removeTable(table);
        this.setupPanel.refresh();
        this.anythingChanged = true;
    }

    void gotTableGroupSelected() {
        TableGroup selectedTableGroup = this.setupPanel.getCurrentTableGroup();
        User loginUser = LoginManager.getInstance().getUser();
        if (this.lastTableGroup != null) {
            if (this.anythingChanged) {
                this.lastTableGroup.save();
            }
            if (this.lastTableGroup.isLocked(loginUser)) {
                this.lastTableGroup.unlock();
            }
        }
        selectedTableGroup.lock(loginUser);
        this.anythingChanged = false;
        this.lastTableGroup = selectedTableGroup;
        this.updateInterfaceLock();
    }

    private void updateInterfaceLock() {
        if (!this.lastTableGroup.isLocked()) {
            this.setupPanel.setInterfaceLocked(true, "Section must be locked to edit", "Lock");
        } else {
            boolean lockedByUs = this.lastTableGroup.isLocked(LoginManager.getInstance().getUser());
            this.setupPanel.setInterfaceLocked(!lockedByUs);
        }
    }

    void gotTableGroupUnlocked() {
        this.setupPanel.getCurrentTableGroup().relock(LoginManager.getInstance().getUser());
        this.setupPanel.refresh();
    }

    void gotTablesMoved() {
        this.anythingChanged = true;
    }

    void gotCreateTableGroupPressed() {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        TableGroup newSection = new TableGroup(TableGroup.generateTableGroupName());
        newSection.setSequence(TableGroup.getMaxSequence() + 1);
        newSection.save();
        this.setupPanel.addTableGroup(newSection);
        this.setupPanel.setCurrentTableGroup(newSection);
        this.anythingChanged = true;
    }

    void gotDeleteTableGroupPressed() {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        TableGroup currentTableGroup = this.setupPanel.getCurrentTableGroup();
        if (currentTableGroup != null) {
            int numTables = currentTableGroup.getTables().size();
            if (numTables == 0) {
                if (Dialogs.displayChoiceDialog((String)("Are you sure you wish to delete \"" + currentTableGroup + "\"?"), (String)"Confirm section delete", (String)"Yes", (String)"No", (boolean)true)) {
                    currentTableGroup.delete();
                    this.setupPanel.removeCurrentTableGroup();
                    this.setupPanel.refresh();
                    this.anythingChanged = true;
                }
            } else {
                Dialogs.displayOkDialog((String)"Cannot remove section containing tables.", (String)"Cannot remove section");
            }
        }
    }

    void gotEditTable(LogicalTable tableToEdit) {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        String oldName = tableToEdit.getPrimaryPhysicalTable().getName();
        boolean oldOrderable = tableToEdit.getPrimaryPhysicalTable().isCanOrderTo();
        EditPhysicalTablePanel editPanel = new EditPhysicalTablePanel(tableToEdit.getPrimaryPhysicalTable());
        boolean okPressed = Dialogs.displayDialog((JComponent)editPanel, (String)"Edit table", (String)"OK", (String)"Cancel", (boolean)true, (boolean)true, (boolean)true);
        if (okPressed) {
            String newName = StringUtils.cleanStringForSQL((String)editPanel.getName());
            if (!newName.equals(oldName) || editPanel.isCanOrderTo() != oldOrderable) {
                boolean nameValid = true;
                if (editPanel.isCanOrderTo()) {
                    tableToEdit.getPrimaryPhysicalTable().setCanOrderTo(false);
                    nameValid = this.setupPanel.getCurrentTableGroup().isValidNewTableName(newName);
                }
                if (nameValid) {
                    tableToEdit.getPrimaryPhysicalTable().setCanOrderTo(editPanel.isCanOrderTo());
                    tableToEdit.getPrimaryPhysicalTable().setName(newName);
                    this.setupPanel.refresh();
                } else {
                    Dialogs.displayOkDialog((String)("Name \"" + newName + "\" is already taken. Please choose another."), (String)"Can't edit table");
                }
            }
            tableToEdit.getPrimaryPhysicalTable().setTableImagePath(editPanel.getTableImagePath());
            this.anythingChanged = true;
        }
    }

    void gotEditTableGroupPressed() {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        TableGroup currentTableGroup = this.setupPanel.getCurrentTableGroup();
        String oldName = currentTableGroup.getName();
        String oldTableIm = currentTableGroup.getTableImageName();
        String oldBackgroundIm = currentTableGroup.getBackgroundImage();
        EditTableGroupPanel editPanel = new EditTableGroupPanel(currentTableGroup, this.gtl);
        boolean okPressed = Dialogs.displayDialog((JComponent)editPanel, (String)"Edit Table", (String)"OK", (String)"Cancel", (boolean)true, (boolean)true, (boolean)true);
        if (okPressed) {
            String newName = StringUtils.cleanStringForSQL((String)editPanel.getName());
            if (!newName.equals(oldName)) {
                if (TableGroup.isValidNewSectionName((String)newName, (TableGroup)currentTableGroup)) {
                    currentTableGroup.setName(newName);
                    this.anythingChanged = true;
                } else {
                    Dialogs.displayOkDialog((String)("Name \"" + newName + "\" is already taken. Please choose another."), (String)"Can't edit section");
                }
            }
            if (!GTL.None.equals((Object)this.gtl)) {
                String newTableIm = editPanel.getTableImageFile();
                String newBackgroundIm = editPanel.getBackgroundImageFile();
                if (!newTableIm.equals(oldTableIm)) {
                    currentTableGroup.setTableImageName(newTableIm);
                    this.anythingChanged = true;
                }
                if (!newBackgroundIm.equals(oldBackgroundIm)) {
                    currentTableGroup.setBackgroundImage(newBackgroundIm);
                    this.anythingChanged = true;
                }
            }
            this.setupPanel.refresh();
        }
    }

    void gotLoadPermanentPositionsPressed() {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        if (Dialogs.displayChoiceDialog((String)"Load permanent table positions?", (String)"Load table positions", (String)"Yes", (String)"No", (boolean)true)) {
            this.setupPanel.getCurrentTableGroup().getHelper().restorePermanentPositions();
            this.lastTableGroup.save();
            this.setupPanel.refresh();
            Dialogs.displayOkDialog((String)"Permanent table positions restored.", (String)"Table positions restored");
        }
    }

    void gotResetDailyPressed(Boolean resetDaily) {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        boolean dailyReset = resetDaily;
        SystemProperty.getInstance().setTablePositionsRevert(resetDaily.booleanValue());
        SystemProperty.getInstance().save();
        if (dailyReset) {
            Dialogs.displayOkDialog((String)"Table positions will automatically reset each day.", (String)"Daily reset enabled");
        } else {
            Dialogs.displayOkDialog((String)"Table positions will not automatically reset.", (String)"Daily reset disabled");
        }
    }

    void gotSavePermanentPositionsPressed() {
        this.lastTableGroup.reloadSyncState();
        this.updateInterfaceLock();
        if (!this.lastTableGroup.isLocked(LoginManager.getInstance().getUser())) {
            return;
        }
        if (Dialogs.displayChoiceDialog((String)"Save permanent table positions?", (String)"Save table positions", (String)"Yes", (String)"No", (boolean)true)) {
            this.setupPanel.getCurrentTableGroup().savePermanentPositions();
            Dialogs.displayOkDialog((String)"Permanent table positions saved.", (String)"Table positions saved");
            if (OnlineOrderIntegrator.getInstance().isThirdPartyOnlineOrderingEnabled()) {
                OrderMate.LOG.info("Going to try sync tables!");
                OnlineOrderIntegrator.getInstance().syncThirdPartyOnlineMenu((GuiHandler)new DummyGUIHandler(), false, true, false);
            }
        }
    }

    public JComponent getMainArea() {
        return this.setupPanel;
    }

    private void onEnd() {
        TableGroup group = this.setupPanel.getCurrentTableGroup();
        User loginUser = LoginManager.getInstance().getUser();
        if (group != null && group.isLocked(loginUser)) {
            if (this.anythingChanged) {
                SystemCurrentInfo.setTablesUpdate((String)("Table group edited " + group));
                group.save();
            }
            group.unlock();
        }
        this.nav = null;
    }

    void gotBack() {
        this.onEnd();
        this.back.emit();
    }

    void gotSwitchMode(GTL mode) {
        this.onEnd();
        Terminal localTerminal = Terminal.getLocalHost();
        localTerminal.setGtl(mode);
        localTerminal.save();
        LogicalTable.setBoundingBoxIncludesAllTables((boolean)mode.isArrangeOnJoin());
        AbstractTableDisplayPanel.terminalChanged.emit();
        this.start();
    }

    void gotSwitchPalette() {
        ArrayList<DisplayableObjectWrapper> wrappers = new ArrayList<DisplayableObjectWrapper>();
        for (ColourWheel.Palette palette : ColourWheel.Palette.values()) {
            DisplayableObjectWrapper paletteWrap = new DisplayableObjectWrapper((Object)palette, palette.name());
            String name = palette.name() + "_swatch";
            if (IconLoader.getCached((String)name) == null) {
                ColourWheel wheel = new ColourWheel(36, palette);
                ImageIcon imageIcon = wheel.makeSwatch();
                IconLoader.put((String)name, (ImageIcon)imageIcon);
            }
            paletteWrap.setIcon(name);
            wrappers.add(paletteWrap);
        }
        DisplayableObjectWrapper picked = (DisplayableObjectWrapper)Dialogs.displaySelectionDialog((String)"Choose a colour palette for links", wrappers);
        if (picked != null) {
            Terminal terminal = Terminal.getLocalHost();
            terminal.setPalette((ColourWheel.Palette)picked.getWrappedObject());
            terminal.save();
            AbstractTableDisplayPanel.terminalChanged.emit();
        }
    }

    void gotGridMode(Boolean enabled) {
        if (this.setupPanel instanceof GraphicalTableSetupPanel) {
            ((GraphicalTableSetupPanel)this.setupPanel).getTableDisplayPanel().setGridEnabled(enabled);
        }
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void setSelectedTableGroup(TableGroup tableGroup) {
        this.setupPanel.setCurrentTableGroup(tableGroup);
    }
}

