/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.tablesetup;

import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import ordermate.database.hardware.GTL;
import ordermate.database.misc.SystemProperty;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;

class TableSetupNavBar
extends NavBar {
    public final Signal switchMode = Signals.createSignal(GTL.class, (String)"Mode, GTL or Classic");
    public final Signal gridMode = Signals.createSignal(Boolean.class, (String)"Enabled");
    public final Signal switchPalette = Signals.createSignal();
    private JButton switchModeButton;
    private JToggleButton gridButton;
    private JButton switchPaletteButton;
    private JButton savePosButton;
    private JButton loadPosButton;
    private JToggleButton resetDailyCheck;
    final Signal<?, ?, ?, ?, ?> savePermanentPositionsPressed = Signals.createSignal();
    final Signal loadPermanentPositionsPressed = Signals.createSignal();
    final Signal<Boolean, ?, ?, ?, ?> resetDailyPressed = Signals.createSignal(Boolean.class, (String)"resetDaily");

    TableSetupNavBar(GTL currentMode) {
        this.setText("Table Setup");
        this.switchModeButton = currentMode == GTL.None ? this.constructButton(IconLoader.get((String)"/waitermate/images/icon_gtlmode.png"), "Graphical Mode", "switchGTLMode") : (currentMode == GTL.Standard ? this.constructButton(IconLoader.get((String)"/waitermate/images/icon_linkedmode.png"), "Linked Mode", "switchGTLMode") : this.constructButton(IconLoader.get((String)"/waitermate/images/icon_classicmode.png"), "Classic Mode", "switchGTLMode"));
        this.gridButton = this.constructToggleButton(IconLoader.get((String)"/waitermate/images/gtl_grid40.png"), "Grid");
        this.gridButton.addActionListener((ActionListener)((Object)this));
        this.savePosButton = this.constructButton(IconLoader.get((String)"/waitermate/images/gtl_save.png"), "Save Positions", "savePositions", this.savePermanentPositionsPressed);
        this.savePosButton.setToolTipText("Save table positions");
        this.loadPosButton = this.constructButton(IconLoader.get((String)"/waitermate/images/gtl_load.png"), "Load Positions", "loadPositions", this.loadPermanentPositionsPressed);
        this.loadPosButton.setToolTipText("Load table positions");
        this.resetDailyCheck = this.constructToggleButton(IconLoader.get((String)"/waitermate/images/gtl_load_nightly.png"), "Reset Daily");
        this.resetDailyCheck.setToolTipText("Reset table positions daily");
        this.resetDailyCheck.setName("resetDaily");
        this.resetDailyCheck.addActionListener((ActionListener)((Object)this));
        boolean resetDaily = SystemProperty.getInstance().isTablePositionsRevert();
        this.resetDailyCheck.setSelected(resetDaily);
        this.switchPaletteButton = this.constructButton(IconLoader.get((String)"/waitermate/images/pallete.png"), "Palette", "paletteButton");
        this.addLeft(this.getBackButton());
        this.setGraphical(currentMode);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.switchModeButton) {
            GTL newMode = this.switchModeButton.getIcon().equals(IconLoader.get((String)"/waitermate/images/icon_gtlmode.png")) ? GTL.Standard : (this.switchModeButton.getIcon().equals(IconLoader.get((String)"/waitermate/images/icon_linkedmode.png")) ? GTL.Linked : GTL.None);
            this.setGraphical(newMode);
            this.switchMode.emit((Object)newMode);
        } else if (source == this.gridButton) {
            this.gridMode.emit((Object)this.gridButton.isSelected());
        } else if (source == this.resetDailyCheck) {
            this.resetDailyPressed.emit((Object)this.resetDailyCheck.isSelected());
        } else if (source == this.switchPaletteButton) {
            this.switchPalette.emit();
        } else {
            super.actionPerformed(e);
        }
    }

    private void setGraphical(GTL mode) {
        this.removeRight(this.switchModeButton);
        if (!GTL.None.equals((Object)mode)) {
            this.addRight(this.savePosButton);
            this.addRight(this.loadPosButton);
            this.addRight(this.resetDailyCheck);
            this.addRight(this.gridButton);
            this.addRight(this.switchModeButton);
            if (GTL.Linked.equals((Object)mode)) {
                this.addLeft(this.switchPaletteButton);
            } else {
                this.removeLeft(this.switchPaletteButton);
            }
        } else {
            this.removeRight(this.savePosButton);
            this.removeRight(this.loadPosButton);
            this.removeRight(this.resetDailyCheck);
            this.removeRight(this.gridButton);
            this.removeLeft(this.switchPaletteButton);
            this.addRight(this.switchModeButton);
        }
    }
}

