/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.useradmin.cashdrawers;

import java.util.ArrayList;
import javax.swing.JComponent;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.useradmin.cashdrawers.CashDrawerSetupNav;
import waitermate.gui.screens.admin.useradmin.cashdrawers.CashDrawerSetupPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

public class CashDrawerSetup
extends AbstractScreen {
    private CashDrawerSetupPanel gui;
    private CashDrawerSetupNav nav;
    private CashDrawer selectedDrawer;
    public final Signal back = Signals.createSignal();

    public CashDrawerSetup() {
        this.gui = new CashDrawerSetupPanel();
        this.gui.cashDrawerSelected.connect((Object)this, "gotCashDrawer");
        this.gui.userSelected.connect((Object)this, "gotUser");
        this.nav = new CashDrawerSetupNav();
        this.nav.back.connect((Object)this, "back");
        this.nav.ok.connect((Object)this, "back");
        this.nav.clear.connect((Object)this, "gotClear");
    }

    public void start() {
        ArrayList<CashDrawer> availableDrawers = new ArrayList<CashDrawer>();
        for (CashDrawer drawer : Terminal.getLocalHost().getAvailableLogicallyConnectedCashDrawers()) {
            if (!drawer.isUserPayable()) continue;
            availableDrawers.add(drawer);
        }
        if (availableDrawers.size() > 0) {
            this.selectedDrawer = (CashDrawer)availableDrawers.get(0);
            this.gui.setupDrawers(availableDrawers);
            this.gotCashDrawer(this.selectedDrawer);
        }
        this.show();
    }

    void back() {
        this.back.emit();
    }

    private void show() {
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotClear() {
        CashDrawer.setCashDrawerUser((CashDrawer)this.selectedDrawer, (Terminal)Terminal.getLocalHost(), null);
        this.gotCashDrawer(this.selectedDrawer);
    }

    public void gotCashDrawer(CashDrawer drawer) {
        if (drawer == null) {
            return;
        }
        this.selectedDrawer = drawer;
        this.gui.setupUser(User.getUsersWithPayoffPrivileges());
        this.gui.setSelectedUser(CashDrawer.getCashDrawerUser((CashDrawer)this.selectedDrawer, (Terminal)Terminal.getLocalHost()));
    }

    public void gotUser(User theUser) {
        if (theUser == null || this.selectedDrawer == null) {
            return;
        }
        CashDrawer.setCashDrawerUser((CashDrawer)this.selectedDrawer, (Terminal)Terminal.getLocalHost(), (User)theUser);
    }
}

