/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.useradmin.cashdrawers;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPanel;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class CashDrawerSetupPanel
extends JPanel {
    private JPanel gui;
    private DataScrollPaneModel cashDrawers;
    private CustomScrollPane cashDrawersPane;
    private DataScrollPaneModel users;
    private CustomScrollPane usersPane;
    public final Signal cashDrawerSelected = Signals.createSignal(CashDrawer.class, (String)"user");
    public final Signal userSelected = Signals.createSignal(User.class, (String)"user");

    public CashDrawerSetupPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(1, 1)));
        this.gui = this.createInterface();
        this.add((Component)this.gui, new Rectangle(0, 0, 1, 1));
    }

    public JPanel createInterface() {
        JPanel panel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(4, 3)));
        this.cashDrawers = new DataScrollPaneModel(1, 8);
        this.cashDrawersPane = new CustomScrollPane((CustomScrollPaneModel)this.cashDrawers);
        this.cashDrawers.objectSelected.connect((Object)this, "gotCashDrawerSelected");
        this.users = new DataScrollPaneModel(3, 8);
        this.usersPane = new CustomScrollPane((CustomScrollPaneModel)this.users);
        this.users.objectSelected.connect((Object)this, "gotUserSelected");
        panel.add((Component)this.cashDrawersPane, new Rectangle(0, 0, 1, 3));
        panel.add((Component)this.usersPane, new Rectangle(1, 0, 3, 3));
        return panel;
    }

    public void gotCashDrawerSelected(Displayable drawer) {
        this.cashDrawerSelected.emit((Object)drawer);
    }

    public void gotUserSelected(Displayable user) {
        this.userSelected.emit((Object)user);
    }

    public void setupDrawers(List drawers) {
        this.cashDrawers.setItems(drawers, true, true);
    }

    public void setSelectedUser(User cashDrawerUser) {
        this.users.selectButton((Displayable)cashDrawerUser);
    }

    public void setupUser(List user) {
        this.users.setItems(user, true, true, false);
    }
}

