/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.useradmin.login;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ordermate.database.EventContext;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.User;
import ordermate.database.users.UserFingerprint;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.fingerprint.EnrolFingerprint;
import waitermate.gui.screens.admin.clockonclockoff.ClockOnClockOffScreen;
import waitermate.gui.screens.admin.useradmin.login.UserLoginSetupNav;
import waitermate.gui.screens.admin.useradmin.login.UserLoginSetupPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class UserLoginSetup
extends AbstractScreen {
    private UserLoginSetupPanel gui;
    private UserLoginSetupNav nav;
    private EnrolFingerprint enrolFingerprint;
    private boolean scan;
    private List<User> users;
    private User currentUser;
    private boolean swipecardChanged;
    private boolean proximityBandChanged;
    private String swipeCardID;
    private String proximityBandID;
    public final Signal back = Signals.createSignal();
    private final Signal gotEnrolFinished = Signals.createSignal();
    private final Signal gotClockOnDone = Signals.createSignal();

    public UserLoginSetup(UserLoginSetupPanel userSetupPanel) {
        this.gui = userSetupPanel;
        this.gui.userSelected.connect((Object)this, "gotUser");
        this.gui.changePIN.connect((Object)this, "gotChangePIN");
        this.gui.enrolFingerprint.connect((Object)this, "gotEnrolFingerprint");
        this.gotEnrolFinished.connect((Object)this, "gotEnrolFinished");
        this.nav = new UserLoginSetupNav();
        this.nav.back.connect((Object)this, "back");
        this.nav.cancel.connect((Object)this, "back");
        this.nav.save.connect((Object)this, "gotSave");
        this.nav.clockOffOrOn.connect((Object)this, "gotClockOnOrOff");
        this.gotClockOnDone.connect((Object)this, "gotClockOnDone");
        this.stopScan();
        WaiterMateInputAdapter.getInstance().proximityReaderInput.connect((Object)this, "gotProximityReaderString");
        WaiterMateInputAdapter.getInstance().swipecardInput.connect((Object)this, "gotSwipecardString");
    }

    public void start() {
        this.nav.setSaveEnabled(false);
        this.initializeUser();
        this.gui.setUsers(this.users);
        if (this.users.size() > 0) {
            this.setCurrentUser(this.users.get(0));
        }
        this.show();
    }

    public void startCheckPin() {
        User user = LoginManager.getInstance().getUser();
        if (user.isHeadOffice()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"HEAD_OFFICE_USERS_CANNOT_EDIT_THEIR_PINS_LOCALLY"), (String)Internationalization.getLiteralFor((String)"CANNOT_ALTER_PIN"));
            return;
        }
        String enteredPin = Dialogs.getPIN((boolean)true);
        if ("\u0000".equals(enteredPin)) {
            return;
        }
        if (user.getPin() == null || user.getPin().trim().equals("") || enteredPin.equals(LoginManager.getInstance().getUser().getPin())) {
            this.start();
            this.setCurrentUser(LoginManager.getInstance().getUser());
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"YOUR_PIN_NUMBER_IS_INVALID"), (String)Internationalization.getLiteralFor((String)"INVALID_PIN"));
            WaiterMate.LOG.warn("Invalid pin login attempt: " + enteredPin);
        }
    }

    private void back() {
        this.stopScan();
        this.back.emit();
    }

    private void show() {
        this.startScan();
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotProximityReaderString(String data) {
        if (this.scan) {
            this.setProximityBand(data);
        }
    }

    public void gotSwipecardString(String data) {
        if (this.scan) {
            this.setSwipeCard(data);
        }
    }

    public void gotUser(User user) {
        this.setCurrentUser(user);
    }

    private void setProximityBand(String data) {
        this.nav.setSaveEnabled(true);
        this.proximityBandID = data;
        this.proximityBandChanged = true;
        this.gui.setProximityBand(this.proximityBandID);
    }

    private void setSwipeCard(String data) {
        this.nav.setSaveEnabled(true);
        this.swipeCardID = data;
        this.swipecardChanged = true;
        this.gui.setSwipeCard(StringUtils.formatSwipeCardForDisplay((String)this.swipeCardID));
    }

    public void stopScan() {
        this.scan = false;
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
    }

    public void startScan() {
        this.scan = true;
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
    }

    public void gotSave() {
        if (this.currentUser != null) {
            boolean save;
            User existingUser;
            if (this.swipecardChanged) {
                existingUser = User.getUserBySwipecard((String)this.swipeCardID);
                if (existingUser != null) {
                    save = Dialogs.displayChoiceDialog((String)(Internationalization.getLiteralFor((String)"THIS_SWIPECARD_IS_SET_FOR") + " " + Internationalization.getLiteralFor((String)"USER") + " " + existingUser.getName() + Internationalization.getLiteralFor((String)"DOT_SWAP") + " " + Internationalization.getLiteralFor((String)"TO") + " " + this.currentUser.getName() + Internationalization.getLiteralFor((String)"QUESTIONMARK")), (String)Internationalization.getLiteralFor((String)"SWAP_CARD_QUESTIONMARK"), (boolean)true);
                    if (save) {
                        existingUser.setSwipecard("");
                        existingUser.save();
                        this.currentUser.setSwipecard(this.swipeCardID);
                    }
                } else {
                    this.currentUser.setSwipecard(this.swipeCardID);
                }
            }
            if (this.proximityBandChanged) {
                existingUser = User.getUserByProximityBand((String)this.proximityBandID);
                if (existingUser != null) {
                    save = Dialogs.displayChoiceDialog((String)(Internationalization.getLiteralFor((String)"THIS_PROXIMITY_BAND_IS_SET_FOR") + " " + Internationalization.getLiteralFor((String)"USER") + " " + existingUser.getName() + Internationalization.getLiteralFor((String)"DOT_SWAP") + " " + Internationalization.getLiteralFor((String)"TO") + " " + this.currentUser.getName() + Internationalization.getLiteralFor((String)"QUESTIONMARK")), (String)Internationalization.getLiteralFor((String)"SWAP_BAND_QUESTIONMARK"), (boolean)true);
                    if (save) {
                        existingUser.setProximityBand(null);
                        existingUser.save();
                        this.currentUser.setProximityBand(this.proximityBandID);
                    }
                } else {
                    this.currentUser.setProximityBand(this.proximityBandID);
                }
            }
            if (this.currentUser.hasChanged()) {
                this.currentUser.save();
                SystemCurrentInfo.setUpdate((String)"User login changed");
            }
        }
        this.back();
    }

    public void initializeUser() {
        List allUsers = User.getUsers();
        this.users = new ArrayList<User>();
        for (User user : allUsers) {
            if (user.isHeadOffice()) continue;
            this.users.add(user);
        }
        User loggedInUser = LoginManager.getInstance().getUser();
        if (!loggedInUser.isHeadOffice()) {
            this.setCurrentUser(loggedInUser);
        } else {
            this.setCurrentUser(null);
        }
    }

    public void setCurrentUser(User newUser) {
        this.currentUser = newUser;
        if (this.currentUser != null) {
            this.nav.setSaveEnabled(false);
            this.swipeCardID = this.currentUser.getSwipecard();
            this.proximityBandID = this.currentUser.getProximityBand();
            this.swipecardChanged = false;
            this.proximityBandChanged = false;
            if (this.swipeCardID == null || this.swipeCardID.equalsIgnoreCase("null")) {
                this.swipeCardID = "";
            }
            if (this.proximityBandID == null || this.proximityBandID.equalsIgnoreCase("null")) {
                this.proximityBandID = "";
            }
            this.gui.setSwipeCard(StringUtils.formatSwipeCardForDisplay((String)this.swipeCardID));
            this.gui.setProximityBand(this.proximityBandID);
            this.gui.setPinNumber(this.currentUser.getPin());
            this.gui.setPrints(UserFingerprint.getFingerprintsForUser((User)this.currentUser));
        }
    }

    public void gotChangePIN() {
        String result;
        if (this.currentUser != null && (result = Dialogs.getPIN((boolean)false)) != "\u0000") {
            this.nav.setSaveEnabled(true);
            String thePIN = result;
            if (this.checkDoublePin(this.currentUser, thePIN)) {
                this.currentUser.setPin(thePIN);
                this.gui.setPinNumber(thePIN);
            }
        }
    }

    private boolean checkDoublePin(User user, String pinToCheck) {
        HashSet<User> usersToCheck = new HashSet<User>();
        usersToCheck.addAll(this.users);
        usersToCheck.remove(user);
        for (User aUser : usersToCheck) {
            if (!pinToCheck.equals(aUser.getPin())) continue;
            JLabel iconLabel = new JLabel(Internationalization.getLiteralFor((String)"WARNING_PIN_NOT_SET"));
            iconLabel.setIcon(IconLoader.get((String)"/waitermate/images/warning.png"));
            Dialogs.displayDialog((JComponent)iconLabel, (String)Internationalization.getLiteralFor((String)"THIS_PIN_HAS_BEEN_ALREADY_ASSIGNED_TO_ANOTHER_USER"), (boolean)false);
            TerminalEventLog.logPinDuplicateRejected((EventContext)LoginManager.getEventContext(), (String)pinToCheck);
            return false;
        }
        return true;
    }

    void gotEnrolFingerprint() {
        if (this.currentUser != null) {
            this.enrolFingerprint = new EnrolFingerprint(new WaitermateGuiHandler());
            this.enrolFingerprint.enrolFingerprint(this.currentUser, this.gotEnrolFinished);
        }
    }

    void gotEnrolFinished() {
        this.gotUser(this.currentUser);
    }

    void gotClockOnOrOff() {
        ClockOnClockOffScreen.getInstance().start(LoginManager.getInstance().getUser(), this.currentUser, this.gotClockOnDone, false, null, false);
    }

    void gotClockOnDone() {
        this.start();
    }
}

