/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.vouchers;

import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.queries.finance.voucher.VoucherQueries;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.integration.voucher.VoucherAdministratorRMI;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.voucher.VoucherRenderer;
import waitermate.gui.screens.admin.vouchers.VoucherSearchPanel;
import waitermate.gui.screens.search.WaitermateSearchPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;
import waitermate.guikit.vouchers.ShowVoucherUtils;

public class WaitermateVoucherSearch
extends AbstractScreen {
    public final Signal<GiftVoucherTransaction, ?, ?, ?, ?> selected = Signals.createSignal(GiftVoucherTransaction.class, (String)"selected");
    public Signal back;
    private WaitermateSearchPanel gui;
    private NavBar nav;
    private VoucherTransactionSearcher voucherSearcher;
    private VoucherRenderer renderer = new VoucherRenderer();
    private VoucherSearchPanel voucherSearchPanel = new VoucherSearchPanel();

    public WaitermateVoucherSearch() {
        this.initSearchPanel();
        this.initNavBar();
    }

    private void initSearchPanel() {
        this.gui = new WaitermateSearchPanel(this.voucherSearchPanel, this.voucherSearchPanel, "_1_SEARCH_FOR_VOUCHER", "_2_SELECT_VOUCHER", new RendererScrollPaneModel((Renderer)this.renderer, 1, 5), "NO_VOUCHERS_FOUND", GiftVoucherTransaction.class);
        this.voucherSearcher = this.voucherSearchPanel.getSearcher();
        this.voucherSearcher.setLimit(50);
        this.voucherSearcher.setHideZeroDollarFilter(Boolean.TRUE);
        this.gui.setRenderer(this.renderer);
        this.gui.connectSignals(this.renderer.selected, Signals.createSignal());
        this.gui.selected.connect((Object)this, "gotSelected");
        this.voucherSearchPanel.propertyChanged.connect((Object)this, "refresh");
        this.voucherSearchPanel.clearSearch.connect((Object)this, "reset");
    }

    private void initNavBar() {
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.back = this.nav.back;
    }

    public void reset() {
        this.voucherSearcher.clearSearchFilterValues();
        this.voucherSearcher.setHideZeroDollarFilter(Boolean.TRUE);
        this.gui.reset();
        List vouchers = VoucherQueries.getLastActive((int)0, (PropertiedObject.Property)GiftVoucherTransaction.Properties.GIFT_VOUCHER, (boolean)true);
        this.gui.setObjects(vouchers);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotSelected(GiftVoucherTransaction voucherTxn) {
        RefreshVoucherTask refreshTask = new RefreshVoucherTask(voucherTxn.getGiftVoucher());
        ProgressDialog.doProgressDialog((Task)refreshTask);
        GiftVoucher toDisplay = refreshTask.getVoucher();
        if (toDisplay == null) {
            Dialogs.displayOkDialog((String)"The transactions shown for this voucher may be out of sync by up to 24 hours.", (String)"Couldn't refresh voucher!");
            toDisplay = voucherTxn.getGiftVoucher();
        }
        new ShowVoucherUtils(toDisplay).showTransactionsReport();
    }

    public void refresh() {
        List vouchers = this.voucherSearcher.search();
        this.gui.setObjects(vouchers);
    }

    private class RefreshVoucherTask
    extends AbstractGuiTask {
        private GiftVoucher voucher;

        RefreshVoucherTask(GiftVoucher toRefresh) {
            this.voucher = toRefresh;
        }

        protected void doGuiTask() throws Exception {
            this.voucher = VoucherAdministratorRMI.getInstance().resyncVoucher(this.voucher.getUniqueId());
        }

        public String getName() {
            return "Resyncing voucher...";
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        GiftVoucher getVoucher() {
            return this.voucher;
        }
    }
}

