/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.wastage;

import java.util.List;
import javax.swing.JComponent;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.sales.WastageAccount;
import ordermate.database.stock.usage.StockWastage;
import ordermate.database.stock.usage.StockWastageHelper;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.admin.wastage.WastageNavBar;
import waitermate.gui.screens.admin.wastage.WastageTabbedPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class WastageScreen
extends AbstractScreen {
    private TakeawayAccount psuedoAccount = null;
    private List<StockWastage> wastages = null;
    private WastageTabbedPanel gui;
    private WastageNavBar navPanel;
    public final Signal back = Signals.createSignal();
    public final Signal logout = Signals.createSignal();

    public WastageScreen() {
        this.gui = new WastageTabbedPanel();
        this.navPanel = new WastageNavBar();
        this.gui.rootDisplay.connect((Object)this, "resumeMenuWastage");
        this.navPanel.waste.connect((Object)this, "gotWaste");
        this.navPanel.back.connect((Object)this, "gotBack");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.navPanel;
    }

    public void display() {
        super.display();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TakeawayAccount newAccount() {
        WastageScreen wastageScreen = this;
        synchronized (wastageScreen) {
            this.psuedoAccount = new WastageAccount(LoginManager.getInstance().getUser(), Terminal.getLocalHost(), SystemProperty.getInstance().getDefaultQuickSaleAccType());
        }
        return this.psuedoAccount;
    }

    public void startWastage() {
        this.newObjects();
        this.gui.setSelectedIndex(0);
        this.gui.startTabs();
        this.display();
    }

    private void newObjects() {
        this.psuedoAccount = this.newAccount();
        this.wastages = this.gui.getWastageList();
        this.gui.setAccount((Account)this.psuedoAccount);
    }

    public void resumeMenuWastage() {
        this.gui.setSelectedIndex(0);
        this.display();
    }

    void gotWaste() {
        if (this.gui.getSelectedIndex() == 0 && this.psuedoAccount.hasItems()) {
            this.doWasteAccount((Account)this.psuedoAccount, LoginManager.getEventContext());
            this.newObjects();
            this.startWastage();
        } else if (this.gui.getSelectedIndex() == 1 && !this.wastages.isEmpty()) {
            this.wastages = this.gui.getWastageList();
            this.doWaste(this.wastages, LoginManager.getEventContext());
            this.wastages.clear();
            this.gui.clearWastageList();
            this.newObjects();
            this.gui.invalidatGUI();
            this.display();
        } else {
            Dialogs.displayOkDialog((String)"Must select at least one item to waste", (String)"No Items Selected!");
        }
    }

    void gotBack() {
        if (this.gui.getSelectedIndex() == 0 && !this.psuedoAccount.hasItems() || this.gui.getSelectedIndex() == 1 && this.wastages.isEmpty() || Dialogs.displayForcedChoiceDialog((String)"Confirm", (String)"Leaving the screen will not waste any items in the list", (String)"Ok", (String)"Cancel")) {
            this.wastages.clear();
            this.gui.clearWastageList();
            this.gui.resetAccounts();
            this.back.emit();
        }
    }

    private void doWasteAccount(Account toSave, EventContext eContext) {
        String reason = Dialogs.getString((String)"Note", (String)"", (boolean)false, (String)"Type note:");
        StockWastageHelper.wasteAccountComponenetsAndPrint((Account)toSave, (EventContext)eContext, (String)reason);
    }

    private void doWaste(List<StockWastage> wastages, EventContext eContext) {
        this.gui.setStockItemWastageScreenImage();
        String reason = Dialogs.getString((String)"Note", (String)"", (boolean)false, (String)"Type note:");
        StockWastageHelper.wasteStockWastagesAndPrint(wastages, (EventContext)eContext, (String)reason);
    }
}

