/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.wastage;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.database.stock.StockUtilities;
import ordermate.database.users.User;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.wastage.WasteMenuItemsPanel;
import waitermate.gui.screens.ordering.additems.AddItems;
import waitermate.gui.screens.ordering.additems.OrderedItemDetails;
import waitermate.gui.screens.ordering.additems.UpgradeCombo;
import waitermate.gui.screens.ordering.modifyitem.ModifyItem;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.guikit.NavBar;

public class WasteMenuItemsScreen
extends AbstractAdminScreen {
    private WasteMenuItemsPanel gui;
    private AddItems addItemState;
    public final Signal<?, ?, ?, ?, ?> rootDisplay = Signals.createSignal();
    private final Signal<?, ?, ?, ?, ?> modifyDone = Signals.createSignal();
    private final Signal<?, ?, ?, ?, ?> finishedUpgrade = Signals.createSignal();

    public WasteMenuItemsScreen() {
        this.gui = new WasteMenuItemsPanel();
        this.gui.groupSelected.connect((Object)this, "gotGroupSelected");
        this.gui.newItem.connect((Object)this, "gotNewItem");
        this.gui.newCombo.connect((Object)this, "gotNewCombo");
        this.gui.item.connect((Object)this, "gotItem");
        this.gui.quantity.connect((Object)this, "gotQuantity");
        this.gui.delete.connect((Object)this, "gotDelete");
        this.gui.upgrade.connect((Object)this, "gotUpgrade");
        this.addItemState = new AddItems(true);
        this.addItemState.getAddItemConfig().setAllowAutoCombo(false);
        this.addItemState.done.connect((Object)this, "gotAddItemDone");
        this.modifyDone.connect((Object)this, "gotModifyDone");
        this.finishedUpgrade.connect((Object)this, "gotModifyDone");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public NavBar getNavBar() {
        return null;
    }

    @Override
    public String getCategoryName() {
        return "Waste Menu Items";
    }

    @Override
    public Icon getCategoryIcon() {
        return null;
    }

    public void setAccount(Account acc) {
        this.gui.setAccount(acc);
    }

    private Account getCurrentAccount() {
        return this.gui.getAccount();
    }

    public void clearAccount() {
        this.gui.setAccount(null);
    }

    private void gotGroupSelected(InventoryGroup group) {
        this.addItemState.startAddingItem(this.getCurrentAccount(), group, new OrderedItemDetails());
    }

    void gotNewItem(InventoryItem newItem) {
        this.addItemState.startAddingItem(this.getCurrentAccount(), newItem, new OrderedItemDetails(), this.gui.getKeyPadQuantity(), this.gui.getIncrementQuantityFlag());
        this.itemsUpdated();
    }

    void gotNewCombo(InventoryCombo newItem) {
        this.addItemState.startAddingCombo(this.getCurrentAccount(), newItem, new OrderedItemDetails(), this.gui.getKeyPadQuantity(), this.gui.getIncrementQuantityFlag());
        this.itemsUpdated();
    }

    void gotItem(Sellable theItem) {
        if (theItem instanceof SalesLineItemWrapper) {
            ModifyItem modItem = ModifyItem.getInstance();
            modItem.startModify((SalesLineItem)theItem.getSellingObject(), this.getCurrentAccount(), this.modifyDone);
            modItem.setWastageMode(true);
        }
        this.itemsUpdated();
    }

    void gotQuantity(Sellable theItem) {
        if (theItem.isQuantifiable() && theItem instanceof SalesLineItemWrapper) {
            SalesLineItem salesItem = (SalesLineItem)theItem.getSellingObject();
            SalesQuantity newQuantity = salesItem.getQuantity().add(SalesQuantity.ONE);
            boolean allowQuantityEdit = StockUtilities.allowQuantityEdit((Account)this.getCurrentAccount(), new ArrayList(), (SalesLineItem)salesItem, (SalesQuantity)newQuantity, (User)LoginManager.getInstance().getUser());
            if (allowQuantityEdit) {
                salesItem.setQuantity(theItem.getQuantity().add(SalesQuantity.ONE), LoginManager.getEventContext());
                this.itemsUpdated();
            }
        }
    }

    void gotDelete(Sellable theItem) {
        if (theItem != null && theItem instanceof SalesLineItemWrapper) {
            this.getCurrentAccount().getItemHelper().removeItem((SalesLineItem)theItem.getSellingObject(), LoginManager.getEventContext());
        } else if (theItem instanceof VoucherTransactionWrapper) {
            this.getCurrentAccount().removeVoucherTransaction((GiftVoucherTransaction)theItem.getSellingObject());
        }
        if (this.getCurrentAccount().isPersistent() && this.getCurrentAccount().getItems().isEmpty() && this.getCurrentAccount().isClosePossible()) {
            WaitermateSaveAccount.getInstance().closeAccount(this.getCurrentAccount(), true, false, LoginManager.getEventContext());
        }
        this.itemsUpdated();
    }

    void gotUpgrade(Sellable theItem) {
        if (theItem != null && theItem instanceof SalesLineItemWrapper) {
            UpgradeCombo.getInstance().configureSignal(this.finishedUpgrade);
            UpgradeCombo.getInstance().upgradeRequested((SalesItem)theItem.getSellingObject(), (ItemGroup)this.getCurrentAccount(), LoginManager.getEventContext());
        }
        this.itemsUpdated();
    }

    void gotAddItemDone() {
        this.display();
        this.rootDisplay.emit();
        this.gui.showLastPage();
        this.itemsUpdated();
    }

    private void gotModifyDone() {
        ModifyItem modItem = ModifyItem.getInstance();
        modItem.setWastageMode(false);
        this.rootDisplay.emit();
        this.itemsUpdated();
    }

    private void itemsUpdated() {
        this.gui.showAccount(this.getCurrentAccount());
    }
}

