/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer;

import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.gui.SaveAccount;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.closedaccounts.closedaccountslist.ClosedAccountRenderer;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.showitem.ShowItemsUtils;

public class SalesHistoryPanel
extends JPanel {
    private static final SalesHistoryPanel salesHistory = new SalesHistoryPanel();
    private final AccountSearcher searcher;
    private final ClosedAccountRenderer renderer;
    private final RendererScrollPaneModel model;
    private final CustomScrollPane view;

    public static void displayDialog(Customer cust) {
        SalesHistoryPanel.displayDialog(salesHistory, cust);
    }

    public static void displayDialog(SalesHistoryPanel panelToDisplay, Customer cust) {
        panelToDisplay.setCustomer(cust);
        panelToDisplay.refresh();
        if (panelToDisplay.hasSales()) {
            Dialogs.displayDialog((JComponent)panelToDisplay, (String)(Internationalization.getLiteralFor((String)"SALES_HISTORY_FOR") + " " + cust.getName()), (boolean)false);
        } else {
            Dialogs.displayOkDialog((String)(cust.getName() + " " + Internationalization.getLiteralFor((String)"DOES_NOT_HAVE_ANY_PAST_SALES")), (String)Internationalization.getLiteralFor((String)"NO_PAST_SALES"));
        }
    }

    public SalesHistoryPanel() {
        this.searcher = new AccountSearcher(50, Account.Properties.ID, false);
        this.renderer = new ClosedAccountRenderer();
        this.model = new RendererScrollPaneModel((Renderer)this.renderer, new int[]{100}, 6);
        this.view = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.setLayout(new FlowLayout());
        this.view.setPreferredSize(new Dimension(360, 400));
        this.add((Component)this.view);
        this.renderer.selected.connect((Object)this, "gotAccountSelected");
    }

    public void setCustomer(Customer theCust) {
        this.searcher.setCustomerSearch(theCust);
    }

    public void refresh() {
        this.model.setObjects(PersistenceManager.getObjectList(Account.class, (String)this.searcher.getObjectQuery().toString(), (Object[])new Object[0]));
        this.model.clearSelection();
        this.view.displayLastPage();
    }

    public boolean hasSales() {
        return this.model.getSize() > 0;
    }

    void gotAccountSelected(Account account) {
        new ShowItemsUtils((SaveAccount)WaitermateSaveAccount.getInstance()).showItems((ItemGroup)account);
    }
}

