/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.PropertyValue;
import au.com.ordermate.util.connectivity.GoogleMapHelper;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerSearch;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMate;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.screens.customer.SalesHistoryPanel;
import waitermate.gui.screens.customer.add.AddCustomerNav;
import waitermate.gui.screens.customer.add.AddCustomerPanel;
import waitermate.gui.screens.customer.add.addcard.AddCard;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class AddCustomer
extends AbstractScreen {
    private AddCustomerPanel gui;
    private AddCustomerNav nav;
    private Customer currentCustomer;
    private SalesHistoryPanel salesHistoryPanel = new SalesHistoryPanel();
    public final Signal<Customer, ?, ?, ?, ?> customerSaved = Signals.createSignal(Customer.class, (String)"newCustomer");
    public final Signal<?, ?, ?, ?, ?> back = Signals.createSignal();
    private AddCard addCard;
    private boolean returnHalfFormed = false;

    public AddCustomer() {
        this.setup(Customer.REQUIRE_BASIC);
    }

    public AddCustomer(List<PropertiedObject.Property> requirements) {
        this.setup(requirements);
    }

    public void add() {
        this.add(null, Customer.REQUIRE_BASIC);
    }

    public void add(List<PropertiedObject.Property> theRequirements) {
        this.add(null, theRequirements);
    }

    public void add(List<PropertyValue> properties, List<PropertiedObject.Property> requirements) {
        StreetDirectoryReference ref;
        this.gui.setMandatoryFields(requirements);
        Customer temp = new Customer();
        temp.setCategory(CustomerCategory.getDefaultCategory());
        if (properties != null && !properties.isEmpty()) {
            for (PropertyValue nextValue : properties) {
                try {
                    temp.setPropertyValue(nextValue.property, nextValue.value);
                }
                catch (Exception e) {
                    WaiterMate.LOG.warn("Could not set customer field", (Throwable)e);
                }
            }
        }
        temp.setReceiveMarketing(true);
        if (temp.getState() != null && temp.getState().isEmpty()) {
            temp.setState(BusinessInfo.getInstance().getDefaultState());
        }
        String street = temp.getStreetName();
        String suburb = temp.getSuburb();
        if (street != null && !street.trim().isEmpty() && temp.getSuburb() != null && !suburb.trim().isEmpty() && (ref = StreetDirectoryReference.findStreetDir((String)street, (String)CustomerSearch.convertStreetTypeToAbbreviation((String)temp.getStreetType()), (String)suburb)) != null) {
            temp.setPostcode(ref.getPostcode());
        }
        this.gui.setCustomer(temp);
        this.show();
    }

    public void connectNavSetupToNewInput() {
        try {
            this.gui.newInput.connect((Object)this, "setupNavButtons");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disconnectNavSetupFromNewInput() {
        this.gui.newInput.disconnect((Object)this);
    }

    public void edit(Customer theCustomer) {
        this.edit(theCustomer, Customer.REQUIRE_BASIC);
    }

    public void edit(Customer theCustomer, List<PropertiedObject.Property> theRequirements) {
        this.gui.reset();
        this.gui.setMandatoryFields(theRequirements);
        this.setCustomer(theCustomer);
        this.show();
    }

    public void setReturnHalfFormed(boolean shouldReturnHalfFormed) {
        this.returnHalfFormed = shouldReturnHalfFormed;
    }

    private void setup(List<PropertiedObject.Property> requirements) {
        this.gui = new AddCustomerPanel(requirements);
        this.gui.gotFinishedPanel.connect((Object)this, "gotFinishedAddCustomer");
        this.nav = new AddCustomerNav();
        this.nav.cancel.connect((Object)this, "gotCancel");
        this.nav.ok.connect((Object)this, "gotOK");
        this.nav.back.connect((Object)this, "gotBack");
        this.nav.addCard.connect((Object)this, "gotAddCard");
        this.nav.location.connect((Object)this, "gotShowLocation");
        this.addCard = new AddCard();
        this.addCard.back.connect((Object)this, "gotFinishedAddCard");
        this.nav.deleteCustomer.connect((Object)this, "gotDeleteCustomer");
        this.nav.salesHistorySignal.connect((Object)this, "gotShowSalesHistory");
    }

    public void setRequirements(List<PropertiedObject.Property> requirements) {
        this.gui.setMandatoryFields(requirements);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void show() {
        this.display();
        this.setupNavButtons();
        this.gui.focusFirstComponent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddCustomer.this.connectNavSetupToNewInput();
            }
        });
    }

    void gotFinishedAddCard() {
        this.show();
    }

    public void gotOK() {
        Customer customer = this.saveCustomer();
        this.currentCustomer = null;
        this.customerSaved.emit((Object)customer);
        this.disconnectNavSetupFromNewInput();
    }

    public void gotBack() {
        if (this.returnHalfFormed) {
            this.gotOK();
        } else {
            this.gotCancel();
        }
    }

    public void gotCancel() {
        this.currentCustomer = null;
        this.back.emit();
        this.disconnectNavSetupFromNewInput();
    }

    private Customer saveCustomer() {
        this.currentCustomer = this.currentCustomer == null ? this.gui.saveCustomer(new Customer()) : this.gui.saveCustomer(this.currentCustomer);
        return this.currentCustomer;
    }

    private void setupNavButtons() {
        boolean ok = this.okForRequirements();
        this.nav.getOkComponent().setEnabled(ok);
        if (this.returnHalfFormed) {
            this.nav.getBackButton().setEnabled(!ok);
        } else {
            this.nav.getBackButton().setEnabled(true);
        }
        this.nav.setHasCustomer(this.currentCustomer != null);
    }

    private boolean okForRequirements() {
        return this.gui.okForRequirements();
    }

    public void setCustomer(Customer cust) {
        this.currentCustomer = cust;
        this.gui.setCustomer(cust);
        this.nav.setHasCustomer(cust != null);
    }

    public void gotAddCard() {
        if (this.okForRequirements()) {
            this.addCard.start(this.saveCustomer());
        } else {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"PLEASE_ENTER_CUSTOMER_DATA_1") + " " + Internationalization.getLiteralFor((String)"PLEASE_ENTER_CUSTOMER_DATA_2") + " " + Internationalization.getLiteralFor((String)"PLEASE_ENTER_CUSTOMER_DATA_3")), (String)Internationalization.getLiteralFor((String)"REQUIRED_FIELDS_NOT_ENTERED"));
        }
    }

    void gotShowSalesHistory() {
        if (this.currentCustomer != null) {
            SalesHistoryPanel.displayDialog(this.salesHistoryPanel, this.currentCustomer);
        }
    }

    void gotDeleteCustomer() {
        if (Dialogs.displayChoiceDialog((String)(Internationalization.getLiteralFor((String)"ARE_YOU_SURE_YOU_WANT_TO_DELETE") + " " + this.currentCustomer.getName()), (String)Internationalization.getLiteralFor((String)"DELETE_CUSTOMER_QUESTIONMARK"), (boolean)true)) {
            this.currentCustomer.delete();
            this.customerSaved.emit((Object)this.currentCustomer);
            this.currentCustomer = null;
        }
    }

    void gotShowLocation() {
        Customer toShow = this.currentCustomer;
        if (toShow == null) {
            toShow = new Customer();
            this.gui.saveCustomer(toShow);
        }
        GoogleMapHelper.getInstance().showGoogleMap(toShow, (GuiHandler)new WaitermateGuiHandler());
    }

    void gotFinishedAddCustomer() {
        this.nav.getOkButton().requestFocusInWindow();
    }
}

