/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add.addcard;

import au.com.ordermate.util.Price;
import com.sun.jersey.api.client.WebResource;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.LoyaltyType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.web.CustomerWebInfo;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.integration.jaxb.customerportal.CustomerPortalResult;
import ordermate.integration.webservice.RestHelper;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.WaiterMate;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.customer.add.addcard.AddCardPanel;
import waitermate.gui.screens.payment.selectadjustment.SelectPriceAdjustment;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class AddCard
extends AbstractScreen {
    private AddCardPanel gui;
    private NavBar nav;
    private Customer currentCustomer;
    private boolean scan;
    private int points;
    private String cardID;
    private InventoryPriceAdjustment discount;
    private SelectPriceAdjustment adjustmentScreen;
    public final Signal back = Signals.createSignal();

    public AddCard() {
        this.gui = new AddCardPanel();
        this.gui.points.connect((Object)this, "gotEnterPoints");
        this.gui.syncPoints.connect((Object)this, "gotSyncPoints");
        this.gui.discount.connect((Object)this, "gotDiscount");
        this.gui.clearDiscount.connect((Object)this, "gotClearDiscount");
        this.gui.clearCard.connect((Object)this, "gotClearCard");
        this.gui.resetPortalPwdSignal.connect((Object)this, "gotResetPortalPassword");
        this.adjustmentScreen = new SelectPriceAdjustment(false);
        this.adjustmentScreen.addAdjustment.connect((Object)this, "gotSelectAdjustment");
        this.adjustmentScreen.back.connect((Object)this, "show");
        this.nav = new NavBar();
        this.nav.back.connect((Object)this, "back");
        this.nav.ok.connect((Object)this, "gotOk");
        this.nav.cancel.connect((Object)this, "back");
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)this.nav.getOkButton());
        this.nav.addRight((Component)this.nav.getCancelButton());
        this.stopScan();
        if (WaiterMateInputAdapter.getInstance() != null) {
            WaiterMateInputAdapter.getInstance().swipecardInput.connect((Object)this, "gotScanString");
        } else {
            WaiterMate.LOG.error("Could not obtain a InputAdapter instance.");
        }
    }

    public void start(Customer currentCust) {
        this.currentCustomer = currentCust;
        this.points = this.currentCustomer.getLoyaltyPoints();
        this.cardID = this.currentCustomer.getCardID();
        this.discount = this.currentCustomer.getPriceAdjustment();
        this.show();
    }

    private void back() {
        this.stopScan();
        this.back.emit();
    }

    public void gotOk() {
        if (this.cardID == null) {
            this.cardID = "";
        }
        this.currentCustomer.setCardID(this.cardID);
        this.currentCustomer.setPriceAdjustment(this.discount);
        LoginManager.getInstance();
        if (this.points != this.currentCustomer.getLoyaltyPoints()) {
            int tempPoints = this.points;
            boolean ok = this.resyncPoints();
            if (ok) {
                ok = LoyaltyPointAdministrator.getInstance().setLoyaltyPoints(this.currentCustomer, tempPoints, LoginManager.getEventContext());
            }
            if (!ok) {
                Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"COULD_NOT_SET_THE_CUSTOMER_POINTS") + "<p> " + Internationalization.getLiteralFor((String)"ENSURE_INTERNET_CONNECTION_IS_ACTIVE_AND_HEADOFFICE_IS_RUNNING") + "</html>"), (String)Internationalization.getLiteralFor((String)"UNABLE_TO_SYNCHRONISE"));
            } else {
                this.currentCustomer.getCustomerPoints().save();
            }
            this.setPoints(this.currentCustomer.getLoyaltyPoints());
        }
        this.currentCustomer.save();
        this.back();
    }

    private void show() {
        this.gui.setPoints(this.points);
        if (this.cardID != null && !this.cardID.equalsIgnoreCase("")) {
            this.gui.setCardID(this.cardID);
        } else {
            this.gui.setCardID("Awaiting Scan...");
        }
        this.gui.setDiscount(this.discount);
        this.gui.showPortalPwdButton(true);
        this.startScan();
        this.display();
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    void gotEnterPoints() {
        if (SystemProperty.getInstance().getLoyaltyPointsType().equals((Object)LoyaltyType.DOLLARS)) {
            double value = Dialogs.getDouble((String)("Card monetary value " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN")), (double)((double)this.points / 100.0));
            if (value != -2.147483648E9) {
                Price newPoints = new Price(value, 0.01);
                this.setPoints(newPoints.getNumCents());
            }
        } else {
            int newPoints = Dialogs.getLongInteger((String)"Card points", (int)this.points, (int)10, (boolean)true, (String)"");
            if (newPoints != Integer.MIN_VALUE) {
                this.setPoints(newPoints);
            }
        }
    }

    void gotScanString(String data) {
        if (this.scan) {
            Customer oldCustomer = Customer.getCustomerByCard((String)data);
            if (oldCustomer != null) {
                boolean ok = Dialogs.displayChoiceDialog((String)(Internationalization.getLiteralFor((String)"CUSTOMER") + " " + oldCustomer.getName() + " " + Internationalization.getLiteralFor((String)"HAS_THIS_CAR_ASSIGNED_TO_THEM") + "\n" + Internationalization.getLiteralFor((String)"TRANSFER_CONTROL_OF_THIS_CARD_TO") + " " + this.currentCustomer.getName()), (String)Internationalization.getLiteralFor((String)"CHANGE_CARD_OWNDER_QUESTIONMARK"), (boolean)true);
                if (ok) {
                    this.cardID = data;
                    this.gui.setCardID(this.cardID);
                    oldCustomer.setCardID("");
                    oldCustomer.save();
                }
            } else {
                this.cardID = data;
                this.gui.setCardID(this.cardID);
            }
        }
    }

    public void stopScan() {
        this.scan = false;
        WaiterMateInputAdapter.getInstance().enableInputParsing(true);
    }

    public void startScan() {
        this.scan = true;
        WaiterMateInputAdapter.getInstance().enableInputParsing(false);
    }

    public void setPoints(int pts) {
        this.points = pts;
        this.gui.setPoints(this.points);
    }

    public void gotDiscount() {
        List existing = Collections.emptyList();
        this.adjustmentScreen.start(existing, null, PriceAdjustmentDirection.DISCOUNT, PriceAdjustmentType.CUSTOMER, PriceAdjustmentLevel.ACCOUNT_LEVEL, new TriggerActivationContext(LoginManager.getEventContext(), this.currentCustomer));
    }

    public void gotSelectAdjustment(InventoryPriceAdjustment selectedAdj) {
        this.discount = !selectedAdj.hasValue() ? null : selectedAdj;
        this.show();
    }

    public void gotClearCard() {
        this.cardID = null;
        this.gui.setCardID(this.cardID);
    }

    public void gotClearDiscount() {
        this.discount = null;
        this.show();
    }

    void gotSyncPoints() {
        if (!this.resyncPoints()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"HEAD_OFFICE_COULD_NOT_BE_REACHED_POINTS_ARE_NOT_SYNCHRONISED"), (String)Internationalization.getLiteralFor((String)"CANNOT_SYNCHRONISE_POINTS"));
        }
    }

    private boolean resyncPoints() {
        if (this.currentCustomer.isPersistent() && LoyaltyPointAdministrator.getInstance().resynchPointsForCustomer(this.currentCustomer)) {
            this.currentCustomer.getCustomerPoints().save();
            this.setPoints(this.currentCustomer.getCustomerPoints().getTotalPoints());
            this.gui.repaint();
            return true;
        }
        return false;
    }

    void gotResetPortalPassword() {
        if (this.resetPassword(this.currentCustomer, true)) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"CUSTOMER_PORTAL_PASSWORD_WAS_RESET_SUCCESSFULLY"), (String)Internationalization.getLiteralFor((String)"CUSTOMER_PORTAL_PASSWORD_RESET"));
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"ERROR_RESETTING_CUSTOMER_PORTAL_PASSWORD"), (String)Internationalization.getLiteralFor((String)"ERROR_RESETTING_CUSTOMER_PORTAL_PASSWORD_"));
        }
    }

    private boolean resetPassword(Customer customer, boolean printDocket) throws IllegalStateException {
        if (!customer.isPersistent()) {
            throw new IllegalStateException("Password can only be generated once a Customer is persisted.");
        }
        LocalIdTranslator idTranslator = new LocalIdTranslator();
        Long custHoId = idTranslator.convertToHOId((Number)customer.getID());
        String password = CustomerWebInfo.generateDefaultCustomerPassword((Long)custHoId);
        if (this.sendToHeadOffice(custHoId, password)) {
            if (printDocket) {
                CustomerWebInfo.printPasswordDocketText((Customer)customer, (String)password);
            }
            return true;
        }
        return false;
    }

    private boolean sendToHeadOffice(long id, String pwd) {
        try {
            RestHelper helper = new RestHelper();
            WebResource resource = helper.getResource(HOConfig.getInstance().getServerLocation() + "portal/customer/updateCustomer");
            resource = helper.addParameter(resource, "id", Long.toString(id));
            resource = helper.addParameter(resource, "pwd", pwd);
            resource = helper.addBasicAuth(resource, OrderMate.CUSTOMER_PORTAL_USER, OrderMate.CUSTOMER_PORTAL_PWD);
            CustomerPortalResult doc = (CustomerPortalResult)resource.get(CustomerPortalResult.class);
            if (doc.getResultCode().intValue() != 0) {
                OrderMate.LOG.error("Error sending Customer password reset to HO for Customer ID: " + id + ", error code: " + doc.getResultCode() + ", description: " + doc.getResultDesc());
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error sending Customer password reset to HO for Customer ID: " + id, (Throwable)ex);
            return false;
        }
    }
}

