/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add.addcard;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.LoyaltyType;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomButton;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class AddCardPanel
extends JPanel
implements ActionListener {
    private JPanel gui;
    private JLabel barcodeLabel;
    private JLabel messageLabel;
    private JButton pointsButton;
    private StandardSecurityDecorator decoratedPointsButton;
    private JButton syncPointsButton;
    private JButton clearButton;
    private JButton clearDiscountButton;
    private String pointsUnit;
    private JLabel unitLabel;
    private StandardSecurityDecorator discountDecorator;
    private CustomButton discountButton;
    private JButton resetPortalPwdButton;
    public final Signal points = Signals.createSignal();
    public final Signal syncPoints = Signals.createSignal();
    public final Signal discount = Signals.createSignal();
    public final Signal clearDiscount = Signals.createSignal();
    public final Signal clearCard = Signals.createSignal();
    public final Signal resetPortalPwdSignal = Signals.createSignal();

    public AddCardPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 10)));
        this.gui = this.createInterface();
        this.add((Component)this.gui, new Rectangle(0, 0, 10, 10));
    }

    public void setPoints(int pts) {
        if (LoyaltyType.DOLLARS.equals((Object)SystemProperty.getInstance().getLoyaltyPointsType())) {
            this.pointsButton.setText("<html><h2>" + new Price((double)pts / 100.0, 0.01) + "</h2></html>");
        } else {
            this.pointsButton.setText("<html><h2>" + pts + "</h2></html>");
        }
    }

    public JPanel createInterface() {
        JPanel panel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(10, 30)));
        JPanel barcodePanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(12, 4)));
        barcodePanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"CARD_ID")));
        this.barcodeLabel = new JLabel("<html><h2>" + Internationalization.getLiteralFor((String)"AWAITING_SCAN") + "...</h2><html>");
        this.barcodeLabel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.BLACK), new EmptyBorder(10, 10, 10, 10)));
        this.messageLabel = new JLabel(Internationalization.getLiteralFor((String)"SCAN_CARD_TO_SET_FOR_CUSTOMER"));
        this.clearButton = new JButton(Internationalization.getLiteralFor((String)"CLEAR"));
        this.clearButton.addActionListener(this);
        barcodePanel.add((Component)this.barcodeLabel, new Rectangle(2, 0, 6, 2));
        barcodePanel.add((Component)this.clearButton, new Rectangle(8, 0, 2, 2));
        barcodePanel.add((Component)this.messageLabel, new Rectangle(5, 2, 6, 2));
        JPanel pointsPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(5, 4)));
        pointsPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"CUSTOMER_POINTS")));
        this.pointsButton = new JButton("");
        this.pointsButton.setName("customerPoints");
        this.pointsButton.addActionListener(this);
        this.decoratedPointsButton = new StandardSecurityDecorator((JComponent)this.pointsButton, AllPermissions.EDIT_CUSTOMER_LOYALTY);
        this.syncPointsButton = new JButton("<html>" + Internationalization.getLiteralFor((String)"SYNCHRONISE") + "<br>" + Internationalization.getLiteralFor((String)"POINTS") + "</html>");
        this.syncPointsButton.setName("syncPoints");
        this.syncPointsButton.addActionListener(this);
        this.resetPortalPwdButton = new JButton("<html>" + Internationalization.getLiteralFor((String)"RESET_AND_PRINT") + "<br>" + Internationalization.getLiteralFor((String)"PORTAL_PASSWORD") + "</html>", IconLoader.get((String)"/waitermate/images/key24x24.png"));
        this.resetPortalPwdButton.setName("resetPortalPwd");
        this.resetPortalPwdButton.addActionListener(this);
        this.pointsUnit = LoyaltyType.POINTS.equals((Object)SystemProperty.getInstance().getLoyaltyPointsType()) ? "POINTS" : "DOLLARS";
        this.unitLabel = new JLabel("<html><h2>(" + this.pointsUnit + ")</h2><html>");
        pointsPanel.add((Component)this.decoratedPointsButton, new Rectangle(2, 1, 1, 2));
        pointsPanel.add((Component)this.syncPointsButton, new Rectangle(4, 1, 1, 2));
        pointsPanel.add((Component)this.unitLabel, new Rectangle(3, 1, 1, 2));
        pointsPanel.add((Component)this.resetPortalPwdButton, new Rectangle(0, 1, 1, 2));
        this.discountButton = new CustomButton();
        this.discountButton.setPreferredSize(new Dimension(150, 75));
        this.discountButton.addActionListener((ActionListener)this);
        this.discountDecorator = new StandardSecurityDecorator((JComponent)this.discountButton, AllPermissions.CUSTOMER_DISCOUNT);
        JPanel discountPanel = new JPanel();
        discountPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"DISCOUNT")));
        discountPanel.add((Component)this.discountDecorator);
        this.clearDiscountButton = new JButton(Internationalization.getLiteralFor((String)"CLEAR"));
        this.clearDiscountButton.setIcon(IconLoader.get((String)"/waitermate/images/clearSmall.png"));
        this.clearDiscountButton.addActionListener(this);
        discountPanel.add(this.clearDiscountButton);
        panel.add((Component)barcodePanel, new Rectangle(0, 0, 10, 10));
        panel.add((Component)discountPanel, new Rectangle(0, 10, 10, 10));
        panel.add((Component)pointsPanel, new Rectangle(0, 20, 10, 10));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pointsButton) {
            this.points.emit();
        } else if (source == this.discountButton) {
            this.discount.emit();
        } else if (source == this.clearButton) {
            this.clearCard.emit();
        } else if (source == this.clearDiscountButton) {
            this.clearDiscount.emit();
        } else if (source == this.syncPointsButton) {
            this.syncPoints.emit();
        } else if (source == this.resetPortalPwdButton) {
            this.resetPortalPwdSignal.emit();
        }
    }

    public void setCardID(String cardId) {
        String cardID = cardId;
        if (cardID == null) {
            cardID = "";
        }
        this.barcodeLabel.setText("<html><h2>" + cardID + "</h2><html>");
    }

    public void setDiscount(InventoryPriceAdjustment discountAdj) {
        if (discountAdj == null) {
            this.discountButton.setText(Internationalization.getLiteralFor((String)"NONE"));
        } else {
            this.discountButton.setData((Displayable)discountAdj);
        }
    }

    public void showPortalPwdButton(boolean visible) {
        this.resetPortalPwdButton.setVisible(visible);
    }
}

