/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.add.basicinfo;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import ordermate.database.config.customer.CustomerInterest;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Gender;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.customer.add.CustomerInfoPanelTSFriendly;
import waitermate.guikit.dialogs.CalendarDialog;
import waitermate.guikit.dialogs.MultiSelectPopupWindow;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class PersonalInfoPanel
extends CustomerInfoPanelTSFriendly {
    private JToggleButton genderButton = new JToggleButton("");
    private JToggleButton occupation;
    private JToggleButton company;
    private JToggleButton dobButton;
    private JToggleButton anniversaryButton;
    private JToggleButton interestsButton;
    private JLabel dobLabel;
    private JLabel occupationLabel;
    private JLabel companyLabel;
    private JLabel anniversaryLabel;
    private JLabel interestsLabel;
    private Date dateOfBirth;
    private Date anniversary;
    private List<Displayable> interests;
    private MultiSelectPopupWindow interestsPopup;

    public PersonalInfoPanel() {
        super(Internationalization.getLiteralFor((String)"PERSONAL"));
        this.genderButton.setName("genderButton");
        this.buttons.add(this.genderButton);
        this.interestsButton = new JToggleButton("");
        this.interestsButton.setName("interestsButton");
        this.buttons.add(this.interestsButton);
        this.dobButton = new JToggleButton("");
        this.dobButton.setName("dobButton");
        this.buttons.add(this.dobButton);
        this.dobLabel = new JLabel(Internationalization.getLiteralFor((String)"DOB_WITH_FORMAT"));
        this.anniversaryButton = new JToggleButton("");
        this.anniversaryButton.setName("anniversaryButton");
        this.buttons.add(this.anniversaryButton);
        this.anniversaryLabel = new JLabel("Anniversary");
        this.interestsLabel = new JLabel("Interests");
        this.interests = new ArrayList<Displayable>();
        this.occupation = new JToggleButton("");
        this.occupation.setName("occupationField");
        this.addButtonProperty(Customer.Properties.OCCUPATION, this.occupation);
        this.buttons.add(this.occupation);
        this.occupationLabel = new JLabel(Internationalization.getLiteralFor((String)"OCCUPATION"));
        this.company = new JToggleButton("");
        this.company.setName("companyField");
        this.buttons.add(this.company);
        this.companyLabel = new JLabel(Internationalization.getLiteralFor((String)"COMPANY"));
        this.genderButton.addActionListener(this);
        this.dobButton.addActionListener(this);
        this.anniversaryButton.addActionListener(this);
        this.interestsButton.addActionListener(this);
        this.occupation.addActionListener(this);
        this.company.addActionListener(this);
        this.add((Component)this.dobLabel, new Rectangle(0, 0, 4, 2));
        this.add((Component)this.dobButton, new Rectangle(0, 2, 4, 4));
        this.add((Component)this.anniversaryLabel, new Rectangle(5, 0, 4, 2));
        this.add((Component)this.anniversaryButton, new Rectangle(5, 2, 4, 4));
        this.add((Component)this.occupationLabel, new Rectangle(10, 0, 4, 2));
        this.add((Component)this.occupation, new Rectangle(10, 2, 4, 4));
        this.add((Component)this.companyLabel, new Rectangle(0, 8, 4, 2));
        this.add((Component)this.company, new Rectangle(0, 10, 6, 4));
        this.add((Component)new JLabel("Gender"), new Rectangle(7, 8, 4, 2));
        this.add((Component)this.genderButton, new Rectangle(7, 10, 4, 4));
        this.add((Component)this.interestsLabel, new Rectangle(12, 8, 6, 2));
        this.add((Component)this.interestsButton, new Rectangle(12, 10, 6, 4));
        this.interestsPopup = new MultiSelectPopupWindow("Select Customer Interests", CustomerInterest.getAllInterests(), 2, 4, false, false);
        this.newInput.emit();
    }

    @Override
    public void setSelectedButton(AbstractButton button) {
        List newInterests;
        super.setSelectedButton(button);
        if (button == this.genderButton) {
            OnePressPopupWindow genderPopup = new OnePressPopupWindow(Internationalization.getLiteralFor((String)"GENDER"), (Collection)AbstractScrollPaneModel.constructButtons((String[])new String[]{Gender.Male.name(), Gender.Female.name(), "Unknown"}), 1, 3, true);
            JButton selected = genderPopup.start();
            if (selected != null) {
                String text = selected.getText();
                if ("Unknown".equals(text)) {
                    this.genderButton.setText(null);
                } else {
                    this.genderButton.setText(selected.getText());
                }
            }
        } else if (button == this.dobButton) {
            Date newDate = this.gotDateButtonPressed(this.dateOfBirth);
            if (newDate != null) {
                this.dateOfBirth = newDate;
                this.dobButton.setText(DateTimeUtils.getMediumDateFormat().format(this.dateOfBirth));
            }
        } else if (button == this.anniversaryButton) {
            Date newDate = this.gotDateButtonPressed(this.anniversary);
            if (newDate != null) {
                this.anniversary = newDate;
                this.anniversaryButton.setText(DateTimeUtils.getMediumDateFormat().format(this.anniversary));
            }
        } else if (button == this.interestsButton && (newInterests = this.interestsPopup.start(this.interests)) != null) {
            this.interests = newInterests;
            this.interestsButton.setText(this.getInterestsString());
        }
        this.doRequiredFieldsVisualFeedback();
    }

    private String getInterestsString() {
        StringBuilder sb = new StringBuilder();
        for (Displayable interest : this.interests) {
            CustomerInterest custInterest = (CustomerInterest)interest;
            sb.append(custInterest.getLabel()).append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private Date gotDateButtonPressed(Date selectedDate) {
        CalendarDialog dialog = new CalendarDialog(selectedDate == null ? new Date() : selectedDate);
        dialog.setup(selectedDate, null);
        return dialog.start();
    }

    public void setCustomer(Customer cust) {
        if (cust != null) {
            this.dateOfBirth = cust.getDOB();
            this.dobButton.setText(this.dateOfBirth != null ? DateTimeUtils.getMediumDateFormat().format(this.dateOfBirth) : null);
            this.anniversary = cust.getAnniversary();
            this.anniversaryButton.setText(this.anniversary != null ? DateTimeUtils.getMediumDateFormat().format(this.anniversary) : null);
            this.interests = new ArrayList<Displayable>();
            this.interestsButton.setText("");
            if (cust.getInterests() != null && !cust.getInterests().isEmpty()) {
                String interestsStr = cust.getInterests().toString();
                this.interestsButton.setText(interestsStr.substring(1, interestsStr.length() - 1));
                for (CustomerInterest interest : cust.getInterests()) {
                    this.interests.add((Displayable)interest);
                }
            }
            this.company.setText(cust.getCompany());
            this.occupation.setText(cust.getOccupation());
            this.doRequiredFieldsVisualFeedback();
            this.newInput.emit();
            Gender gender = cust.getGender();
            this.genderButton.setText(gender == null ? null : gender.name());
        }
    }

    @Override
    public Customer saveObject(Customer object) {
        super.saveObject(object);
        object.setCompany(this.getCompany());
        object.setOccupation(this.getOccupation());
        if (this.dateOfBirth != null) {
            object.setDOB(this.dateOfBirth);
        }
        if (this.anniversary != null) {
            object.setAnniversary(this.anniversary);
        }
        if (this.interests != null) {
            HashSet<CustomerInterest> custInterests = new HashSet<CustomerInterest>();
            for (Displayable interest : this.interests) {
                custInterests.add((CustomerInterest)interest);
            }
            object.updateInterests(custInterests);
        }
        object.setGender(this.getGender());
        return object;
    }

    @Override
    public void loadObject(Customer customer) {
        super.loadObject(customer);
        if (customer != null) {
            this.setCustomer(customer);
        }
    }

    public Gender getGender() {
        String text = this.genderButton.getText();
        if (text != null && text.length() > 0) {
            return Gender.valueOf((String)text);
        }
        return null;
    }

    public String getCompany() {
        return this.company.getText();
    }

    public String getOccupation() {
        return this.occupation.getText();
    }

    @Override
    public void keyboardUpdated(String newValue) {
        if (this.company.isSelected() || this.occupation.isSelected()) {
            super.keyboardUpdated(newValue);
        } else {
            this.newInput();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectedButton(this.occupation);
        this.occupation.setSelected(true);
    }
}

