/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.search;

import au.com.ordermate.oquery.ObjectSearcher;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.PropertyValue;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Customer;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.CaptureKeyboard;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.customer.search.SearchPanel;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class CustomerSearch
extends AbstractScreen
implements ActionListener {
    public static final Signal<?, ?, ?, ?, ?> terminalSetupChanged = Signals.createSignal();
    public final Signal<Customer, ?, ?, ?, ?> selected = Signals.createSignal(Customer.class, (String)"selected");
    public final Signal<Customer, ?, ?, ?, ?> edit;
    public final Signal add = Signals.createSignal();
    public final Signal back;
    private SearchPanel gui;
    private NavBar nav;
    private JButton addButton;
    private StandardSecurityDecorator addDecorator;
    private JButton clearButton;
    private ObjectSearcher custSearch;
    private PopupWindow badUserPopup;
    private List requiredFields;
    private UpdateMatchesWorker updateMatchesWorker = null;

    public CustomerSearch(List requirements, boolean allowHistory, boolean allowEdit) {
        this.requiredFields = requirements;
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "gotNewUser");
        this.gui = new SearchPanel(allowHistory, allowEdit);
        this.gui.propertyChanged.connect((Object)this, "propertyChange");
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.clearButton = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/clear.png"), Internationalization.getLiteralFor((String)"CLEAR_SEARCH"), "Clear Search");
        this.clearButton.addActionListener(this);
        this.nav.addLeft((Component)this.clearButton);
        this.addButton = this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/images/customer.png"), Internationalization.getLiteralFor((String)"ADD_CUSTOMER"), "Add Customer");
        this.addDecorator = new StandardSecurityDecorator((JComponent)this.addButton, AllPermissions.CUSTOMER_ADMIN);
        if (!Terminal.getLocalHost().isUseOnscreenKeyboard()) {
            this.addDecorator.setSecurityOn(false);
        }
        this.addButton.addActionListener(this);
        this.nav.addRight((Component)this.addDecorator);
        this.custSearch = new ObjectSearcher(Customer.class);
        this.custSearch.addEquivalentGroup(Customer.Properties.PRIMARY_PHONE_NUMBER, Customer.Properties.SECONDARY_PHONE_NUMBER);
        this.custSearch.addOrderBy(Customer.Properties.FIRST_NAME);
        this.custSearch.addOrderBy(Customer.Properties.LAST_NAME);
        this.gui.selected.connect((Object)this, "gotSelected");
        this.edit = this.gui.edit;
        this.back = this.nav.back;
        WaiterMateInputAdapter.getInstance().customerInput.connect((Object)this, "gotCustomerSwipe");
    }

    public void reset() {
        this.custSearch.clearPropertyValue();
        this.custSearch.setPropertyValue(Customer.Properties.SYSTEM_STATE, "ACTIVE");
        this.gui.reset();
        List customers = Customer.getSomeCustomers((Integer)20);
        this.gui.setCustomers(customers);
    }

    public void setRequiredFields(List requirements) {
        this.requiredFields = requirements;
    }

    public boolean isAddButtonVisible() {
        return this.addDecorator.isVisible();
    }

    public void setAddButtonVisible(boolean visible) {
        this.addDecorator.setVisible(visible);
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public List<PropertyValue> getEnteredProperties() {
        ArrayList<PropertiedObject.Property> properties = new ArrayList<PropertiedObject.Property>();
        properties.add(Customer.Properties.TITLE);
        properties.add(Customer.Properties.FIRST_NAME);
        properties.add(Customer.Properties.LAST_NAME);
        properties.add(Customer.Properties.PRIMARY_PHONE_NUMBER);
        properties.add(Customer.Properties.ROOM_APT_NUMBER);
        properties.add(Customer.Properties.HOUSE_NUMBER);
        properties.add(Customer.Properties.STREET_NAME);
        properties.add(Customer.Properties.STREET_TYPE);
        properties.add(Customer.Properties.SUBURB);
        properties.add(Customer.Properties.POSTCODE);
        properties.add(Customer.Properties.STATE);
        properties.add(Customer.Properties.E_MAIL);
        properties.add(Customer.Properties.CATEGORY);
        properties.add(Customer.Properties.COMPANY);
        properties.add(Customer.Properties.CARD_ID);
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(properties.size());
        for (PropertiedObject.Property nextProp : properties) {
            values.add(new PropertyValue(nextProp, this.gui.getValue(nextProp)));
        }
        return values;
    }

    public void setValue(PropertiedObject.Property property, String value) {
        this.gui.setValue(property, value);
    }

    public void propertyChange(PropertiedObject.Property property, String value) {
        this.custSearch.setPropertyValue(property, value);
        this.updateMatches();
    }

    public void gotSelected(Customer theCustomer) {
        if (this.requiredFields == null) {
            this.selected.emit((Object)theCustomer);
            return;
        }
        if (theCustomer.getMeetsRequirements(this.requiredFields)) {
            this.selected.emit((Object)theCustomer);
        } else {
            this.edit.emit((Object)theCustomer);
        }
    }

    public void updateMatches() {
        if (!Terminal.getLocalHost().isUseOnscreenKeyboard()) {
            if (this.updateMatchesWorker != null) {
                this.updateMatchesWorker.cancel(true);
            }
            this.updateMatchesWorker = new UpdateMatchesWorker();
            this.updateMatchesWorker.execute();
        } else {
            List customers = this.custSearch.getMatches();
            this.gui.setCustomers(customers);
        }
    }

    public void gotNewUser(User user) {
        if (this.badUserPopup != null && ScreenResource.isShowing((JComponent)this.badUserPopup)) {
            ScreenResource.stopWindow((JComponent)this.badUserPopup);
        }
    }

    private void addCustomer() {
        if (!Terminal.getLocalHost().isUseOnscreenKeyboard() && !this.addDecorator.isSecurityEnabled()) {
            if (this.badUserPopup == null) {
                this.badUserPopup = new PopupWindow();
                this.badUserPopup.getNavBar().getOkButton().setEnabled(false);
                this.badUserPopup.setComponent((JComponent)new JLabel("<html>" + Internationalization.getLiteralFor((String)"YOU_DO_NOT_HAVE_PERMISSION_TO_ADD_CUSTOMERS") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_SWIPE_YOUR_CARD_TO_LOGIN_AS_A_DIFFERENT_USER") + "</html>"));
            }
            CaptureKeyboard.getInstance().processEvents(true);
            Dialogs.displayDialog((PopupWindow)this.badUserPopup, null, null);
            CaptureKeyboard.getInstance().processEvents(false);
            if (!this.addDecorator.isSecurityEnabled()) {
                return;
            }
        }
        this.add.emit();
    }

    void gotCustomerSwipe(Customer toSet) {
        if (this.isDisplaying()) {
            this.setValue(Customer.Properties.CARD_ID, toSet.getCardID());
            this.propertyChange(Customer.Properties.CARD_ID, toSet.getCardID());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addButton) {
            this.addCustomer();
        } else if (source == this.clearButton) {
            this.reset();
        }
    }

    public void setFullScreen(boolean isFullScreen) {
        this.gui.setFullScreen(isFullScreen);
    }

    class UpdateMatchesWorker
    extends SwingWorker<List<Customer>, Object> {
        UpdateMatchesWorker() {
        }

        @Override
        public List<Customer> doInBackground() {
            return CustomerSearch.this.custSearch.getMatches();
        }

        @Override
        public void done() {
            try {
                CustomerSearch.this.gui.setCustomers((List)this.get());
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Error updating customer matches- likely due to new text input starting a new search (this is probably OK)");
            }
        }
    }
}

