/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.search;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.CustomerSearch;
import ordermate.gui.CaptureKeyboard;
import ordermate.gui.autosuggestor.DynamicSuggestionComboHandler;
import ordermate.gui.autosuggestor.StringSearcherSuggestor;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.internationalization.Internationalization;
import waitermate.KBFriendlyFormHelper;
import waitermate.gui.screens.customer.search.CustomerSearchFieldPanel;

class CustomerSearchFieldPanelKBFriendly
extends CustomerSearchFieldPanel
implements AncestorListener,
FocusListener,
DocumentListener,
ActionListener {
    private JComboBox firstNameField;
    private JComboBox lastNameField;
    private JTextField phoneField;
    private JTextField houseNumField;
    private JTextField emailField;
    private JComboBox streetNameCombo;
    private JComboBox suburbField;
    private JTextField postcodeField;
    private JTextField cardIDField;
    private JComboBox companyCombo;
    private JComboBox titleCombo;
    private JComboBox streetTypeCombo;
    private JComboBox stateCombo;
    private JComboBox categoryCombo;
    private Map<PropertiedObject.Property, JComponent> propertyFieldMap;
    private CustomerCategory dummyCategory;
    private JComponent currentComp;
    private boolean isResetting = false;

    @Override
    protected void setupComponents() {
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(1, 11), 0, 0));
        JPanel basicPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(20, 7), 0, 5));
        JPanel addressPanel = new JPanel((LayoutManager)new GraphPaperLayout(new Dimension(40, 4), 0, 5));
        basicPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"BASIC_AND_CONTACT")));
        addressPanel.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"ADDRESS_AND_PERSONAL")));
        this.propertyFieldMap = new HashMap<PropertiedObject.Property, JComponent>();
        this.titleCombo = this.createComboBox(Customer.Properties.TITLE, CustomerSearch.TITLES);
        this.firstNameField = this.createSuggestionCombo(Customer.Properties.FIRST_NAME);
        this.lastNameField = this.createSuggestionCombo(Customer.Properties.LAST_NAME);
        this.emailField = this.createTextField(Customer.Properties.E_MAIL, 20);
        this.phoneField = this.createTextField(Customer.Properties.PRIMARY_PHONE_NUMBER, 20);
        this.propertyFieldMap.put(Customer.Properties.SECONDARY_PHONE_NUMBER, this.phoneField);
        this.houseNumField = this.createTextField(Customer.Properties.HOUSE_NUMBER, 5);
        this.streetTypeCombo = this.createComboBox(Customer.Properties.STREET_TYPE, CustomerSearch.makeStreetTypeList().toArray(new String[0]));
        this.suburbField = this.createSuggestionCombo(Customer.Properties.SUBURB, (PropertiedObject.Property<String>)StreetDirectoryReference.Properties.SUBURB);
        String prototypeBurb = Internationalization.getLiteralFor((String)"LONG_NAMED_SUBURB");
        this.suburbField.putClientProperty("substancelaf.comboPopupPrototype", prototypeBurb);
        this.suburbField.setPrototypeDisplayValue(prototypeBurb);
        this.stateCombo = this.createComboBox(Customer.Properties.STATE, CustomerSearch.getStates());
        this.postcodeField = this.createTextField(Customer.Properties.POSTCODE, 5);
        this.cardIDField = this.createTextField(Customer.Properties.CARD_ID, 20);
        this.companyCombo = this.createSuggestionCombo(Customer.Properties.COMPANY);
        EventList categories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
        this.dummyCategory = new CustomerCategory();
        this.dummyCategory.setLabel(Internationalization.getLiteralFor((String)"_NO_CATEGORY_"));
        categories.add(0, (Object)this.dummyCategory);
        this.categoryCombo = this.createComboBox(Customer.Properties.CATEGORY, categories);
        this.addAncestorListener(this);
        this.streetNameCombo = this.createPropertyCombo(Customer.Properties.STREET_NAME, CustomerSearch.makeStreetNameSuggestor());
        StreetDirectoryReference ref = new StreetDirectoryReference();
        ref.setStreetName(Internationalization.getLiteralFor((String)"REALLY_LONG_STREET_NAME"));
        ref.setSuburb(Internationalization.getLiteralFor((String)"PORT_MELBOURNE"));
        ref.setPostcode(Internationalization.getLiteralFor((String)"_1234"));
        this.streetNameCombo.setPrototypeDisplayValue(ref);
        this.streetNameCombo.putClientProperty("substancelaf.comboPopupPrototype", ref);
        basicPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"TITLE"), null), new Rectangle(0, 0, 4, 1));
        basicPanel.add((Component)this.titleCombo, new Rectangle(5, 0, 8, 1));
        basicPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"FIRST_NAME"), null), new Rectangle(0, 1, 4, 1));
        basicPanel.add((Component)this.firstNameField, new Rectangle(5, 1, 14, 1));
        basicPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"LAST_NAME"), null), new Rectangle(0, 2, 4, 1));
        basicPanel.add((Component)this.lastNameField, new Rectangle(5, 2, 14, 1));
        basicPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"PHONE"), null), new Rectangle(0, 3, 4, 1));
        basicPanel.add((Component)this.phoneField, new Rectangle(5, 3, 14, 1));
        basicPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"EMAIL"), null), new Rectangle(0, 4, 4, 1));
        basicPanel.add((Component)this.emailField, new Rectangle(5, 4, 14, 1));
        basicPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"CATEGORY"), null), new Rectangle(0, 5, 4, 1));
        basicPanel.add((Component)this.categoryCombo, new Rectangle(5, 5, 8, 1));
        if (SystemProperty.getInstance().isLoyaltyEnabled()) {
            basicPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"CARD_ID"), null), new Rectangle(0, 6, 4, 1));
            basicPanel.add((Component)this.cardIDField, new Rectangle(5, 6, 8, 1));
        }
        addressPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"NUMBER"), null), new Rectangle(0, 0, 8, 1));
        addressPanel.add((Component)this.houseNumField, new Rectangle(8, 0, 4, 1));
        addressPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"STREET"), null), new Rectangle(12, 0, 6, 1));
        addressPanel.add((Component)this.streetNameCombo, new Rectangle(18, 0, 14, 1));
        addressPanel.add((Component)this.streetTypeCombo, new Rectangle(32, 0, 8, 1));
        addressPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"SUBURB"), null), new Rectangle(0, 1, 8, 1));
        addressPanel.add((Component)this.suburbField, new Rectangle(8, 1, 8, 1));
        addressPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"STATE"), null), new Rectangle(16, 1, 6, 1));
        addressPanel.add((Component)this.stateCombo, new Rectangle(22, 1, 8, 1));
        addressPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"POSTCODE"), null), new Rectangle(30, 1, 6, 1));
        addressPanel.add((Component)this.postcodeField, new Rectangle(36, 1, 4, 1));
        addressPanel.add((Component)KBFriendlyFormHelper.createLabel(Internationalization.getLiteralFor((String)"COMPANY"), null), new Rectangle(0, 2, 8, 1));
        addressPanel.add((Component)this.companyCombo, new Rectangle(8, 2, 14, 1));
        this.add((Component)basicPanel, new Rectangle(0, 0, 1, 7));
        this.add((Component)addressPanel, new Rectangle(0, 7, 1, 4));
    }

    private <P extends PersistentObjectI> JComboBox createPropertyCombo(PropertiedObject.Property targetProperty, Suggestor<P> suggestor) {
        EventComboBoxModel model = new EventComboBoxModel(suggestor.getSuggestions());
        JComboBox box = KBFriendlyFormHelper.createComboBox(targetProperty, (ComboBoxModel)model);
        DynamicSuggestionComboHandler handler = new DynamicSuggestionComboHandler(suggestor, box, false);
        handler.selectionMade.connect((Object)this, "gotObjectSelected");
        JTextField editorComponent = (JTextField)box.getEditor().getEditorComponent();
        this.propertyFieldMap.put(targetProperty, editorComponent);
        editorComponent.addFocusListener(this);
        editorComponent.getDocument().addDocumentListener(this);
        return box;
    }

    private JComboBox createSuggestionCombo(PropertiedObject.Property targetProperty, PropertiedObject.Property<String> sourceProperty) {
        StringSearcherSuggestor suggestor = this.constructSuggestor(sourceProperty);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(suggestor.getSuggestions().toArray());
        JComboBox box = KBFriendlyFormHelper.createComboBox(targetProperty, model);
        new DynamicSuggestionComboHandler((Suggestor)suggestor, box, true);
        JTextField editorComponent = (JTextField)box.getEditor().getEditorComponent();
        this.propertyFieldMap.put(targetProperty, editorComponent);
        editorComponent.addFocusListener(this);
        editorComponent.getDocument().addDocumentListener(this);
        return box;
    }

    private JComboBox createSuggestionCombo(PropertiedObject.Property property) {
        return this.createSuggestionCombo(property, (PropertiedObject.Property<String>)property);
    }

    private JTextField createTextField(PropertiedObject.Property property, int columns) {
        JTextField field = KBFriendlyFormHelper.createTextField(property, columns);
        this.propertyFieldMap.put(property, field);
        field.getDocument().addDocumentListener(this);
        field.addFocusListener(this);
        return field;
    }

    private JComboBox createComboBox(PropertiedObject.Property property, String[] values) {
        EventList list = GlazedLists.eventListOf((Object[])values);
        list.add(0, (Object)"");
        return this.createComboBox(property, list);
    }

    private JComboBox createComboBox(PropertiedObject.Property property, EventList items) {
        EventComboBoxModel model = new EventComboBoxModel(items);
        JComboBox box = KBFriendlyFormHelper.createComboBox(property, (ComboBoxModel)model);
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)box, (EventList)items);
        support.setStrict(true);
        support.setSelectsTextOnFocusGain(true);
        this.propertyFieldMap.put(property, box);
        box.getEditor().getEditorComponent().addFocusListener(this);
        box.addActionListener(this);
        return box;
    }

    @Override
    public void reset() {
        try {
            this.isResetting = true;
            this.firstNameField.setSelectedItem(null);
            this.lastNameField.setSelectedItem(null);
            this.phoneField.setText(null);
            this.houseNumField.setText(null);
            this.streetNameCombo.setSelectedItem(null);
            this.suburbField.setSelectedItem(null);
            this.emailField.setText(null);
            this.companyCombo.setSelectedItem(null);
            this.stateCombo.setSelectedIndex(-1);
            this.postcodeField.setText(null);
            this.streetTypeCombo.setSelectedItem("");
            this.categoryCombo.setSelectedItem(this.dummyCategory);
            this.emitChange();
        }
        finally {
            this.isResetting = false;
        }
    }

    @Override
    public Object getValue(PropertiedObject.Property property) {
        JComponent comp = this.propertyFieldMap.get(property);
        if (comp == null) {
            return null;
        }
        if (comp instanceof JTextComponent) {
            return ((JTextComponent)comp).getText();
        }
        if (comp instanceof JComboBox) {
            return ((JComboBox)comp).getSelectedItem();
        }
        return null;
    }

    @Override
    public void setValue(PropertiedObject.Property property, Object value) {
        JComponent comp = this.propertyFieldMap.get(property);
        if (comp == null) {
            throw new IllegalArgumentException("Cannot set a value for an unknown property:" + property);
        }
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setText(value == null ? null : String.valueOf(value));
        } else if (comp instanceof JComboBox) {
            ((JComboBox)comp).setSelectedItem(value);
        }
    }

    private void emitChange() {
        JComponent theComp = this.currentComp;
        if (theComp == null) {
            return;
        }
        Object value = null;
        if (theComp instanceof JComboBox) {
            value = ((JComboBox)theComp).getSelectedItem();
            if (value instanceof PersistentObject) {
                value = ((PersistentObject)value).getID();
            }
        } else {
            value = ((JTextComponent)theComp).getText();
        }
        for (PropertiedObject.Property nextProp : this.propertyFieldMap.keySet()) {
            if (!this.propertyFieldMap.get(nextProp).equals(theComp)) continue;
            this.emitPropertyChange(nextProp, value);
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.firstNameField.requestFocusInWindow();
        CaptureKeyboard.getInstance().processEvents(false);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        CaptureKeyboard.getInstance().processEvents(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isResetting) {
            return;
        }
        this.currentComp = (JComponent)e.getSource();
        if (this.currentComp != this.streetNameCombo) {
            this.emitChange();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.emitChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.emitChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.emitChange();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.currentComp = (JComponent)e.getSource();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.currentComp = null;
    }

    public void gotObjectSelected(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof StreetDirectoryReference) {
            StreetDirectoryReference ref = (StreetDirectoryReference)value;
            this.suburbField.setSelectedItem(ref.getSuburb());
            this.streetNameCombo.setSelectedItem(ref.getStreetName());
            this.streetTypeCombo.setSelectedItem(CustomerSearch.convertStreetAbbreviationToName((String)ref.getStreetType()));
            this.stateCombo.requestFocusInWindow();
        }
    }
}

