/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.customer.search;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerSearch;
import ordermate.gui.autosuggestor.StreetDirectorySearcherSuggestor;
import ordermate.gui.autosuggestor.StringSearcherSuggestor;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.gui.dialogs.SuggestDialog;
import waitermate.gui.screens.customer.search.CustomerSearchFieldPanel;
import waitermate.guikit.dialogs.OnePressPopupWindow;

class CustomerSearchFieldPanelTSFriendly
extends CustomerSearchFieldPanel
implements ActionListener {
    private JButton firstNameButton;
    private JButton lastNameButton;
    private JButton phoneButton;
    private JButton emailButton;
    private JButton cardButton;
    private JButton roomNumButton;
    private JButton houseNumButton;
    private JButton streetNameButton;
    private JButton suburbButton;
    private JButton postcodeButton;
    private JButton streetTypeButton;
    private JButton stateButton;
    private Map<AbstractButton, PropertiedObject.Property> buttonPropertyMap;

    @Override
    protected void setupComponents() {
        this.buttonPropertyMap = new HashMap<AbstractButton, PropertiedObject.Property>();
        this.initButtons();
        JPanel namePanel = new JPanel();
        namePanel.setLayout((LayoutManager)new GraphPaperLayout(2, 4));
        namePanel.setBorder(BorderFactory.createTitledBorder(Internationalization.getLiteralFor((String)"NAME_AND_PHONE")));
        namePanel.add((Component)new FieldPanel(Internationalization.getLiteralFor((String)"FIRST_NAME") + ": ", this.firstNameButton, 2), new Rectangle(0, 0, 2, 1));
        namePanel.add((Component)new FieldPanel(Internationalization.getLiteralFor((String)"LAST_NAME") + ": ", this.lastNameButton, 2), new Rectangle(0, 1, 2, 1));
        namePanel.add((Component)new FieldPanel(Internationalization.getLiteralFor((String)"PHONE") + ": ", this.phoneButton, 1), new Rectangle(0, 2, 1, 1));
        namePanel.add((Component)new FieldPanel(Internationalization.getLiteralFor((String)"EMAIL_ADDRESS") + ": ", this.emailButton, 1), new Rectangle(1, 2, 1, 1));
        if (SystemProperty.getInstance().isLoyaltyEnabled()) {
            namePanel.add((Component)new FieldPanel(Internationalization.getLiteralFor((String)"CARD_ID") + ": ", this.cardButton, 2), new Rectangle(0, 3, 2, 1));
        }
        JPanel addressPanel = new JPanel();
        addressPanel.setLayout((LayoutManager)new GraphPaperLayout(2, 4));
        addressPanel.setBorder(BorderFactory.createTitledBorder(Internationalization.getLiteralFor((String)"ADDRESS")));
        addressPanel.add((Component)new FieldPanel("<HTML>" + Internationalization.getLiteralFor((String)"HOUSE") + "<BR>" + Internationalization.getLiteralFor((String)"NUMBER") + ":</HTML> ", this.houseNumButton, 1), new Rectangle(0, 0, 1, 1));
        addressPanel.add((Component)new FieldPanel("<HTML>" + Internationalization.getLiteralFor((String)"ROOM_APT") + "<BR>" + Internationalization.getLiteralFor((String)"NUMBER") + ":</HTML> ", this.roomNumButton, 1), new Rectangle(1, 0, 1, 1));
        addressPanel.add((Component)new FieldPanel("<HTML>" + Internationalization.getLiteralFor((String)"STREET") + "<BR>" + Internationalization.getLiteralFor((String)"NAME") + ":</HTML> ", this.streetNameButton, 1), new Rectangle(0, 1, 1, 1));
        addressPanel.add((Component)new FieldPanel("<HTML>" + Internationalization.getLiteralFor((String)"STREET") + "<BR>" + Internationalization.getLiteralFor((String)"TYPE") + ":</HTML> ", this.streetTypeButton, 1), new Rectangle(1, 1, 1, 1));
        addressPanel.add((Component)new FieldPanel(Internationalization.getLiteralFor((String)"SUBURB") + ": ", this.suburbButton, 2), new Rectangle(0, 2, 2, 1));
        addressPanel.add((Component)new FieldPanel("<HTML>" + Internationalization.getLiteralFor((String)"POST") + "<BR>" + Internationalization.getLiteralFor((String)"CODE") + ":</HTML> ", this.postcodeButton, 1), new Rectangle(0, 3, 1, 1));
        addressPanel.add((Component)new FieldPanel(Internationalization.getLiteralFor((String)"STATE") + ":", this.stateButton, 1), new Rectangle(1, 3, 1, 1));
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(1, 8)));
        this.add((Component)namePanel, new Rectangle(0, 0, 1, 4));
        this.add((Component)addressPanel, new Rectangle(0, 4, 1, 4));
    }

    private void initButtons() {
        this.firstNameButton = new JButton();
        this.setupButton(this.firstNameButton, (PropertiedObject.Property<String>)Customer.Properties.FIRST_NAME, Internationalization.getLiteralFor((String)"FIRST_NAME"));
        this.lastNameButton = new JButton();
        this.setupButton(this.lastNameButton, (PropertiedObject.Property<String>)Customer.Properties.LAST_NAME, Internationalization.getLiteralFor((String)"LAST_NAME"));
        this.phoneButton = new JButton();
        this.setupButton(this.phoneButton, (PropertiedObject.Property<String>)Customer.Properties.PRIMARY_PHONE_NUMBER, Internationalization.getLiteralFor((String)"PHONE_NUMBER"));
        this.emailButton = new JButton();
        this.setupButton(this.emailButton, (PropertiedObject.Property<String>)Customer.Properties.E_MAIL, Internationalization.getLiteralFor((String)"EMAIL_ADDRESS"));
        this.cardButton = new JButton();
        this.setupButton(this.cardButton, (PropertiedObject.Property<String>)Customer.Properties.CARD_ID, Internationalization.getLiteralFor((String)"CARD_ID"));
        this.roomNumButton = new JButton();
        this.setupButton(this.roomNumButton, (PropertiedObject.Property<String>)Customer.Properties.ROOM_APT_NUMBER, Internationalization.getLiteralFor((String)"ROOM_APT_NO"));
        this.houseNumButton = new JButton();
        this.setupButton(this.houseNumButton, (PropertiedObject.Property<String>)Customer.Properties.HOUSE_NUMBER, Internationalization.getLiteralFor((String)"HOUSE_NUMBER"));
        this.streetNameButton = new JButton();
        this.setupButton(this.streetNameButton, (PropertiedObject.Property<String>)Customer.Properties.STREET_NAME, Internationalization.getLiteralFor((String)"STREET_NAME"));
        this.streetTypeButton = new JButton();
        this.setupPopupButton(this.streetTypeButton, Customer.Properties.STREET_TYPE, Internationalization.getLiteralFor((String)"STREET_TYPE"), CustomerSearch.makeStreetTypeList().toArray(new String[0]));
        this.suburbButton = new JButton();
        this.setupButton(this.suburbButton, (PropertiedObject.Property<String>)Customer.Properties.SUBURB, Internationalization.getLiteralFor((String)"SUBURB"));
        this.postcodeButton = new JButton();
        this.setupButton(this.postcodeButton, (PropertiedObject.Property<String>)Customer.Properties.POSTCODE, Internationalization.getLiteralFor((String)"POSTCODE"));
        this.stateButton = new JButton();
        this.setupPopupButton(this.stateButton, Customer.Properties.STATE, Internationalization.getLiteralFor((String)"STATE"), CustomerSearch.getStates());
    }

    @Override
    public void reset() {
        this.firstNameButton.setText("");
        this.lastNameButton.setText("");
        this.phoneButton.setText("");
        this.emailButton.setText("");
        this.cardButton.setText("");
        this.roomNumButton.setText("");
        this.houseNumButton.setText("");
        this.streetNameButton.setText("");
        this.streetTypeButton.setText("");
        this.suburbButton.setText("");
        this.postcodeButton.setText("");
        this.stateButton.setText("");
    }

    @Override
    public Object getValue(PropertiedObject.Property property) {
        for (AbstractButton button : this.buttonPropertyMap.keySet()) {
            if (this.buttonPropertyMap.get(button) != property) continue;
            return button.getText();
        }
        return null;
    }

    @Override
    public void setValue(PropertiedObject.Property property, Object value) {
        for (AbstractButton button : this.buttonPropertyMap.keySet()) {
            if (this.buttonPropertyMap.get(button) != property) continue;
            button.setText(value == null ? null : String.valueOf(value));
        }
    }

    private void setupButton(JButton button, PropertiedObject.Property<String> property, String text) {
        button.setName(text);
        button.addActionListener(this);
        this.buttonPropertyMap.put(button, property);
    }

    private void setupPopupButton(final JButton button, final PropertiedObject.Property property, final String text, final String[] selectionOptions) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnePressPopupWindow statePopup = new OnePressPopupWindow(Internationalization.getLiteralFor((String)"SELECT") + " " + text, (Collection)AbstractScrollPaneModel.constructButtons((String[])selectionOptions), 2, 4, true);
                JButton selectedButton = statePopup.start();
                if (selectedButton != null) {
                    String selectedText = selectedButton.getText();
                    button.setText(selectedText);
                    CustomerSearchFieldPanelTSFriendly.this.emitPropertyChange(property, selectedText);
                }
            }
        };
        button.addActionListener(listener);
        this.buttonPropertyMap.put(button, property);
    }

    private void suggestString(AbstractButton button) {
        Object str;
        PropertiedObject.Property property = this.buttonPropertyMap.get(button);
        StringSearcherSuggestor suggestor = this.constructSuggestor((PropertiedObject.Property<String>)property);
        suggestor.setActiveRestriction(Customer.class);
        boolean useNumericKeyPad = false;
        if (property.equals((Object)Customer.Properties.PRIMARY_PHONE_NUMBER)) {
            suggestor.addEquivalentProperty(Customer.Properties.SECONDARY_PHONE_NUMBER);
            useNumericKeyPad = true;
        }
        if ((str = SuggestDialog.getSuggestion(button.getName() + ":", button.getText(), button.getName(), property, useNumericKeyPad, this.fullScreen)) != "\u0000") {
            button.setText((String)str);
            this.emitPropertyChange(property, str);
        }
    }

    private void suggestStreetName(AbstractButton button) {
        PropertiedObject.Property property = this.buttonPropertyMap.get(button);
        StreetDirectorySearcherSuggestor streetSuggestor = new StreetDirectorySearcherSuggestor(StreetDirectoryReference.Properties.STREET_NAME, property);
        Object selection = SuggestDialog.getSuggestion(Internationalization.getLiteralFor((String)"STREET") + ":", this.streetNameButton.getText(), Internationalization.getLiteralFor((String)"STREET"), (Suggestor)streetSuggestor, false, this.fullScreen);
        if (selection != "\u0000") {
            if (selection instanceof StreetDirectoryReference) {
                StreetDirectoryReference ref = (StreetDirectoryReference)selection;
                this.streetNameButton.setText(ref.getStreetName());
                this.streetTypeButton.setText(ref.getStreetType());
                this.suburbButton.setText(ref.getSuburb());
                this.emitPropertyChange(this.buttonPropertyMap.get(this.streetNameButton), this.streetNameButton.getText());
                this.emitPropertyChange(this.buttonPropertyMap.get(this.streetTypeButton), this.streetTypeButton.getText());
                this.emitPropertyChange(this.buttonPropertyMap.get(this.suburbButton), this.suburbButton.getText());
            } else {
                this.streetNameButton.setText(String.valueOf(selection));
                this.emitPropertyChange(this.buttonPropertyMap.get(this.streetNameButton), this.streetNameButton.getText());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.streetNameButton && source instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)source;
            this.suggestStreetName(button);
        } else if (source instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)source;
            this.suggestString(button);
        }
    }

    private static class FieldPanel
    extends JPanel {
        public static final int WIDTH_HALF = 1;
        public static final int WIDTH_FULL = 2;

        public FieldPanel(String text, JComponent component, int widthFlag) {
            switch (widthFlag) {
                case 1: {
                    this.setup(text, component, 10, 4, 6);
                    break;
                }
                default: {
                    this.setup(text, component, 20, 4, 16);
                }
            }
        }

        private void setup(String text, JComponent component, int newTotalWidth, int newLabelWidth, int newComponentWidth) {
            int totalWidth;
            int componentWidth;
            int labelWidth;
            if (newLabelWidth + newComponentWidth > newTotalWidth || newLabelWidth < 0 || newComponentWidth < 0) {
                labelWidth = 4;
                componentWidth = 6;
                totalWidth = 10;
            } else {
                labelWidth = newLabelWidth;
                componentWidth = newComponentWidth;
                totalWidth = newTotalWidth;
            }
            JLabel textLabel = new JLabel(text);
            textLabel.setHorizontalAlignment(4);
            int width = totalWidth;
            boolean height = true;
            int margin = width - labelWidth - componentWidth;
            this.setLayout((LayoutManager)new GraphPaperLayout(width, 1));
            this.add((Component)textLabel, new Rectangle(margin, 0, labelWidth, 1));
            this.add((Component)component, new Rectangle(labelWidth + margin, 0, componentWidth, 1));
        }
    }
}

