/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.users.AllPermissions;
import ordermate.gui.DisplayableString;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.debtor.components.DebtorGroupDrawerPanel;
import waitermate.gui.screens.debtor.components.PaymentStatusDrawPanel;
import waitermate.guikit.NavBar;
import waitermate.guikit.components.DefaultSelectableDrawerPanel;
import waitermate.guikit.components.DrawerToggleButton;
import waitermate.guikit.components.SelectableToggleDrawerPanel;

public class SelectDebtorNavBar
extends NavBar {
    public final Signal newDebtorSignal = Signals.createSignal();
    public final Signal reportSignal = Signals.createSignal();
    public final Signal<String, ?, ?, ?, ?> statusFilterSignal = Signals.createSignal(String.class, (String)"paymentStatus");
    public final Signal<List, ?, ?, ?, ?> groupsFilterSignal = Signals.createSignal(List.class, (String)"debtorGroups");
    DrawerToggleButton groupsFilterButton = this.constructDrawerToggleButton("Groups");
    DrawerToggleButton statusFilterButton = this.constructDrawerToggleButton("Status");
    StandardSecurityDecorator summaryReportButton;
    StandardSecurityDecorator newDebtorButton;
    JButton resetFiltersButton;
    private PaymentStatusDrawPanel paymentStatusDrawPanel;
    boolean hasOtherFilters = false;

    public SelectDebtorNavBar() {
        this(false);
    }

    public SelectDebtorNavBar(boolean showBack) {
        DebtorGroupDrawerPanel groupDrawPanel = new DebtorGroupDrawerPanel();
        groupDrawPanel.changed.connect((Object)this, "gotGroupPanelChanged");
        this.groupsFilterButton.setDrawer((JComponent)((Object)groupDrawPanel));
        this.paymentStatusDrawPanel = new PaymentStatusDrawPanel();
        this.paymentStatusDrawPanel.setSelectAll();
        this.paymentStatusDrawPanel.changed.connect((Object)this, "gotPaymentStatus");
        this.statusFilterButton.setDrawer((JComponent)((Object)this.paymentStatusDrawPanel));
        DefaultSelectableDrawerPanel typeDrawPanel = new DefaultSelectableDrawerPanel(DisplayableString.getDisplayableList((String[])AbstractDebtor.getTypes()), Displayable.class);
        typeDrawPanel.changed.connect((Object)this, "gotDebtorTypeSelected");
        typeDrawPanel.setTitle("Select the type of debtor to filter on");
        this.summaryReportButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/page.png"), "Report", "SummaryReport", new Insets(0, 8, 0, 8), this.reportSignal), AllPermissions.DEBTOR_REPORT);
        this.newDebtorButton = new StandardSecurityDecorator((JComponent)this.constructButton(IconLoader.get((String)"/waitermate/images/addCard.png"), "New", "newDebtor", this.newDebtorSignal), AllPermissions.DEBTOR_CREATE_NEW);
        this.clear.connect((Object)this, "gotResetFilters");
        this.getClearButton().setText("<HTML>Show All<BR>Debtors</HTML>");
        if (showBack) {
            this.addLeft(this.getBackButton());
        }
        this.addLeft((Component)this.groupsFilterButton);
        this.addLeft((Component)this.statusFilterButton);
        this.addLeft(this.getClearButton());
        this.addRight((Component)this.summaryReportButton);
        this.addRight((Component)this.newDebtorButton);
    }

    public void refresh() {
        this.closeAllDrawers();
        DebtorGroupDrawerPanel debtorGroupPanel = (DebtorGroupDrawerPanel)((Object)this.groupsFilterButton.getDrawer());
        if (debtorGroupPanel.getLoadDebtorGroupCount() != debtorGroupPanel.getDebtorGroups().size()) {
            ((SelectableToggleDrawerPanel)this.groupsFilterButton.getDrawer()).changed.disconnect((Object)this);
            DebtorGroupDrawerPanel groupDrawPanel = new DebtorGroupDrawerPanel();
            groupDrawPanel.changed.connect((Object)this, "gotGroupPanelChanged");
            this.groupsFilterButton.setDrawer((JComponent)((Object)groupDrawPanel));
        } else {
            debtorGroupPanel.reset();
        }
        ((PaymentStatusDrawPanel)((Object)this.statusFilterButton.getDrawer())).setSelectAll();
    }

    public void showReportButton(boolean showIt) {
        this.summaryReportButton.setVisible(showIt);
        this.summaryReportButton.setEnabled(showIt);
    }

    public void gotGroupPanelChanged() {
        SelectableToggleDrawerPanel panel = (SelectableToggleDrawerPanel)this.groupsFilterButton.getDrawer();
        this.groupsFilterSignal.emit((Object)panel.getSelectedObjects());
    }

    public void gotPaymentStatus() {
        String status = ((PaymentStatusDrawPanel)((Object)this.statusFilterButton.getDrawer())).getSelectedPaymentStatus();
        this.statusFilterSignal.emit((Object)status);
        this.statusFilterButton.closeDrawer();
    }

    public void gotDebtorTypeSelected() {
    }

    public void setHasExternalFilters(Boolean hasFilters) {
        this.hasOtherFilters = hasFilters;
    }

    public void gotResetFilters() {
        this.paymentStatusDrawPanel.reset();
        this.refresh();
        this.groupsFilterSignal.emit(null);
    }

    private void closeAllDrawers() {
        this.statusFilterButton.closeDrawer();
        this.groupsFilterButton.closeDrawer();
    }

    public void setFilters(List<String> filters) {
        ((PaymentStatusDrawPanel)((Object)this.statusFilterButton.getDrawer())).setToggledStatuses(filters);
    }
}

