/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.sales.Customer;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomButton;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.dialogs.DateSelectDialog;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.KeypadDialog;

public abstract class AbstractDebtorInfoPanel
extends JPanel {
    public final Signal customerSignal = Signals.createSignal();
    public final Signal<AbstractDebtor, ?, ?, ?, ?> debtorSignal = Signals.createSignal(AbstractDebtor.class, (String)"debtor");
    public final Signal<Date, ?, ?, ?, ?> dateChangedSignal = Signals.createSignal(Date.class, (String)"dateFilter");
    public final Signal<String, ?, ?, ?, ?> roomNumChangedSignal = Signals.createSignal(String.class, (String)"roomNumFilter");
    private CustomButton<AbstractDebtor> accountNameButton;
    private JButton roomNumButton;
    private CustomButton<Customer> customerButton;
    private FieldPanel customerFieldPanel;
    private JButton dateRangeButton;
    private AbstractDebtor debtor;
    private Date dateFilter = null;
    private String roomNumberFilter = null;

    public AbstractDebtorInfoPanel(String title, AbstractDebtor newDebtor, boolean usePermissions) {
        this.initButtons();
        this.setLayout((LayoutManager)new GraphPaperLayout(1, 7));
        this.setFont(OrderMateTheme.getLargeFont());
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(OrderMateTheme.getLargeFont());
        this.add((Component)titleLabel, new Rectangle(0, 0, 1, 1));
        if (usePermissions) {
            StandardSecurityDecorator acctDec = new StandardSecurityDecorator(this.accountNameButton, AllPermissions.DEBTOR_EDIT_DETAILS);
            this.add((Component)new FieldPanel("Account ", (JComponent)acctDec), new Rectangle(0, 1, 1, 1));
            StandardSecurityDecorator custDec = new StandardSecurityDecorator(this.customerButton, AllPermissions.DEBTOR_SET_CUSTOMER);
            this.customerFieldPanel = new FieldPanel("Customer", (JComponent)custDec);
        } else {
            this.add((Component)new FieldPanel("Account ", (JComponent)this.accountNameButton), new Rectangle(0, 1, 1, 1));
            this.customerFieldPanel = new FieldPanel("Customer", (JComponent)this.customerButton);
        }
        this.add((Component)this.customerFieldPanel, new Rectangle(0, 2, 1, 1));
        this.add((Component)new FieldPanel("Date", this.dateRangeButton), new Rectangle(0, 3, 1, 1));
        this.add((Component)new FieldPanel("Room #", this.roomNumButton), new Rectangle(0, 4, 1, 1));
        this.clearFilters(null);
        this.setDebtor(newDebtor);
    }

    public void setDebtor(AbstractDebtor newDebtor) {
        this.debtor = newDebtor;
        this.accountNameButton.setData((Displayable)this.debtor);
        this.updateButtonState();
        this.revalidate();
    }

    public abstract void setAccountName(String var1);

    protected abstract void updateButtonState();

    protected AbstractDebtor getDebtor() {
        return this.debtor;
    }

    public Date getStartDateFilter() {
        return this.dateFilter;
    }

    public String getRoomNumberFilter() {
        return this.roomNumberFilter;
    }

    protected void setVisibleCustomerFieldPanel(boolean visible) {
        this.customerFieldPanel.setVisible(visible);
    }

    protected void setCustomerData(Customer cust) {
        this.customerButton.setData((Displayable)cust);
        if (cust != null) {
            this.customerFieldPanel.setVisible(true);
        }
    }

    protected CustomButton getDebtorNameButton() {
        return this.accountNameButton;
    }

    public void clearFilters(Date initialDate) {
        this.accountNameButton.setData(null);
        this.customerButton.setData(null);
        this.roomNumButton.setText(null);
        this.roomNumberFilter = null;
        this.resetDateFilter(initialDate);
    }

    protected void resetDateFilter(Date initialDate) {
        this.setDateFilter(initialDate);
    }

    protected void setDateFilter(Date newFilter) {
        this.dateFilter = newFilter;
        String dateLabel = "";
        if (this.dateFilter != null) {
            dateLabel = DateFormat.getDateInstance(3).format(this.dateFilter);
            dateLabel = dateLabel + " - NOW";
        }
        this.dateRangeButton.setText(dateLabel);
    }

    protected void setRoomNumFilter(String newFilter) {
        this.roomNumberFilter = newFilter;
        this.roomNumButton.setText(newFilter);
    }

    private void initButtons() {
        this.accountNameButton = new CustomButton((Displayable)new SimpleDebtor());
        this.accountNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDebtor data = (AbstractDebtor)AbstractDebtorInfoPanel.this.accountNameButton.getData();
                if (data == null) {
                    data = new SimpleDebtor();
                }
                AbstractDebtorInfoPanel.this.debtorSignal.emit((Object)data);
            }
        });
        this.accountNameButton.showIcon(false);
        this.accountNameButton.showBackgroundColor(false);
        this.accountNameButton.setName("accountName");
        this.customerButton = new CustomButton();
        this.customerButton.setName("customerName");
        this.customerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDebtorInfoPanel.this.customerSignal.emit();
            }
        });
        this.roomNumButton = new JButton();
        this.roomNumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeypadDialog keyDog = new KeypadDialog();
                keyDog.setup(false);
                keyDog.setRenderer(Keypad.STRING_RENDERER);
                if (Dialogs.displayDialog((JComponent)keyDog, (String)"Room Number Seach", (String)"OK", (String)"Close", (boolean)true, (boolean)false, (boolean)true)) {
                    String entered = keyDog.getValue();
                    if (!entered.isEmpty()) {
                        AbstractDebtorInfoPanel.this.setRoomNumFilter(entered);
                    } else {
                        AbstractDebtorInfoPanel.this.setRoomNumFilter(null);
                    }
                    AbstractDebtorInfoPanel.this.roomNumChangedSignal.emit((Object)entered);
                }
            }
        });
        this.dateRangeButton = new JButton();
        this.resetDateFilter(null);
        this.dateRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateSelectDialog dialog = new DateSelectDialog(true);
                dialog.setText("Select history start date");
                if (dialog.go(AbstractDebtorInfoPanel.this.dateFilter)) {
                    AbstractDebtorInfoPanel.this.setDateFilter(dialog.getNewDate());
                    AbstractDebtorInfoPanel.this.dateChangedSignal.emit((Object)AbstractDebtorInfoPanel.this.dateFilter);
                }
            }
        });
    }

    private static class FieldPanel
    extends JPanel {
        public static final int WIDTH_HALF = 1;
        public static final int WIDTH_FULL = 2;

        public FieldPanel(String text, JComponent component) {
            this(text, component, 1);
        }

        public FieldPanel(String text, JComponent component, int widthFlag) {
            switch (widthFlag) {
                case 1: {
                    this.setup(text, component, 10, 3, 7);
                    break;
                }
                default: {
                    this.setup(text, component, 20, 4, 16);
                }
            }
        }

        private void setup(String text, JComponent component, int newTotalWidth, int newLabelWidth, int newComponentWidth) {
            int totalWidth;
            int componentWidth;
            int labelWidth;
            if (newLabelWidth + newComponentWidth > newTotalWidth || newLabelWidth < 0 || newComponentWidth < 0) {
                labelWidth = 4;
                componentWidth = 6;
                totalWidth = 10;
            } else {
                labelWidth = newLabelWidth;
                componentWidth = newComponentWidth;
                totalWidth = newTotalWidth;
            }
            JLabel textLabel = new JLabel(text);
            textLabel.setHorizontalAlignment(4);
            int width = totalWidth;
            boolean height = true;
            int margin = width - labelWidth - componentWidth;
            this.setLayout((LayoutManager)new GraphPaperLayout(width, 1));
            this.add((Component)textLabel, new Rectangle(margin, 0, labelWidth, 1));
            this.add((Component)component, new Rectangle(labelWidth + margin, 0, componentWidth, 1));
            textLabel.setLabelFor(component);
        }
    }
}

