/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.debtor.components;

import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import ordermate.database.EventContext;
import ordermate.database.debtors.DebtorTransactionManager;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.sales.Account;
import ordermate.database.stock.StockUtilities;
import waitermate.LoginManager;
import waitermate.gui.screens.ordering.saveaccount.WaitermateSaveAccount;
import waitermate.gui.screens.payment.transactions.CreditLimitPanel;
import waitermate.guikit.dialogs.Dialogs;

public class DebtorPaymentProcessor {
    public boolean payToDebtor(Account account, AbstractDebtor debtor, DebtorTransactionManager debtorTxnManager) {
        return this.payToDebtor(account, debtor, debtorTxnManager, null);
    }

    public boolean payToDebtor(Account account, AbstractDebtor debtor, DebtorTransactionManager debtorTxnManager, BigDecimal tip) {
        if (!debtor.getUser().equals((Object)account.getUser())) {
            throw new IllegalArgumentException("Debtor and account must be locked by the same user, debtor: " + debtor + " is locked by: " + debtor.getUser() + " and the current account: " + account + " is locked by " + account.getUser());
        }
        if (debtor.isCreditLimited() && debtor.exceedsCreditLimit(account.getDue()) && !CreditLimitPanel.doCreditLimitDialog((CreditLimited)debtor, account.getDue(), debtor.getLabel(), true)) {
            debtor.unlock();
            return false;
        }
        String debtorNote = null;
        if (debtor.isNoteRequired()) {
            while (debtorNote == null || debtorNote.length() >= 100) {
                debtorNote = this.getNote(debtor);
                if (debtorNote.length() < 100) continue;
                Dialogs.displayOkDialog((String)"Note cannot be longer than 100 characters", (String)"Error saving note");
            }
        }
        boolean hasInfo = WaitermateSaveAccount.getInstance().addInfo(account);
        if (StockUtilities.checkAccountOversell((Account)account) && hasInfo) {
            EventContext context = LoginManager.getEventContext();
            debtorTxnManager.commitChanges(context);
            account.closeUnchecked(context);
            WaitermateSaveAccount.getInstance().saveAccount(account, context);
            DebtorSale debtorSale = debtor.addSale(account, new FinanceTransactionContext(context), debtorNote);
            if (tip != null && !BigDecimal.ZERO.equals(tip)) {
                debtorSale.setTip(new Price((Number)tip, 0.0));
            }
            debtor.unlock();
            debtor.save();
            return true;
        }
        return false;
    }

    protected String getNote(AbstractDebtor debtor) {
        return Dialogs.getString((String)"Enter invoice note:", (String)"", (boolean)false);
    }
}

